/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.layouts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GridLayoutExample
extends AbstractExample {
    Figure container;
    Composite composite;
    GridLayout gridLayout;
    Text widthHint;
    Text heightHint;
    Text horizIndent;
    Text vertSpan;
    Text horizSpan;
    Combo vertAlign;
    Combo horizAlign;
    Button grabVSpace;
    Button grabHSpace;
    org.eclipse.swt.layout.GridLayout _layout;
    org.eclipse.swt.layout.GridData _data;
    Shape selectedShape = null;
    Shape prevSelectedShape = null;
    int shapeCount = 0;
    int colorCount = 0;
    Color[] colors = new Color[]{ColorConstants.blue, ColorConstants.red, ColorConstants.yellow, ColorConstants.gray, ColorConstants.green, ColorConstants.lightBlue, ColorConstants.cyan, ColorConstants.darkGreen, ColorConstants.orange};

    public static void main(String[] args) {
        new GridLayoutExample().run();
    }

    @Override
    protected IFigure createContents() {
        this.container = new Figure();
        this.container.setBorder((Border)new LineBorder());
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = false;
        this.container.setLayoutManager((LayoutManager)this.gridLayout);
        this.container.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent event) {
                if (GridLayoutExample.this.selectedShape != null) {
                    GridLayoutExample.this.prevSelectedShape.setLineWidth(1);
                }
                GridLayoutExample.this.prevSelectedShape = null;
                GridLayoutExample.this.selectedShape = null;
                GridLayoutExample.this.setEnableGridDataGroup(false);
            }
        });
        Shape shape = this.createShape();
        this.container.add((IFigure)shape);
        this.container.add((IFigure)this.createShape());
        return this.container;
    }

    protected Shape createShape() {
        Ellipse shape = null;
        shape = switch (this.shapeCount) {
            case 0 -> new Ellipse();
            case 1 -> new RectangleFigure();
            case 2 -> new RoundedRectangle();
            case 3 -> new RectangleFigure();
            case 4 -> new Ellipse();
            case 5 -> new Triangle();
            case 6 -> new RoundedRectangle();
            case 7 -> new Triangle();
            default -> new RoundedRectangle();
        };
        shape.setBackgroundColor(this.colors[this.colorCount]);
        shape.setSize(70, 70);
        shape.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent event) {
                GridLayoutExample.this.selectedShape = (Shape)event.getSource();
                GridLayoutExample.this.setEnableGridDataGroup(true);
                GridLayoutExample.this.selectedShape.setLineWidth(4);
                if (GridLayoutExample.this.prevSelectedShape != null && GridLayoutExample.this.prevSelectedShape != GridLayoutExample.this.selectedShape) {
                    GridLayoutExample.this.prevSelectedShape.setLineWidth(1);
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                GridLayoutExample.this.populateGridDataGroup(d);
                GridLayoutExample.this.prevSelectedShape = GridLayoutExample.this.selectedShape;
            }
        });
        if (this.shapeCount == 8) {
            this.colorCount = 0;
            this.shapeCount = 0;
        } else {
            ++this.shapeCount;
            ++this.colorCount;
        }
        return shape;
    }

    /*
     * WARNING - void declaration
     */
    protected static Integer getEventValue(Event e, String id) {
        try {
            Widget widget = e.widget;
            if (widget instanceof Text) {
                void text;
                Text text2 = (Text)widget;
                Text cfr_ignored_0 = (Text)widget;
                return Integer.parseInt(text.getText());
            }
        }
        catch (NumberFormatException ex) {
            System.out.println("Error: Invalid Number entered for " + id);
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    protected static Integer getEventValue(SelectionEvent e, String id) {
        try {
            Widget widget = e.widget;
            if (widget instanceof Combo) {
                void combo;
                Combo combo2 = (Combo)widget;
                Combo cfr_ignored_0 = (Combo)widget;
                return Integer.parseInt(combo.getText());
            }
        }
        catch (NumberFormatException ex) {
            System.out.println("Error: Invalid Number entered for " + id);
        }
        return 5;
    }

    protected void updateView() {
        this.getContents().revalidate();
        this.getShell().pack();
    }

    protected void createColumnGroup() {
        Group columnsGroup = new Group(this.composite, 0);
        columnsGroup.setText("Columns");
        this._layout = new org.eclipse.swt.layout.GridLayout();
        this._layout.numColumns = 2;
        columnsGroup.setLayout((Layout)this._layout);
        this._data = new org.eclipse.swt.layout.GridData(16);
        columnsGroup.setLayoutData((Object)this._data);
        Text numColumns = new Text((Composite)columnsGroup, 2048);
        numColumns.setText("2");
        Listener numColumnsListener = e -> {
            this.gridLayout.numColumns = GridLayoutExample.getEventValue(e, "numColumns");
            this.updateView();
        };
        numColumns.addListener(14, numColumnsListener);
        numColumns.addListener(16, numColumnsListener);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 15;
        numColumns.setLayoutData((Object)this._data);
        new Label((Composite)columnsGroup, 0).setText("numColumns");
        Button makeColumnsEqualWidth = new Button((Composite)columnsGroup, 32);
        makeColumnsEqualWidth.setText("makeColumnsEqualWidth");
        makeColumnsEqualWidth.setSelection(false);
        makeColumnsEqualWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.gridLayout.makeColumnsEqualWidth = !GridLayoutExample.this.gridLayout.makeColumnsEqualWidth;
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.horizontalSpan = 2;
        this._data.horizontalIndent = 14;
        makeColumnsEqualWidth.setLayoutData((Object)this._data);
    }

    protected void createMarginGroup() {
        Group marginGroup = new Group(this.composite, 0);
        marginGroup.setLayout((Layout)new FillLayout(512));
        marginGroup.setText("Margins and Spacing");
        String[] marginValues = new String[]{"0", "3", "5", "10"};
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.verticalSpan = 2;
        marginGroup.setLayoutData((Object)this._data);
        this._layout = new org.eclipse.swt.layout.GridLayout();
        this._layout.numColumns = 2;
        marginGroup.setLayout((Layout)this._layout);
        new Label((Composite)marginGroup, 0).setText("marginHeight");
        Combo marginHeight = new Combo((Composite)marginGroup, 0);
        marginHeight.setItems(marginValues);
        marginHeight.select(2);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 60;
        marginHeight.setLayoutData((Object)this._data);
        marginHeight.addListener(14, e -> {
            this.gridLayout.marginHeight = GridLayoutExample.getEventValue(e, "marginHeight");
            this.updateView();
        });
        marginHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.gridLayout.marginHeight = GridLayoutExample.getEventValue(e, "marginHeight");
                GridLayoutExample.this.updateView();
            }
        });
        new Label((Composite)marginGroup, 0).setText("marginWidth");
        Combo marginWidth = new Combo((Composite)marginGroup, 0);
        marginWidth.setItems(marginValues);
        marginWidth.select(2);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 60;
        marginWidth.setLayoutData((Object)this._data);
        marginWidth.addListener(14, e -> {
            this.gridLayout.marginWidth = GridLayoutExample.getEventValue(e, "marginWidth");
            this.updateView();
        });
        marginWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.gridLayout.marginWidth = GridLayoutExample.getEventValue(e, "marginWidth");
                GridLayoutExample.this.updateView();
            }
        });
        new Label((Composite)marginGroup, 0).setText("horizontalSpacing");
        Combo horizontalSpacing = new Combo((Composite)marginGroup, 0);
        horizontalSpacing.setItems(marginValues);
        horizontalSpacing.select(2);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 60;
        horizontalSpacing.setLayoutData((Object)this._data);
        horizontalSpacing.addListener(14, e -> {
            this.gridLayout.horizontalSpacing = GridLayoutExample.getEventValue(e, "horizontalSpacing");
            this.updateView();
        });
        horizontalSpacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.gridLayout.horizontalSpacing = GridLayoutExample.getEventValue(e, "horizontalSpacing");
                GridLayoutExample.this.updateView();
            }
        });
        new Label((Composite)marginGroup, 0).setText("verticalSpacing");
        Combo verticalSpacing = new Combo((Composite)marginGroup, 0);
        verticalSpacing.setItems(marginValues);
        verticalSpacing.select(2);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 60;
        verticalSpacing.setLayoutData((Object)this._data);
        verticalSpacing.addListener(14, e -> {
            this.gridLayout.verticalSpacing = GridLayoutExample.getEventValue(e, "verticalSpacing");
            this.updateView();
        });
        verticalSpacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.gridLayout.verticalSpacing = GridLayoutExample.getEventValue(e, "verticalSpacing");
                GridLayoutExample.this.updateView();
            }
        });
    }

    protected void createChildGroup() {
        Group childGroup = new Group(this.composite, 0);
        childGroup.setText("Children");
        org.eclipse.swt.layout.GridLayout layout = new org.eclipse.swt.layout.GridLayout();
        layout.numColumns = 3;
        childGroup.setLayout((Layout)layout);
        org.eclipse.swt.layout.GridData data = new org.eclipse.swt.layout.GridData(768);
        data.horizontalSpan = 2;
        childGroup.setLayoutData((Object)data);
        Button add = new Button((Composite)childGroup, 8);
        add.setText("Add");
        add.setLayoutData((Object)new org.eclipse.swt.layout.GridData(768));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.container.add((IFigure)GridLayoutExample.this.createShape());
                GridLayoutExample.this.updateView();
            }
        });
        Button clear = new Button((Composite)childGroup, 8);
        clear.setText("Clear All");
        clear.setLayoutData((Object)new org.eclipse.swt.layout.GridData(768));
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.container.removeAll();
                GridLayoutExample.this.setEnableGridDataGroup(false);
                GridLayoutExample.this.updateView();
            }
        });
    }

    protected void createGridDataGroup() {
        String[] alignValues = new String[]{"BEGINNING", "CENTER", "END", "FILL"};
        Group gridDataGroup = new Group(this.composite, 0);
        gridDataGroup.setText("Selected Figure's GridData");
        this._layout = new org.eclipse.swt.layout.GridLayout();
        this._layout.numColumns = 2;
        gridDataGroup.setLayout((Layout)this._layout);
        this._data = new org.eclipse.swt.layout.GridData(16);
        gridDataGroup.setLayoutData((Object)this._data);
        this.widthHint = new Text((Composite)gridDataGroup, 2048);
        this.widthHint.setText("-1");
        Listener gridDataListener = e -> {
            if (this.selectedShape == null) {
                return;
            }
            GridData d = (GridData)this.gridLayout.getConstraint((IFigure)this.selectedShape);
            d.widthHint = GridLayoutExample.getEventValue(e, "widthHint");
            this.updateView();
        };
        this.widthHint.addListener(14, gridDataListener);
        this.widthHint.addListener(16, gridDataListener);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 35;
        this.widthHint.setLayoutData((Object)this._data);
        new Label((Composite)gridDataGroup, 0).setText("widthHint");
        this.heightHint = new Text((Composite)gridDataGroup, 2048);
        this.heightHint.setText("-1");
        Listener heightHintListener = e -> {
            if (this.selectedShape == null) {
                return;
            }
            GridData d = (GridData)this.gridLayout.getConstraint((IFigure)this.selectedShape);
            d.heightHint = GridLayoutExample.getEventValue(e, "heightHint");
            this.updateView();
        };
        this.heightHint.addListener(14, heightHintListener);
        this.heightHint.addListener(16, heightHintListener);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 35;
        this.heightHint.setLayoutData((Object)this._data);
        new Label((Composite)gridDataGroup, 0).setText("heightHint");
        this.horizAlign = new Combo((Composite)gridDataGroup, 8);
        this.horizAlign.setItems(alignValues);
        this.horizAlign.select(0);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 110;
        this.horizAlign.setLayoutData((Object)this._data);
        this.horizAlign.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                String align = ((Combo)e.widget).getText();
                d.horizontalAlignment = GridLayoutExample.findAlignment(align);
                GridLayoutExample.this.updateView();
            }
        });
        new Label((Composite)gridDataGroup, 0).setText("horizontalAlignment");
        this.vertAlign = new Combo((Composite)gridDataGroup, 8);
        this.vertAlign.setItems(alignValues);
        this.vertAlign.select(0);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 110;
        this.vertAlign.setLayoutData((Object)this._data);
        this.vertAlign.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                String align = ((Combo)e.widget).getText();
                d.verticalAlignment = GridLayoutExample.findAlignment(align);
                GridLayoutExample.this.updateView();
            }
        });
        new Label((Composite)gridDataGroup, 0).setText("verticalAlignment");
        this.horizIndent = new Text((Composite)gridDataGroup, 2048);
        this.horizIndent.setText("0");
        Listener horizontalIndentListener = e -> {
            if (this.selectedShape == null) {
                return;
            }
            GridData d = (GridData)this.gridLayout.getConstraint((IFigure)this.selectedShape);
            d.horizontalIndent = GridLayoutExample.getEventValue(e, "horizontalIndent");
            this.updateView();
        };
        this.horizIndent.addListener(14, horizontalIndentListener);
        this.horizIndent.addListener(16, horizontalIndentListener);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 35;
        this.horizIndent.setLayoutData((Object)this._data);
        new Label((Composite)gridDataGroup, 0).setText("horizontalIndent");
        this.horizSpan = new Text((Composite)gridDataGroup, 2048);
        this.horizSpan.setText("1");
        Listener horizontalSpanListener = e -> {
            if (this.selectedShape == null) {
                return;
            }
            GridData d = (GridData)this.gridLayout.getConstraint((IFigure)this.selectedShape);
            d.horizontalSpan = GridLayoutExample.getEventValue(e, "horizontalSpan");
            this.updateView();
        };
        this.horizSpan.addListener(14, horizontalSpanListener);
        this.horizSpan.addListener(16, horizontalSpanListener);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 35;
        this.horizSpan.setLayoutData((Object)this._data);
        new Label((Composite)gridDataGroup, 0).setText("horizontalSpan");
        this.vertSpan = new Text((Composite)gridDataGroup, 2048);
        this.vertSpan.setText("1");
        Listener verticalSpanListener = e -> {
            if (this.selectedShape == null) {
                return;
            }
            GridData d = (GridData)this.gridLayout.getConstraint((IFigure)this.selectedShape);
            d.verticalSpan = GridLayoutExample.getEventValue(e, "verticalSpan");
            this.updateView();
        };
        this.vertSpan.addListener(14, verticalSpanListener);
        this.vertSpan.addListener(16, verticalSpanListener);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 35;
        this.vertSpan.setLayoutData((Object)this._data);
        new Label((Composite)gridDataGroup, 0).setText("verticalSpan");
        this.grabHSpace = new Button((Composite)gridDataGroup, 32);
        this.grabHSpace.setText("grabExcessHorizontalSpace");
        this.grabHSpace.setSelection(false);
        this.grabHSpace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                d.grabExcessHorizontalSpace = !d.grabExcessHorizontalSpace;
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.horizontalSpan = 2;
        this._data.horizontalIndent = 14;
        this.grabHSpace.setLayoutData((Object)this._data);
        this.grabVSpace = new Button((Composite)gridDataGroup, 32);
        this.grabVSpace.setText("grabExcessVerticalSpace");
        this.grabVSpace.setSelection(false);
        this.grabVSpace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                d.grabExcessVerticalSpace = !d.grabExcessVerticalSpace;
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.horizontalSpan = 2;
        this._data.horizontalIndent = 14;
        this.grabVSpace.setLayoutData((Object)this._data);
        this.setEnableGridDataGroup(false);
    }

    protected void setEnableGridDataGroup(boolean enable) {
        this.widthHint.setEnabled(enable);
        this.heightHint.setEnabled(enable);
        this.horizIndent.setEnabled(enable);
        this.vertSpan.setEnabled(enable);
        this.horizSpan.setEnabled(enable);
        this.vertAlign.setEnabled(enable);
        this.horizAlign.setEnabled(enable);
        this.grabVSpace.setEnabled(enable);
        this.grabHSpace.setEnabled(enable);
    }

    protected void populateGridDataGroup(GridData d) {
        this.widthHint.setText(Integer.toString(d.widthHint));
        this.heightHint.setText(Integer.toString(d.heightHint));
        this.horizIndent.setText(Integer.toString(d.horizontalIndent));
        this.vertSpan.setText(Integer.toString(d.verticalSpan));
        this.horizSpan.setText(Integer.toString(d.horizontalSpan));
        this.vertAlign.select(GridLayoutExample.findAlignment(d.verticalAlignment));
        this.horizAlign.select(GridLayoutExample.findAlignment(d.horizontalAlignment));
        this.grabVSpace.setSelection(d.grabExcessVerticalSpace);
        this.grabHSpace.setSelection(d.grabExcessHorizontalSpace);
    }

    protected static int findAlignment(int align) {
        switch (align) {
            case 1: {
                return 0;
            }
            case 0x1000000: {
                return 1;
            }
            case 0x1000008: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return -1;
    }

    protected static int findAlignment(String align) {
        if (align.equals("BEGINNING")) {
            return 1;
        }
        if (align.equals("CENTER")) {
            return 0x1000000;
        }
        if (align.equals("END")) {
            return 0x1000008;
        }
        if (align.equals("FILL")) {
            return 4;
        }
        return -1;
    }

    @Override
    protected void hookShell(Shell shell) {
        this.composite = new Composite((Composite)shell, 0);
        this._data = new org.eclipse.swt.layout.GridData(1040);
        this._data.widthHint = 300;
        this.composite.setLayoutData((Object)this._data);
        this.composite.setLayout((Layout)new org.eclipse.swt.layout.GridLayout());
        this.createColumnGroup();
        this.createMarginGroup();
        this.createChildGroup();
        this.createGridDataGroup();
    }
}

