/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.commands.ExampleTextCommand;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;

public class SingleEditCommand
extends ExampleTextCommand {
    private final MiniEdit edit;
    private final ModelLocation end;
    private final ModelLocation start;

    public SingleEditCommand(MiniEdit edit, ModelLocation start, ModelLocation end) {
        super("");
        this.edit = edit;
        this.start = start;
        this.end = end;
    }

    public void execute() {
        this.edit.apply();
    }

    @Override
    public SelectionRange getExecuteSelectionRange(GraphicalTextViewer viewer) {
        ModelLocation loc = this.edit.getResultingLocation();
        if (loc != null) {
            return new SelectionRange(SingleEditCommand.lookupModel(viewer, loc.model), loc.offset);
        }
        return this.getUndoSelectionRange(viewer);
    }

    @Override
    public SelectionRange getRedoSelectionRange(GraphicalTextViewer viewer) {
        return this.getExecuteSelectionRange(viewer);
    }

    @Override
    public SelectionRange getUndoSelectionRange(GraphicalTextViewer viewer) {
        TextLocation startLoc = new TextLocation(SingleEditCommand.lookupModel(viewer, this.start.model), this.start.offset);
        TextLocation endLoc = new TextLocation(SingleEditCommand.lookupModel(viewer, this.end.model), this.end.offset);
        return new SelectionRange(startLoc, endLoc);
    }

    public void redo() {
        this.edit.reapply();
    }

    public void undo() {
        this.edit.rollback();
    }
}

