/*******************************************************************************
 * Copyright (c) 2000, 2022 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;

public class LiveOutputFeedbackFigure extends LiveOutputFigure {

	/**
	 * @see org.eclipse.draw2d.Figure#paintFigure(Graphics)
	 */
	@Override
	protected void paintFigure(Graphics g) {
		g.setXORMode(true);
		g.setForegroundColor(ColorConstants.white);

		g.setBackgroundColor(LogicColorConstants.ghostFillColor);

		Rectangle r = getBounds().getCopy();

		g.fillOval(r);
		r.height--;
		r.width--;
		g.drawOval(r);
		g.translate(r.getLocation());

		// Draw the "V"
		g.drawLine(3, 4, 5, 9);
		g.drawLine(5, 9, 7, 4);
		g.drawLine(5, 8, 5, 9);

		// Draw the "+"
		g.drawLine(9, 7, 9, 11);
		g.drawLine(7, 9, 11, 9);
		g.drawPoint(9, 9);
	}

}
