/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class InfoTextLayoutHitTest {
    static Image image;
    static Font font;
    static Button selectFont;
    static TextLayout layout;
    static Color[] wheel;
    static int wheelIndex;
    static Color defaultColor;
    static Point mouse;

    static {
        font = new Font(null, "", 30, 0);
        wheel = new Color[6];
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        final Shell shell = new Shell();
        InfoTextLayoutHitTest.wheel[0] = new Color((Device)display, 255, 255, 100);
        InfoTextLayoutHitTest.wheel[1] = new Color((Device)display, 255, 160, 160);
        InfoTextLayoutHitTest.wheel[2] = new Color((Device)display, 255, 100, 255);
        InfoTextLayoutHitTest.wheel[3] = new Color((Device)display, 160, 160, 255);
        InfoTextLayoutHitTest.wheel[4] = new Color((Device)display, 100, 255, 255);
        InfoTextLayoutHitTest.wheel[5] = new Color((Device)display, 160, 255, 160);
        defaultColor = new Color((Device)display, 255, 50, 50);
        layout = new TextLayout((Device)display);
        layout.setFont(font);
        layout.setText("GEF! @ This is a test for hit testing \ufeec\ufeeb\ufeed bidi");
        int width = 290;
        layout.setWidth(width - 40);
        int height = InfoTextLayoutHitTest.layout.getBounds().height + 40;
        image = new Image((Device)display, width, height);
        GC gc = new GC((Drawable)image);
        int[] trailing = new int[1];
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int offset = layout.getOffset(x - 20, y - 20, trailing);
                if (offset == -1) {
                    gc.setForeground(defaultColor);
                } else {
                    gc.setForeground(wheel[(offset + trailing[0]) % 6]);
                }
                if (InfoTextLayoutHitTest.layout.getLocation((int)offset, (boolean)(trailing[0] == 1 ? true : false)).x != x - 20) {
                    gc.drawPoint(x, y);
                }
                ++y;
            }
            ++x;
        }
        gc.setForeground(new Color(null, 0, 0, 0));
        layout.draw(gc, 20, 20);
        gc.dispose();
        shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(image, 0, 0);
                if (mouse != null) {
                    int[] trail = new int[1];
                    int offset = layout.getOffset(mouse, trail);
                    Point where = layout.getLocation(offset, trail[0] == 1);
                    e.gc.drawOval(where.x + 19, where.y + 19, 2, 2);
                }
            }
        });
        shell.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                mouse = new Point(e.x - 20, e.y - 20);
                shell.redraw();
            }
        });
        shell.setSize(400, 300);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

