/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.edit;

import java.util.Iterator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.actions.StyleService;
import org.eclipse.gef.examples.text.edit.BlockEditPolicy;
import org.eclipse.gef.examples.text.edit.BlockTextPart;
import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.gef.examples.text.edit.TextStyleManager;
import org.eclipse.gef.examples.text.model.Style;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.requests.CaretRequest;
import org.eclipse.gef.examples.text.requests.SearchResult;

public class DocumentPart
extends BlockTextPart
implements TextStyleManager {
    public DocumentPart(Object model) {
        super(model);
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("Text Editing", (EditPolicy)new BlockEditPolicy());
    }

    public Object getAdapter(Class key) {
        if (key == TextStyleManager.class) {
            return this;
        }
        return super.getAdapter(key);
    }

    public TextLocation getLocation(Point absolute) {
        return null;
    }

    @Override
    public void getTextLocation(CaretRequest search, SearchResult result) {
        if (search.getType() == CaretRequest.DOCUMENT) {
            search.isInto = true;
            search.isForward = !search.isForward;
            search.isRecursive = true;
            search.setType(CaretRequest.COLUMN);
        }
        super.getTextLocation(search, result);
    }

    @Override
    public Object getStyleState(String styleID, SelectionRange range) {
        return StyleService.STATE_EDITABLE;
    }

    @Override
    public Object getStyleValue(String styleID, SelectionRange range) {
        if (styleID.equals("bold")) {
            Iterator iter = range.getLeafParts().iterator();
            while (iter.hasNext()) {
                TextRun run = (TextRun)((TextEditPart)iter.next()).getModel();
                if (run.getContainer().getStyle().isBold()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (styleID.equals("fontSize")) {
            int fontHeight = -1;
            Iterator iter = range.getLeafParts().iterator();
            while (iter.hasNext()) {
                TextRun run = (TextRun)((TextEditPart)iter.next()).getModel();
                if (fontHeight == -1) {
                    fontHeight = run.getContainer().getStyle().getFontHeight();
                    continue;
                }
                if (fontHeight == run.getContainer().getStyle().getFontHeight()) continue;
                return StyleService.UNDEFINED;
            }
            return new Integer(fontHeight);
        }
        if (styleID.equals("font")) {
            String fontName = null;
            Iterator iter = range.getLeafParts().iterator();
            while (iter.hasNext()) {
                TextRun run = (TextRun)((TextEditPart)iter.next()).getModel();
                if (fontName == null) {
                    fontName = run.getContainer().getStyle().getFontFamily();
                    continue;
                }
                if (fontName.equals(run.getContainer().getStyle().getFontFamily())) continue;
                return StyleService.UNDEFINED;
            }
            return fontName;
        }
        if (styleID.equals("italics")) {
            Iterator iter = range.getLeafParts().iterator();
            while (iter.hasNext()) {
                TextRun run = (TextRun)((TextEditPart)iter.next()).getModel();
                if (run.getContainer().getStyle().isItalic()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (styleID.equals("underline")) {
            Iterator iter = range.getLeafParts().iterator();
            while (iter.hasNext()) {
                TextRun run = (TextRun)((TextEditPart)iter.next()).getModel();
                if (run.getContainer().getStyle().isUnderline()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ("alignment".equals(styleID)) {
            int alignment = 0;
            Iterator iter = range.getLeafParts().iterator();
            while (iter.hasNext()) {
                TextRun run = (TextRun)((TextEditPart)iter.next()).getModel();
                Style style = run.getBlockContainer().getStyle();
                if (alignment == 0) {
                    alignment = style.getAlignment();
                }
                if (style.isSet(styleID) && style.getAlignment() == alignment) continue;
                return StyleService.UNDEFINED;
            }
            return new Integer(alignment);
        }
        if ("orientation".equals(styleID)) {
            int orientation = 0;
            Iterator iter = range.getLeafParts().iterator();
            while (iter.hasNext()) {
                TextRun run = (TextRun)((TextEditPart)iter.next()).getModel();
                Style style = run.getBlockContainer().getStyle();
                if (orientation == 0) {
                    orientation = style.getOrientation();
                }
                if (style.isSet(styleID) && style.getOrientation() == orientation) continue;
                return StyleService.UNDEFINED;
            }
            return new Integer(orientation);
        }
        return StyleService.UNDEFINED;
    }
}

