/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.graph;

import java.lang.reflect.Method;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.examples.graph.AbstractGraphDemo;
import org.eclipse.draw2d.examples.graph.GraphTests;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;

public class DirectedGraphDemo
extends AbstractGraphDemo {
    public static Figure buildGraph(DirectedGraph graph) {
        Panel contents = new Panel();
        contents.setBackgroundColor(ColorConstants.white);
        contents.setLayoutManager((LayoutManager)new XYLayout());
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = graph.nodes.getNode(i);
            DirectedGraphDemo.buildNodeFigure((Figure)contents, node);
            ++i;
        }
        i = 0;
        while (i < graph.edges.size()) {
            Edge edge = graph.edges.getEdge(i);
            DirectedGraphDemo.buildEdgeFigure((Figure)contents, edge);
            ++i;
        }
        return contents;
    }

    public static void main(String[] args) {
        new DirectedGraphDemo().run();
    }

    @Override
    protected String[] getGraphMethods() {
        Method[] methods = GraphTests.class.getMethods();
        String[] methodNames = new String[methods.length];
        int nameIndex = 0;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getReturnType().equals(DirectedGraph.class)) {
                methodNames[nameIndex] = methods[i].getName();
                ++nameIndex;
            }
            ++i;
        }
        return methodNames;
    }

    @Override
    protected IFigure getContents() {
        DirectedGraph graph = null;
        try {
            graph = (DirectedGraph)GraphTests.class.getMethod(graphMethod, Integer.TYPE).invoke(null, new Integer(graphDirection));
        }
        catch (Exception e) {
            System.out.println("Could not build graph");
            e.printStackTrace();
        }
        Figure contents = DirectedGraphDemo.buildGraph(graph);
        return contents;
    }
}

