/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.ListProblemPreference;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.resources.IResource;

public class MagicNumberChecker
extends AbstractIndexAstChecker {
    public static final String ERR_ID = "org.eclipse.cdt.codan.internal.checkers.MagicNumberProblem";
    private static final String OPERATOR_PAREN = "operator ()";
    public static final String PARAM_ARRAY = "checkArray";
    public static final String PARAM_EXCEPTIONS = "exceptions";
    public static final String PARAM_OPERATOR_PAREN = "checkOperatorParen";
    private Set<Long> allowedLongValues = new HashSet<Long>();
    private Set<Double> allowedDoubleValues = new HashSet<Double>();
    private boolean checkArray;
    private boolean checkOperatorParen;

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_ARRAY, CheckersMessages.MagicNumberChecker_ParameterArray, Boolean.TRUE);
        this.addPreference(problem, PARAM_OPERATOR_PAREN, CheckersMessages.MagicNumberChecker_ParameterOperatorParen, Boolean.TRUE);
        ListProblemPreference list = this.addListPreference(problem, PARAM_EXCEPTIONS, CheckersMessages.GenericParameter_ParameterExceptions, CheckersMessages.GenericParameter_ParameterExceptionsItem);
        list.addChildValue((Object)"1");
        list.addChildValue((Object)"0");
        list.addChildValue((Object)"-1");
        list.addChildValue((Object)"2");
        list.addChildValue((Object)"1.0");
        list.addChildValue((Object)"0.0");
        list.addChildValue((Object)"-1.0");
    }

    private void initExceptions() {
        Object[] arr;
        this.allowedLongValues.clear();
        this.allowedDoubleValues.clear();
        Object[] objectArray = arr = (Object[])this.getPreference(this.getProblemById(ERR_ID, (IResource)this.getFile()), PARAM_EXCEPTIONS);
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            String s = (String)o;
            try {
                this.allowedLongValues.add(Long.parseLong(s));
            }
            catch (NumberFormatException e) {
                try {
                    this.allowedDoubleValues.add(Double.parseDouble(s));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public void processAst(IASTTranslationUnit ast) {
        IProblem pt = this.getProblemById(ERR_ID, (IResource)this.getFile());
        this.checkArray = (Boolean)this.getPreference(pt, PARAM_ARRAY);
        this.checkOperatorParen = (Boolean)this.getPreference(pt, PARAM_OPERATOR_PAREN);
        this.initExceptions();
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitExpressions = true;
            }

            public int visit(IASTExpression expression) {
                if (expression instanceof IASTLiteralExpression) {
                    if (MagicNumberChecker.enclosedInMacroExpansion((IASTNode)((IASTNode)expression))) {
                        return 3;
                    }
                    IASTInitializer node = (IASTInitializer)ASTQueries.findAncestorWithType((IASTNode)expression, IASTInitializer.class);
                    if (node != null) {
                        return 3;
                    }
                    IASTNode parent = expression.getParent();
                    if (!MagicNumberChecker.this.checkArray && (parent instanceof IASTArrayModifier || parent instanceof IASTArrayDeclarator || parent instanceof IASTArraySubscriptExpression)) {
                        return 3;
                    }
                    IASTEnumerationSpecifier.IASTEnumerator enums = (IASTEnumerationSpecifier.IASTEnumerator)ASTQueries.findAncestorWithType((IASTNode)expression, IASTEnumerationSpecifier.IASTEnumerator.class);
                    if (enums != null) {
                        return 3;
                    }
                    if (!MagicNumberChecker.this.checkOperatorParen && MagicNumberChecker.this.isOperatorParen(expression)) {
                        return 3;
                    }
                    IASTLiteralExpression literal = (IASTLiteralExpression)expression;
                    int kind = literal.getKind();
                    switch (kind) {
                        case 1: {
                            Number value = ValueFactory.getConstantNumericalValue((IASTExpression)expression);
                            if (MagicNumberChecker.this.allowedDoubleValues.contains(value.doubleValue())) break;
                            MagicNumberChecker.this.reportProblem(MagicNumberChecker.ERR_ID, (IASTNode)expression, new Object[0]);
                            break;
                        }
                        case 0: {
                            Number value = ValueFactory.getConstantNumericalValue((IASTExpression)expression);
                            if (MagicNumberChecker.this.allowedLongValues.contains(value.longValue())) break;
                            MagicNumberChecker.this.reportProblem(MagicNumberChecker.ERR_ID, (IASTNode)expression, new Object[0]);
                            break;
                        }
                        default: {
                            return 3;
                        }
                    }
                }
                return 3;
            }
        });
    }

    private boolean referencesThis(IASTNode expr) {
        if (expr instanceof IASTLiteralExpression) {
            IASTLiteralExpression litArg = (IASTLiteralExpression)expr;
            if (litArg.getKind() == 4) {
                return true;
            }
        } else if (expr instanceof ICPPASTUnaryExpression) {
            ICPPASTUnaryExpression unExpr = (ICPPASTUnaryExpression)expr;
            switch (unExpr.getOperator()) {
                case 4: 
                case 5: 
                case 11: {
                    return this.referencesThis((IASTNode)unExpr.getOperand());
                }
            }
        }
        return false;
    }

    private boolean isOperatorParen(IASTExpression expression) {
        ICPPASTFunctionCallExpression func = (ICPPASTFunctionCallExpression)ASTQueries.findAncestorWithType((IASTNode)expression, ICPPASTFunctionCallExpression.class);
        if (func == null) {
            return false;
        }
        IASTExpression funcName = func.getFunctionNameExpression();
        if (funcName instanceof ICPPASTFieldReference && Arrays.equals(OPERATOR_PAREN.toCharArray(), ((ICPPASTFieldReference)funcName).getFieldName().getSimpleID())) {
            return true;
        }
        if (!(funcName instanceof IASTIdExpression) && !this.referencesThis((IASTNode)funcName)) {
            return false;
        }
        IType type = SemanticUtil.getUltimateType((IType)funcName.getExpressionType(), (boolean)true);
        if (type instanceof ICPPClassType) {
            ICPPMethod[] methods;
            ICPPMethod[] iCPPMethodArray = methods = ((ICPPClassType)type).getAllDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod m = iCPPMethodArray[n2];
                if (OPERATOR_PAREN.equals(m.getName())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

