/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.controls.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class CLaunchButton
extends Canvas {
    private Image image;
    private boolean hover;
    private boolean pressed;

    public CLaunchButton(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(e -> {
            if (this.pressed && this.hover) {
                e.gc.setBackground(this.getDisplay().getSystemColor(18));
            } else if (this.hover) {
                e.gc.setBackground(this.getDisplay().getSystemColor(20));
            } else {
                e.gc.setBackground(this.getBackground());
            }
            int arc = 3;
            Point size = this.getSize();
            e.gc.fillRoundRectangle(0, 0, size.x - 1, size.y - 1, arc, arc);
            if (this.image != null) {
                e.gc.drawImage(this.image, 10, 5);
            }
            e.gc.setForeground(this.getDisplay().getSystemColor(18));
            e.gc.drawRoundRectangle(0, 0, size.x - 1, size.y - 1, arc, arc);
        });
        this.addMouseMoveListener(e -> {
            Object object = e.getSource();
            if (object instanceof Control) {
                Control button = (Control)object;
                Point size = button.getSize();
                this.hover = e.x >= 0 && e.x < size.x && e.y >= 0 && e.y < size.y;
                this.redraw();
            }
        });
        this.addMouseTrackListener(MouseTrackListener.mouseEnterAdapter(e -> {
            this.hover = true;
            this.redraw();
        }));
        this.addMouseTrackListener(MouseTrackListener.mouseExitAdapter(e -> {
            this.hover = false;
            this.redraw();
        }));
        this.addMouseListener(MouseListener.mouseDownAdapter(e -> {
            this.pressed = true;
            this.redraw();
        }));
        this.addMouseListener(MouseListener.mouseUpAdapter(e -> {
            if (this.pressed && this.hover) {
                this.notifyListeners(13, null);
            }
            this.pressed = false;
            this.redraw();
        }));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 0;
        int height = 0;
        if (this.image != null) {
            Rectangle bounds = this.image.getBounds();
            width = bounds.width + 20;
            height = bounds.height + 10;
        }
        return new Point(width, height);
    }

    public void setImage(Image image) {
        this.image = image;
        this.redraw();
    }
}

