/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.refactoring.pullout;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.refactoring.pullout.AspectInputContentAssistProcessor;
import org.eclipse.ajdt.internal.ui.refactoring.pullout.AspectSelectionFilter;
import org.eclipse.ajdt.internal.ui.refactoring.pullout.JavaCellLabelProvider;
import org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class PullOutRefactoringInputPage
extends UserInputWizardPage {
    private Text targetAspectInput;
    private TableViewerColumn typeColumn;
    private TableViewerColumn memberColumn;
    private JavaUILabelProvider labelProvider = new JavaUILabelProvider();
    private TableViewerColumn packageColumn;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;

    public PullOutRefactoringInputPage(String name) {
        super(name);
    }

    private Text createAspectInput(Composite composite) {
        Text textBox = new Text(composite, 2052);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)textBox);
        return textBox;
    }

    public void createControl(Composite parent) {
        this.getRefactoring();
        parent = new Composite(parent, 4);
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        this.setControl((Control)parent);
        Label label = new Label(parent, 0);
        label.setText("The following element will be pulled out:");
        this.createTable(parent);
        this.createAspectGroup(parent);
        this.createITDGroup(parent);
        this.handleInputChanged();
    }

    private void createAspectGroup(Composite parent) {
        final PullOutRefactoring refactoring = this.getRefactoring();
        Group group = new Group(parent, -1);
        group.setText("Target Aspect");
        group.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        this.createTargetAspectLine((Composite)group);
        final Button makePrivilegeCheckBox = new Button((Composite)group, 32);
        makePrivilegeCheckBox.setSelection(refactoring.isMakePrivileged());
        makePrivilegeCheckBox.setText("&Make the Aspect Privileged");
        makePrivilegeCheckBox.setToolTipText("The aspect will be made privileged\nITDs in privileged aspects can access private and protected members in thewoven context without errors.");
        makePrivilegeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setMakePrivileged(makePrivilegeCheckBox.getSelection());
            }
        });
    }

    private void createITDGroup(Composite _parent) {
        final PullOutRefactoring refactoring = this.getRefactoring();
        Group group = new Group(_parent, -1);
        group.setText("Intertype Declaration Options");
        group.setLayout((Layout)new GridLayout(2, true));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        final Button allowDropProtected = new Button((Composite)group, 32);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)allowDropProtected);
        allowDropProtected.setSelection(refactoring.isAllowDeleteProtected());
        allowDropProtected.setText("&Remove 'protected' keyword from ITDs ");
        allowDropProtected.setToolTipText("The AspectJ language does not allow the 'protected' keyword on ITDs.\nCheck this option to automatically remove it.");
        allowDropProtected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setAllowDeleteProtected(allowDropProtected.getSelection());
            }
        });
        final Button allowMakePublicCheckbox = new Button((Composite)group, 32);
        allowMakePublicCheckbox.setSelection(refactoring.isAllowMakePublic());
        allowMakePublicCheckbox.setText("&Make ITDs public as needed");
        allowMakePublicCheckbox.setToolTipText("If an ITD is private, it will be private to the aspect.\nPulled private members will no longer be accessible from the woven class.Check this option to allow the refactoring to fix broken references toITDs by making them public.");
        allowMakePublicCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setAllowMakePublic(allowMakePublicCheckbox.getSelection());
            }
        });
        final Button generateAbstractMethodStubs = new Button((Composite)group, 32);
        generateAbstractMethodStubs.setSelection(refactoring.isGenerateAbstractMethodStubs());
        generateAbstractMethodStubs.setText("&Generate stubs for abstract methods");
        generateAbstractMethodStubs.setToolTipText("Abstract ITDs are not supported by AspectJ.\nEnable this option to remove the abstract keyword and add stub method bodies for pulled out abstract methods.");
        generateAbstractMethodStubs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setGenerateAbstractMethodStubs(generateAbstractMethodStubs.getSelection());
            }
        });
    }

    private void createTargetAspectLine(Composite parent) {
        PullOutRefactoring refactoring = this.getRefactoring();
        parent = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)parent);
        GridLayout layout = new GridLayout(3, false);
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 0);
        label.setText("&Target Aspect");
        this.targetAspectInput = this.createAspectInput(parent);
        Button browseButton = new Button(parent, 8);
        browseButton.setText("&Browse...");
        this.targetAspectInput.setText(refactoring.getAspectName());
        this.targetAspectInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PullOutRefactoringInputPage.this.handleInputChanged();
            }
        });
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IType type = PullOutRefactoringInputPage.this.selectAspect();
                if (type == null) {
                    return;
                }
                PullOutRefactoringInputPage.this.targetAspectInput.setText(type.getFullyQualifiedName());
            }
        });
        try {
            AspectInputContentAssistProcessor processor = new AspectInputContentAssistProcessor(this.getRefactoring().getJavaProject());
            ControlContentAssistHelper.createTextContentAssistant((Text)this.targetAspectInput, (IContentAssistProcessor)processor);
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
    }

    void handleInputChanged() {
        RefactoringStatus status = new RefactoringStatus();
        PullOutRefactoring refactoring = this.getRefactoring();
        status.merge(refactoring.setAspect(this.targetAspectInput.getText()));
        this.setPageComplete(!status.hasError());
        int severity = status.getSeverity();
        String message = status.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }

    private TableLayoutComposite createTable(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        TableLayoutComposite layoutComposite = new TableLayoutComposite(parent, 4);
        layoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(20, this.convertWidthInCharsToPixels(20), true));
        layoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(20, this.convertWidthInCharsToPixels(20), true));
        layoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(40, this.convertWidthInCharsToPixels(40), true));
        TableViewer tv = new TableViewer((Composite)layoutComposite, 68354);
        tv.setContentProvider((IContentProvider)new FieldContentProvider());
        this.createColumns(tv);
        Table table = tv.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        tv.setInput((Object)this.getRefactoring());
        IMember[] fields = this.getRefactoring().getMembers();
        tv.refresh(true);
        gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(100);
        gridData.heightHint = SWTUtil.getTableHeightHint((Table)table, (int)Math.max(fields.length + 1, 2));
        layoutComposite.setLayoutData((Object)gridData);
        return layoutComposite;
    }

    private void createColumns(TableViewer tv) {
        this.packageColumn = new TableViewerColumn(tv, 16384);
        this.packageColumn.setLabelProvider((CellLabelProvider)new JavaCellLabelProvider(this.labelProvider){

            @Override
            public Object getColumnData(Object element) {
                if (element instanceof IMember) {
                    IMember method = (IMember)element;
                    return method.getDeclaringType().getPackageFragment();
                }
                return "???";
            }
        });
        TableColumn column = this.packageColumn.getColumn();
        column.setText("Package");
        this.typeColumn = new TableViewerColumn(tv, 16384);
        this.typeColumn.setLabelProvider((CellLabelProvider)new JavaCellLabelProvider(this.labelProvider){

            @Override
            public Object getColumnData(Object element) {
                if (element instanceof IMember) {
                    IMember method = (IMember)element;
                    return method.getDeclaringType();
                }
                return "???";
            }
        });
        column = this.typeColumn.getColumn();
        column.setText("Type");
        this.memberColumn = new TableViewerColumn(tv, 16384);
        this.memberColumn.setLabelProvider((CellLabelProvider)new JavaCellLabelProvider(this.labelProvider){

            @Override
            public Object getColumnData(Object elt) {
                return elt;
            }
        });
        column = this.memberColumn.getColumn();
        column.setText("Member Name");
    }

    IType selectAspect() {
        IJavaProject project = this.getRefactoring().getJavaProject();
        IJavaElement[] elements = new IJavaElement[]{project};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        try {
            SelectionStatusDialog dialog = (SelectionStatusDialog)JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)this.getContainer(), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"", (TypeSelectionExtension)new AspectSelectionFilter(project));
            dialog.setTitle("Choose target Aspect");
            dialog.setMessage("Choose the Aspect where to create the intertype declaration(s)");
            if (dialog.open() == 0) {
                return (IType)dialog.getFirstResult();
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        return null;
    }

    public PullOutRefactoring getRefactoring() {
        return (PullOutRefactoring)super.getRefactoring();
    }

    static {
        PullOutRefactoringInputPage.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PullOutRefactoringInputPage.java", PullOutRefactoringInputPage.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoringInputPage", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 205);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "createTargetAspectLine", "org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoringInputPage", "org.eclipse.swt.widgets.Composite", "parent", "", "void"), 168);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoringInputPage", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 351);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("0", "selectAspect", "org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoringInputPage", "", "", "", "org.eclipse.jdt.core.IType"), 333);
    }

    public class FieldContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof PullOutRefactoring) {
                PullOutRefactoring refactoring = (PullOutRefactoring)((Object)inputElement);
                return refactoring.getMembers();
            }
            return null;
        }
    }
}

