/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.ajde;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.ajde.core.IBuildMessageHandler;
import org.aspectj.ajde.core.IBuildProgressMonitor;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.eclipse.ajdt.internal.core.ajde.CoreBuildMessageHandler;
import org.eclipse.ajdt.internal.core.ajde.CoreBuildProgressMonitor;
import org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration;
import org.eclipse.ajdt.internal.core.ajde.ICompilerFactory;
import org.eclipse.core.resources.IProject;

public class CoreCompilerFactory
implements ICompilerFactory {
    private Map<IProject, AjCompiler> compilerMap = new HashMap<IProject, AjCompiler>();

    public AjCompiler getCompilerForProject(IProject project) {
        if (this.compilerMap.get(project) != null) {
            return this.compilerMap.get(project);
        }
        AjCompiler compiler = this.createCompiler(project);
        this.compilerMap.put(project, compiler);
        return compiler;
    }

    protected AjCompiler createCompiler(IProject project) {
        AjCompiler compiler = new AjCompiler(project.getName(), (ICompilerConfiguration)new CoreCompilerConfiguration(project), (IBuildProgressMonitor)new CoreBuildProgressMonitor(project), (IBuildMessageHandler)new CoreBuildMessageHandler());
        return compiler;
    }

    public void removeCompilerForProject(IProject project) {
        AjCompiler compiler = this.compilerMap.get(project);
        if (compiler != null) {
            compiler.clearLastState();
            this.compilerMap.remove(project);
        }
    }

    public boolean hasCompilerForProject(IProject project) {
        return this.compilerMap.get(project) != null;
    }
}

