/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import java.util.List;
import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTMatcher;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.AjASTMatcher;
import org.aspectj.org.eclipse.jdt.core.dom.AjASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.TypePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCategoryTypePattern
extends TypePattern {
    private int typeCategory;
    public static final int CLASS = 1;
    public static final int INTERFACE = 2;
    public static final int ASPECT = 3;
    public static final int INNER = 4;
    public static final int ANONYMOUS = 5;
    public static final int ENUM = 6;
    public static final int ANNOTATION = 7;

    TypeCategoryTypePattern(AST ast, int typeCategory) {
        super(ast, null);
        this.typeCategory = typeCategory;
    }

    public int getTypeCategory() {
        return this.typeCategory;
    }

    @Override
    List<?> internalStructuralPropertiesForType(int apiLevel) {
        return null;
    }

    @Override
    public String getTypePatternExpression() {
        String expression = super.getTypePatternExpression();
        if (expression == null) {
            switch (this.getTypeCategory()) {
                case 1: {
                    expression = "ClassType";
                    break;
                }
                case 4: {
                    expression = "InnerType";
                    break;
                }
                case 2: {
                    expression = "InterfaceType";
                    break;
                }
                case 7: {
                    expression = "AnnotationType";
                    break;
                }
                case 5: {
                    expression = "AnonymousType";
                    break;
                }
                case 3: {
                    expression = "AspectType";
                    break;
                }
                case 6: {
                    expression = "EnumType";
                }
            }
            expression = expression != null ? "is(" + expression + ")" : "";
            this.setTypePatternExpression(expression);
        }
        return expression;
    }

    @Override
    ASTNode clone0(AST target) {
        TypeCategoryTypePattern cloned = new TypeCategoryTypePattern(target, this.getTypeCategory());
        cloned.setSourceRange(this.getStartPosition(), this.getLength());
        return cloned;
    }

    @Override
    void accept0(ASTVisitor visitor) {
        if (visitor instanceof AjASTVisitor) {
            AjASTVisitor ajVisitor = (AjASTVisitor)visitor;
            ajVisitor.visit(this);
            ajVisitor.endVisit(this);
        }
    }

    @Override
    boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        if (matcher instanceof AjASTMatcher) {
            AjASTMatcher ajmatcher = (AjASTMatcher)matcher;
            return ajmatcher.match(this, other);
        }
        return false;
    }
}

