/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.contentassist;

import java.util.ArrayList;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.codeconversion.AspectsConvertingParser;
import org.eclipse.ajdt.core.codeconversion.ConversionOptions;
import org.eclipse.ajdt.core.codeconversion.ITDAwareLookupEnvironment;
import org.eclipse.ajdt.core.codeconversion.ITDAwareNameEnvironment;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.text.ITDCodeSelection;
import org.eclipse.ajdt.internal.core.contentassist.ProposalRequestorWrapper;
import org.eclipse.contribution.jdt.itdawareness.IJavaContentAssistProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class ContentAssistProvider
implements IJavaContentAssistProvider {
    public boolean doContentAssist(ICompilationUnit cu, ICompilationUnit unitToSkip, int position, CompletionRequestor requestor, WorkingCopyOwner owner, ITypeRoot typeRoot, Openable target, IProgressMonitor monitor) throws Exception {
        JavaProject project = (JavaProject)target.getJavaProject();
        if (!AspectJPlugin.isAJProject(project.getProject())) {
            return false;
        }
        if (target instanceof AJCompilationUnit) {
            return false;
        }
        if (!(target instanceof CompilationUnit)) {
            return false;
        }
        IBuffer buffer = target.getBuffer();
        if (buffer == null) {
            return false;
        }
        if (requestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        MockCompilationUnit mcu = new MockCompilationUnit((CompilationUnit)target);
        ProposalRequestorWrapper wrapped = new ProposalRequestorWrapper(requestor, (org.eclipse.jdt.core.ICompilationUnit)mcu, mcu.insertionTable);
        int transformedPos = mcu.translatePositionToFake(position);
        if (transformedPos < -1 || transformedPos > mcu.getContents().length) {
            throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(980));
        }
        ITDAwareNameEnvironment environment = new ITDAwareNameEnvironment(project, owner, monitor);
        environment.setUnitToSkip(unitToSkip);
        CompletionEngine engine = new CompletionEngine((SearchableEnvironment)environment, (CompletionRequestor)wrapped, project.getOptions(true), (IJavaProject)project, owner, monitor);
        engine.lookupEnvironment = new ITDAwareLookupEnvironment(engine.lookupEnvironment, (INameEnvironment)environment);
        engine.complete((ICompilationUnit)mcu, transformedPos, 0, typeRoot);
        return true;
    }

    public IJavaElement[] doCodeSelect(org.eclipse.jdt.core.ICompilationUnit unit, int offset, int length, IJavaElement[] prevResults) throws JavaModelException {
        String expandedRegion;
        AJLog.log("===Code Select.  Unit: " + unit.getElementName() + " [ " + offset + ", " + length + " ]");
        Region wordRegion = new Region(offset, length);
        ITDCodeSelection itdCodeSelection = new ITDCodeSelection(unit);
        IJavaElement[] maybeResult = itdCodeSelection.shortCutCodeSelection(wordRegion);
        if (maybeResult != null && maybeResult.length > 0) {
            return maybeResult;
        }
        if (prevResults != null && prevResults.length > 1) {
            return prevResults;
        }
        if (prevResults.length == 1 && prevResults[0] instanceof IType && ((expandedRegion = this.getExpandedRegion(offset, length, ((CompilationUnit)unit).getContents()).replace('$', '.')).equals(prevResults[0].getElementName()) || expandedRegion.equals(((IType)prevResults[0]).getFullyQualifiedName()))) {
            return prevResults;
        }
        IJavaElement[] newResults = itdCodeSelection.findJavaElement((IRegion)wordRegion);
        return newResults != null && newResults.length > 0 ? newResults : prevResults;
    }

    protected String getExpandedRegion(int offset, int length, char[] contents) {
        int start = offset;
        int end = offset + length;
        --start;
        while (start >= 0 && Character.isJavaIdentifierPart(contents[start])) {
            --start;
        }
        ++start;
        while (end < contents.length && Character.isJavaIdentifierPart(contents[end])) {
            ++end;
        }
        if (end < contents.length && (contents[end] == '(' || contents[end] == '<')) {
            ++end;
        }
        String candidate = String.valueOf(contents, start, end - start);
        String[] split = (candidate = candidate.trim()).split("\\.|\\s");
        if (split.length > 1) {
            candidate = split[split.length - 1];
        }
        return candidate;
    }

    private static class MockCompilationUnit
    extends CompilationUnit {
        char[] transformedContents;
        CompilationUnit orig;
        ArrayList insertionTable;

        public MockCompilationUnit(CompilationUnit orig) {
            super((PackageFragment)orig.getParent(), orig.getElementName(), orig.owner);
            this.orig = orig;
            this.transformedContents = this.initContents();
        }

        private char[] initContents() {
            AspectsConvertingParser parser = new AspectsConvertingParser(this.orig.getContents());
            parser.setUnit((org.eclipse.jdt.core.ICompilationUnit)this.orig);
            this.insertionTable = parser.convert(ConversionOptions.CODE_COMPLETION);
            return parser.content;
        }

        public char[] getContents() {
            return this.transformedContents;
        }

        int translatePositionToReal(int pos) {
            return AspectsConvertingParser.translatePositionToBeforeChanges(pos, this.insertionTable);
        }

        int translatePositionToFake(int pos) {
            return AspectsConvertingParser.translatePositionToAfterChanges(pos, this.insertionTable);
        }
    }
}

