/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.javaelements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AdviceElement;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.javaelements.PointcutElement;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class PointcutUtilities {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public static int findNextChar(String source, int offset, int limit, char c) {
        while (source.charAt(offset) != c) {
            if (++offset != limit && offset != source.length()) continue;
            return -1;
        }
        return offset;
    }

    public static String findIdentifier(String source, int offset) {
        int start = offset - 1;
        while (start > 0 && (Character.isJavaIdentifierStart(source.charAt(start)) || source.charAt(start) == '.')) {
            --start;
        }
        if (start == offset) {
            return "";
        }
        int end = offset;
        while (end < source.length() && (Character.isJavaIdentifierPart(source.charAt(end)) || source.charAt(end) == '.')) {
            ++end;
        }
        String s = source.substring(start + 1, end);
        return s;
    }

    public static Map findAllIdentifiers(String source) {
        int pos = PointcutUtilities.findNextChar(source, 0, source.length() - 1, ':');
        boolean lookingForStart = true;
        boolean done = false;
        int start = 0;
        HashMap<String, ArrayList<Integer>> idMap = new HashMap<String, ArrayList<Integer>>();
        int i = pos + 1;
        while (!done && i < source.length()) {
            char c = source.charAt(i);
            if (c == '{') {
                done = true;
            } else if (lookingForStart) {
                if (Character.isJavaIdentifierStart(c)) {
                    start = i;
                    lookingForStart = false;
                }
            } else if (!Character.isJavaIdentifierPart(c)) {
                String id = source.substring(start, i);
                if (!PointcutUtilities.isAjPointcutKeyword(id)) {
                    ArrayList<Integer> offsetList = (ArrayList<Integer>)idMap.get(id);
                    if (offsetList == null) {
                        offsetList = new ArrayList<Integer>();
                        idMap.put(id, offsetList);
                    }
                    offsetList.add(new Integer(i));
                }
                lookingForStart = true;
            }
            ++i;
        }
        return idMap;
    }

    public static String isInPointcutContext(AJCompilationUnit ajcu, int offset) {
        try {
            IJavaElement el = ajcu.getElementAt(offset);
            if (el instanceof AdviceElement || el instanceof PointcutElement) {
                ajcu.requestOriginalContentMode();
                String source = ajcu.getSource();
                ajcu.discardOriginalContentMode();
                ISourceRange range = ((ISourceReference)el).getSourceRange();
                int start = range.getOffset();
                int end = start + range.getLength();
                int colon = PointcutUtilities.findNextChar(source, start, end, ':');
                if (colon != -1 && offset > colon) {
                    int openBrace = PointcutUtilities.findNextChar(source, colon, end, '{');
                    int endZone = openBrace;
                    if (endZone == -1) {
                        int semiColon;
                        endZone = semiColon = PointcutUtilities.findNextChar(source, colon, end, ';');
                    }
                    if (endZone > 0 && offset < endZone) {
                        return source;
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        return null;
    }

    public static PointcutElement findPointcutInAspect(AspectElement aspect, String name) throws JavaModelException {
        PointcutElement[] pointcuts = aspect.getPointcuts();
        int i = 0;
        while (i < pointcuts.length) {
            if (name.equals(pointcuts[i].getElementName())) {
                return pointcuts[i];
            }
            ++i;
        }
        return null;
    }

    public static IJavaElement findPointcut(IJavaElement el, String name) throws JavaModelException {
        IJavaElement element = null;
        IJavaElement parent = el.getParent();
        if (parent instanceof AspectElement) {
            IType type;
            String[][] res;
            PointcutElement pc;
            int i;
            AspectElement aspect = (AspectElement)parent;
            if (name.indexOf(46) > 0) {
                IType type2;
                int ind = name.lastIndexOf(46);
                String typeName = name.substring(0, ind);
                String pcName = name.substring(ind + 1);
                String[][] res2 = aspect.resolveType(typeName);
                if (res2 != null && res2.length > 0 && (type2 = aspect.getJavaProject().findType(String.valueOf(res2[0][0]) + "." + res2[0][1])) != null) {
                    IMethod[] methods = type2.getMethods();
                    i = 0;
                    while (i < methods.length) {
                        if (pcName.equals(methods[i].getElementName()) && "Qpointcut;".equals(methods[i].getReturnType())) {
                            return methods[i];
                        }
                        ++i;
                    }
                }
            }
            if ((pc = PointcutUtilities.findPointcutInAspect(aspect, name)) != null) {
                return pc;
            }
            String superName = aspect.getSuperclassName();
            if (superName != null && superName.length() > 0) {
                List cus = AJCompilationUnitManager.INSTANCE.getCachedCUs(aspect.getJavaProject().getProject());
                for (AJCompilationUnit ajcu : cus) {
                    IType[] types = ajcu.getTypes();
                    i = 0;
                    while (i < types.length) {
                        if (types[i].getElementName().equals(superName) && types[i] instanceof AspectElement && (pc = PointcutUtilities.findPointcutInAspect((AspectElement)types[i], name)) != null) {
                            return pc;
                        }
                        ++i;
                    }
                }
            }
            if ((res = aspect.resolveType(name)) != null && res.length > 0 && (type = aspect.getJavaProject().findType(String.valueOf(res[0][0]) + "." + res[0][1])) != null) {
                return type;
            }
        }
        return element;
    }

    public static boolean isAjPointcutKeyword(String word) {
        int i = 0;
        while (i < AspectJPlugin.ajKeywords.length) {
            if (AspectJPlugin.ajKeywords[i].equals(word)) {
                return true;
            }
            ++i;
        }
        if ("this".equals(word)) {
            return true;
        }
        return "if".equals(word);
    }

    static {
        Factory factory = new Factory("PointcutUtilities.java", Class.forName("org.eclipse.ajdt.core.javaelements.PointcutUtilities"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.PointcutUtilities", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 154);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "isInPointcutContext", "org.eclipse.ajdt.core.javaelements.PointcutUtilities", "org.eclipse.ajdt.core.javaelements.AJCompilationUnit:int:", "ajcu:offset:", "", "java.lang.String"), 123);
    }
}

