/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.refactoring;

import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring;
import org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringDescriptor;
import org.eclipse.ajdt.internal.ui.resources.AJDTIcon;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PushInRefactoringInputPage
extends UserInputWizardPage {
    private Listener sortListener;
    TableViewerColumn iconColumn;
    TableViewerColumn aspectColumn;
    TableViewerColumn targetColumn;
    TableViewerColumn itdColumn;
    private PushInRefactoringDescriptor descriptor;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public PushInRefactoringInputPage(String name, PushInRefactoringDescriptor descriptor) {
        super(name);
        this.descriptor = descriptor;
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        Label label = new Label(result, 18436);
        label.setText("The following intertype declarations will be pushed into their target types:");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 5;
        label.setLayoutData((Object)gridData);
        this.createTable(result);
        label = new Label(result, 18436);
        label.setText("To change the set of intertype declarations to be pushed in, click cancel and reselect only the desired AspectJ elements.");
        label.setLayoutData((Object)gridData);
        this.handleInputChanged();
    }

    private PushInRefactoring getPushInRefactoring() {
        return (PushInRefactoring)this.getRefactoring();
    }

    private void handleInputChanged() {
        RefactoringStatus status = new RefactoringStatus();
        PushInRefactoring refactoring = this.getPushInRefactoring();
        try {
            status.merge(refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()));
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            CoreException e = coreException;
            status.merge(RefactoringStatus.createFatalErrorStatus((String)e.getMessage()));
        }
        this.setPageComplete(!status.hasError());
        int severity = status.getSeverity();
        String message = status.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }

    private void createTable(Composite parent) {
        TableLayoutComposite layoutComposite = new TableLayoutComposite(parent, 0);
        layoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(5, this.convertWidthInCharsToPixels(3), true));
        layoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(40, this.convertWidthInCharsToPixels(20), true));
        layoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(40, this.convertWidthInCharsToPixels(20), true));
        layoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(40, this.convertWidthInCharsToPixels(20), true));
        TableViewer tv = new TableViewer((Composite)layoutComposite, 68354);
        tv.setContentProvider((IContentProvider)new FieldContentProvider());
        this.createColumns(tv);
        Table table = tv.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        tv.setInput((Object)this.descriptor);
        IAspectJElement[] fields = this.descriptor.getITDs();
        tv.refresh(true);
        gridData = new GridData(1808);
        gridData.heightHint = SWTUtil.getTableHeightHint((Table)table, (int)Math.max(fields.length, 5));
        layoutComposite.setLayoutData((Object)gridData);
        this.sortListener = new SortListener(tv);
        this.iconColumn.getColumn().addListener(13, this.sortListener);
        this.aspectColumn.getColumn().addListener(13, this.sortListener);
        this.targetColumn.getColumn().addListener(13, this.sortListener);
        this.itdColumn.getColumn().addListener(13, this.sortListener);
    }

    private void createColumns(TableViewer tv) {
        this.iconColumn = new TableViewerColumn(tv, 16384);
        this.iconColumn.setLabelProvider(new CellLabelProvider(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

            public void update(ViewerCell cell) {
                Object elt = cell.getElement();
                if (elt instanceof IntertypeElement || elt instanceof DeclareElement) {
                    IAspectJElement ajElem = (IAspectJElement)elt;
                    try {
                        AJDTIcon icon = AspectJImages.instance().getStructureIcon(ajElem.getAJKind(), ajElem.getAJAccessibility());
                        cell.setImage(icon.getImageDescriptor().createImage());
                    }
                    catch (JavaModelException javaModelException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                }
            }

            static {
                Factory factory = new Factory("PushInRefactoringInputPage.java", Class.forName("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringInputPage$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringInputPage$1", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 259);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringInputPage$1", "org.eclipse.jface.viewers.ViewerCell:", "cell:", "", "void"), 250);
            }
        });
        this.aspectColumn = new TableViewerColumn(tv, 16384);
        this.aspectColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object elt = cell.getElement();
                if (elt instanceof IntertypeElement || elt instanceof DeclareElement) {
                    IAspectJElement itd = (IAspectJElement)elt;
                    cell.setText(itd.getParent().getElementName());
                }
            }
        });
        TableColumn column = this.aspectColumn.getColumn();
        column.setText("Declaring aspect");
        this.itdColumn = new TableViewerColumn(tv, 16384);
        this.itdColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object elt = cell.getElement();
                if (elt instanceof IntertypeElement) {
                    IAspectJElement itd = (IAspectJElement)elt;
                    cell.setText(itd.getElementName());
                } else if (elt instanceof DeclareElement) {
                    DeclareElement de = (DeclareElement)elt;
                    IProgramElement ipe = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)de).javaElementToProgramElement((IJavaElement)de);
                    String details = ipe.getDetails();
                    details = ipe.getDetails();
                    if (ipe.getKind().isDeclareAnnotation()) {
                        String annotationName = details;
                        String[] split = details.split(":");
                        if (split.length == 2) {
                            int secondPart = Math.max(split[1].lastIndexOf(46) + 1, 1);
                            split[1] = "@" + split[1].substring(secondPart).trim();
                            annotationName = split[1];
                        }
                        cell.setText(String.valueOf(de.getElementName()) + " " + annotationName);
                    } else {
                        List parents = ipe.getParentTypes();
                        StringBuffer sb = new StringBuffer();
                        Iterator parentIter = parents.iterator();
                        while (parentIter.hasNext()) {
                            String parent = (String)parentIter.next();
                            String[] splits = parent.split("\\.");
                            parent = splits[splits.length - 1];
                            sb.append(parent);
                            if (!parentIter.hasNext()) continue;
                            sb.append(", ");
                        }
                        cell.setText(sb.toString());
                    }
                }
            }
        });
        column = this.itdColumn.getColumn();
        column.setText("Intertype Name");
        this.targetColumn = new TableViewerColumn(tv, 16384);
        this.targetColumn.setLabelProvider(new CellLabelProvider(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

            public void update(ViewerCell cell) {
                Object elt = cell.getElement();
                if (elt instanceof IntertypeElement) {
                    IntertypeElement itd = (IntertypeElement)elt;
                    try {
                        cell.setText(new String(itd.getTargetType()));
                    }
                    catch (JavaModelException javaModelException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                } else if (elt instanceof DeclareElement) {
                    String targetName;
                    DeclareElement de = (DeclareElement)elt;
                    AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)de);
                    IProgramElement ipe = model.javaElementToProgramElement((IJavaElement)de);
                    if (ipe.getKind().isDeclareAnnotation()) {
                        String details;
                        targetName = details = ipe.getDetails();
                        String[] split = details.split(":");
                        if (split.length == 2) {
                            int firstPart = Math.max(split[0].lastIndexOf(46) + 1, 0);
                            split[0] = split[0].substring(firstPart).trim();
                            targetName = split[0];
                        }
                    } else {
                        List elts = model.getRelationshipsForElement((IJavaElement)de, AJRelationshipManager.DECLARED_ON);
                        StringBuffer sb = new StringBuffer();
                        Iterator eltIter = elts.iterator();
                        while (eltIter.hasNext()) {
                            IJavaElement target = (IJavaElement)eltIter.next();
                            sb.append(target.getElementName());
                            if (!eltIter.hasNext()) continue;
                            sb.append(", ");
                        }
                        targetName = sb.toString();
                    }
                    cell.setText(targetName);
                }
            }

            static {
                Factory factory = new Factory("PushInRefactoringInputPage.java", Class.forName("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringInputPage$4"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringInputPage$4", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 331);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringInputPage$4", "org.eclipse.jface.viewers.ViewerCell:", "cell:", "", "void"), 325);
            }
        });
        column = this.targetColumn.getColumn();
        column.setText("Target type");
    }

    public void dispose() {
        super.dispose();
        this.iconColumn.getColumn().removeListener(13, this.sortListener);
        this.aspectColumn.getColumn().removeListener(13, this.sortListener);
        this.targetColumn.getColumn().removeListener(13, this.sortListener);
        this.itdColumn.getColumn().removeListener(13, this.sortListener);
    }

    static {
        Factory factory = new Factory("PushInRefactoringInputPage.java", Class.forName("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringInputPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringInputPage", "org.eclipse.core.runtime.CoreException:", "e:"), 188);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "handleInputChanged", "org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringInputPage", "", "", "", "void"), 182);
    }

    public class FieldContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof PushInRefactoringDescriptor) {
                PushInRefactoringDescriptor descriptor = (PushInRefactoringDescriptor)((Object)inputElement);
                return descriptor.getITDs();
            }
            return null;
        }
    }

    class SortListener
    implements Listener {
        private final TableViewer tableViewer;
        private final Table table;

        public SortListener(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
            this.table = tableViewer.getTable();
        }

        public void handleEvent(Event e) {
            TableColumn sortColumn = this.table.getSortColumn();
            TableColumn currentColumn = (TableColumn)e.widget;
            int dir = this.table.getSortDirection();
            if (sortColumn == currentColumn) {
                dir = dir == 128 ? 1024 : 128;
            } else {
                this.table.setSortColumn(currentColumn);
                dir = 128;
            }
            String sortIdentifier = null;
            if (currentColumn == PushInRefactoringInputPage.this.iconColumn.getColumn()) {
                sortIdentifier = "icon.sort";
            }
            if (currentColumn == PushInRefactoringInputPage.this.aspectColumn.getColumn()) {
                sortIdentifier = "aspect.sort";
            }
            if (currentColumn == PushInRefactoringInputPage.this.targetColumn.getColumn()) {
                sortIdentifier = "itd.sort";
            }
            if (currentColumn == PushInRefactoringInputPage.this.itdColumn.getColumn()) {
                sortIdentifier = "target.sort";
            }
            this.tableViewer.setSorter((ViewerSorter)new Sorter(sortIdentifier, dir));
            this.table.setSortDirection(dir);
        }
    }

    class Sorter
    extends ViewerSorter {
        static final String ICON_SORT = "icon.sort";
        static final String ASPECT_SORT = "aspect.sort";
        static final String ITD_SORT = "itd.sort";
        static final String TARGET_SORT = "target.sort";
        private final int dir;
        private final String column;

        Sorter(String column, int dir) {
            this.column = column;
            this.dir = dir;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.column == ASPECT_SORT) {
                if (e1 instanceof IJavaElement) {
                    if (!(e1 instanceof IType)) {
                        e1 = ((IJavaElement)e1).getParent();
                    }
                    e1 = ((IJavaElement)e1).getElementName();
                }
                if (e2 instanceof IJavaElement) {
                    if (e2 instanceof IType) {
                        e2 = ((IJavaElement)e2).getParent();
                    }
                    e2 = ((IJavaElement)e2).getElementName();
                }
            } else if (this.column == ITD_SORT || this.column == TARGET_SORT) {
                if (e1 instanceof IJavaElement) {
                    e1 = ((IJavaElement)e1).getElementName();
                }
                if (e2 instanceof IJavaElement) {
                    e2 = ((IJavaElement)e2).getElementName();
                }
            }
            if (this.dir == 1024) {
                return e1.toString().compareTo(e2.toString());
            }
            return e2.toString().compareTo(e1.toString());
        }
    }
}

