/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar.raw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawGrammar;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawRepository;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawRule;
import org.eclipse.tm4e.core.internal.grammar.raw.RawRepository;
import org.eclipse.tm4e.core.internal.grammar.raw.RawRule;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;

public final class RawGrammar
extends HashMap<String, Object>
implements IRawGrammar,
PropertySettable<Object> {
    private static final String FILE_TYPES = "fileTypes";
    private static final String FIRST_LINE_MATCH = "firstLineMatch";
    private static final String INJECTIONS = "injections";
    private static final String INJECTION_SELECTOR = "injectionSelector";
    private static final String NAME = "name";
    private static final String PATTERNS = "patterns";
    private static final String SCOPE_NAME = "scopeName";
    private static final long serialVersionUID = 1L;
    private transient @Nullable List<String> fileTypes;

    @Override
    public Collection<String> getFileTypes() {
        List<String> result = this.fileTypes;
        if (result == null) {
            result = new ArrayList<String>();
            Collection unparsedFileTypes = (Collection)this.get(FILE_TYPES);
            if (unparsedFileTypes != null) {
                for (Object o : unparsedFileTypes) {
                    String str = Objects.toString(o);
                    if (str.startsWith(".")) {
                        str = str.substring(1);
                    }
                    result.add(str);
                }
            }
            this.fileTypes = result;
        }
        return result;
    }

    @Override
    public @Nullable String getFirstLineMatch() {
        return (String)this.get(FIRST_LINE_MATCH);
    }

    @Override
    public @Nullable Map<String, IRawRule> getInjections() {
        return (Map)this.get(INJECTIONS);
    }

    @Override
    public @Nullable String getInjectionSelector() {
        return (String)this.get(INJECTION_SELECTOR);
    }

    @Override
    public @Nullable String getName() {
        return (String)this.get(NAME);
    }

    @Override
    public @Nullable Collection<IRawRule> getPatterns() {
        return (Collection)this.get(PATTERNS);
    }

    @Override
    public IRawRepository getRepository() {
        IRawRepository repo = (IRawRepository)this.get("repository");
        if (repo == null) {
            repo = new RawRepository();
            this.setRepository(repo);
        }
        return repo;
    }

    private Object getSafe(@Nullable Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            throw new NoSuchElementException("Key '" + key + "' does not exit for grammar '" + this.getName() + '\"');
        }
        return obj;
    }

    @Override
    public String getScopeName() {
        return (String)this.getSafe(SCOPE_NAME);
    }

    @Override
    public @Nullable Object put(String key, @Nullable Object value) {
        if (FILE_TYPES.equals(key)) {
            this.fileTypes = null;
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(@Nullable Map<? extends String, ? extends @Nullable Object> m) {
        if (m != null && m.containsKey(FILE_TYPES)) {
            this.fileTypes = null;
        }
        super.putAll(m);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.put(name, value);
    }

    @Override
    public void setRepository(IRawRepository repository) {
        super.put("repository", repository);
    }

    @Override
    public IRawRule toRawRule() {
        return new RawRule(){
            private static final long serialVersionUID = 1L;

            @Override
            public @Nullable String getName() {
                return RawGrammar.this.getName();
            }

            @Override
            public @Nullable Collection<IRawRule> getPatterns() {
                return RawGrammar.this.getPatterns();
            }

            @Override
            public @Nullable IRawRepository getRepository() {
                return RawGrammar.this.getRepository();
            }
        };
    }
}

