/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.CopyThread;
import org.eclipse.rse.services.clientserver.ISystemOperationMonitor;
import org.eclipse.rse.services.clientserver.SystemOperationMonitor;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class CopyBatchThread
extends CopyThread {
    public CopyBatchThread(DataElement targetFolder, DataElement theElement, UniversalFileSystemMiner miner, boolean isWindows, DataElement status) {
        super(targetFolder, theElement, miner, isWindows, status);
    }

    public void run() {
        super.run();
        try {
            this.handleCopyBatch();
        }
        catch (SystemMessageException e) {
            this.status.setAttribute(4, "failed");
            this.miner.statusDone(this.status);
        }
        this._isDone = true;
    }

    private DataElement handleCopyBatch() throws SystemMessageException {
        String targetType = this.targetFolder.getType();
        File tgtFolder = this.getFileFor(this.targetFolder);
        int numOfSources = this.theElement.getNestedSize() - 2;
        this.systemOperationMonitor = new SystemOperationMonitor();
        if (targetType.equals("universal.ArchiveFileObject") || targetType.equals("universal.VirtualFolderObject")) {
            AbsoluteVirtualPath vpath = this.miner.getAbsoluteVirtualPath(this.targetFolder);
            ISystemArchiveHandler handler = this.miner.getArchiveHandlerFor(vpath.getContainingArchiveString());
            boolean result = true;
            ArrayList<File> nonDirectoryArrayList = new ArrayList<File>();
            ArrayList<String> nonDirectoryNamesArrayList = new ArrayList<String>();
            String virtualContainer = "";
            if (targetType.equals("universal.VirtualFolderObject")) {
                virtualContainer = vpath.getVirtualPart();
            }
            int i = 0;
            while (i < numOfSources) {
                File srcFile;
                if (this.isCancelled()) {
                    return this.miner.statusCancelled(this.status);
                }
                DataElement sourceFile = this.miner.getCommandArgument(this.theElement, i + 1);
                String srcType = sourceFile.getType();
                String srcName = sourceFile.getName();
                if (srcType.equals("universal.FileObject") || srcType.equals("universal.FolderObject") || srcType.equals("universal.ArchiveFileObject")) {
                    srcFile = this.getFileFor(sourceFile);
                } else if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
                    AbsoluteVirtualPath svpath = this.miner.getAbsoluteVirtualPath(sourceFile);
                    ISystemArchiveHandler shandler = this.miner.getArchiveHandlerFor(svpath.getContainingArchiveString());
                    if (shandler == null) {
                        this.status.setAttribute(4, "failed");
                        return this.miner.statusDone(this.status);
                    }
                    VirtualChild child = shandler.getVirtualFile(svpath.getVirtualPart(), (ISystemOperationMonitor)this.systemOperationMonitor);
                    srcFile = child.getExtractedFile();
                } else {
                    this.status.setAttribute(4, "failed");
                    return this.miner.statusDone(this.status);
                }
                if (srcFile.isDirectory()) {
                    try {
                        handler.add(srcFile, virtualContainer, srcName, (ISystemOperationMonitor)this.systemOperationMonitor);
                    }
                    catch (SystemMessageException e) {
                        this.status.setAttribute(4, "failed");
                        if (this.isCancelled()) {
                            return this.miner.statusCancelled(this.status);
                        }
                        return this.miner.statusDone(this.status);
                    }
                } else {
                    nonDirectoryArrayList.add(srcFile);
                    nonDirectoryNamesArrayList.add(srcName);
                }
                ++i;
            }
            if (nonDirectoryArrayList.size() > 0) {
                File[] resultFiles = nonDirectoryArrayList.toArray(new File[nonDirectoryArrayList.size()]);
                String[] resultNames = nonDirectoryNamesArrayList.toArray(new String[nonDirectoryNamesArrayList.size()]);
                try {
                    handler.add(resultFiles, virtualContainer, resultNames, (ISystemOperationMonitor)this.systemOperationMonitor);
                }
                catch (SystemMessageException e) {
                    result = false;
                }
            }
            if (result) {
                this.status.setAttribute(4, "success");
            } else {
                this.status.setAttribute(4, "failed");
            }
            if (this.isCancelled()) {
                return this.miner.statusCancelled(this.status);
            }
            return this.miner.statusDone(this.status);
        }
        boolean folderCopy = false;
        String source = "";
        String tgt = this.enQuote(tgtFolder.getAbsolutePath());
        int numOfNonVirtualSources = 0;
        int i = 0;
        while (i < numOfSources) {
            if (this.isCancelled()) {
                return this.miner.statusCancelled(this.status);
            }
            DataElement sourceFile = this.miner.getCommandArgument(this.theElement, i + 1);
            String srcType = sourceFile.getType();
            if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
                try {
                    AbsoluteVirtualPath svpath = this.miner.getAbsoluteVirtualPath(sourceFile);
                    ISystemArchiveHandler shandler = this.miner.getArchiveHandlerFor(svpath.getContainingArchiveString());
                    VirtualChild child = shandler.getVirtualFile(svpath.getVirtualPart(), (ISystemOperationMonitor)this.systemOperationMonitor);
                    File parentDir = this.getFileFor(this.targetFolder);
                    File destination = new File(parentDir, sourceFile.getName());
                    if (child.isDirectory) {
                        shandler.extractVirtualDirectory(svpath.getVirtualPart(), parentDir, destination, (ISystemOperationMonitor)this.systemOperationMonitor);
                    }
                    shandler.extractVirtualFile(svpath.getVirtualPart(), destination, (ISystemOperationMonitor)this.systemOperationMonitor);
                }
                catch (SystemMessageException e) {
                    this.status.setAttribute(4, "failed");
                    return this.miner.statusDone(this.status);
                }
            } else {
                File srcFile = this.getFileFor(sourceFile);
                folderCopy = folderCopy || srcFile.isDirectory();
                String src = srcFile.getAbsolutePath();
                src = this.enQuote(src);
                if (this.isWindows) {
                    tgt = String.valueOf(tgtFolder.getAbsolutePath()) + File.separatorChar + srcFile.getName();
                    this.doCopyCommand(src, this.enQuote(tgt), folderCopy, this.status);
                    if (this.status.getAttribute(4) == "failed") {
                        break;
                    }
                } else {
                    source = numOfNonVirtualSources == 0 ? String.valueOf(source) + src : String.valueOf(source) + " " + src;
                    ++numOfNonVirtualSources;
                }
            }
            ++i;
        }
        if (numOfNonVirtualSources > 0) {
            this.doCopyCommand(source, tgt, folderCopy, this.status);
        }
        if (this.isCancelled()) {
            return this.miner.statusCancelled(this.status);
        }
        return this.miner.statusDone(this.status);
    }
}

