/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileProfile;

public class SystemCompileType
implements IAdaptable {
    private SystemCompileProfile profile;
    private String type;
    private SystemCompileCommand lastUsedCompileCommand;
    private Vector commands = new Vector();

    public SystemCompileType(SystemCompileProfile profile) {
        this.setParentProfile(profile);
    }

    public SystemCompileType(SystemCompileProfile profile, String type) {
        this.setParentProfile(profile);
        this.setType(type);
    }

    public SystemCompileType(SystemCompileProfile profile, String type, SystemCompileCommand lastUsedCompileCmd) {
        this.setParentProfile(profile);
        this.setType(type);
        this.setLastUsedCompileCommand(lastUsedCompileCmd);
    }

    public void setParentProfile(SystemCompileProfile profile) {
        this.profile = profile;
    }

    public SystemCompileProfile getParentProfile() {
        return this.profile;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setLastUsedCompileCommand(SystemCompileCommand lastUsedCompileCommand) {
        this.lastUsedCompileCommand = lastUsedCompileCommand;
    }

    public SystemCompileCommand getLastUsedCompileCommand() {
        return this.lastUsedCompileCommand;
    }

    public void addCompileCommand(SystemCompileCommand command) {
        this.flushCache();
        this.commands.add(command);
    }

    public void addCompileCommandInOrder(SystemCompileCommand compileCommand) {
        this.flushCache();
        if (this.commands.size() == 0) {
            this.commands.add(compileCommand);
            return;
        }
        int order = compileCommand.getOrder();
        SystemCompileCommand cmd = null;
        int i = 0;
        while (i < this.commands.size()) {
            cmd = (SystemCompileCommand)this.commands.get(i);
            if (order < cmd.getOrder()) {
                this.commands.insertElementAt(compileCommand, i);
                return;
            }
            ++i;
        }
        this.commands.add(compileCommand);
    }

    public void removeCompileCommand(SystemCompileCommand cmd) {
        this.flushCache();
        int i = 0;
        while (i < this.commands.size()) {
            SystemCompileCommand compileCmd = (SystemCompileCommand)this.commands.get(i);
            if (compileCmd == cmd) {
                this.commands.remove(i);
                return;
            }
            ++i;
        }
    }

    public SystemCompileCommand removeCompileCommand(int index) {
        this.flushCache();
        return (SystemCompileCommand)this.commands.remove(index);
    }

    public void insertCompileCommand(SystemCompileCommand compileName, int index) {
        this.commands.insertElementAt(compileName, index);
        this.flushCache();
    }

    public Vector getCompileCommands() {
        return this.commands;
    }

    public SystemCompileCommand[] getCompileCommandsArray() {
        SystemCompileCommand[] cmds = new SystemCompileCommand[this.commands.size()];
        int idx = 0;
        while (idx < cmds.length) {
            cmds[idx] = (SystemCompileCommand)this.commands.elementAt(idx);
            ++idx;
        }
        return cmds;
    }

    public int getNumOfCommands() {
        return this.commands.size();
    }

    public Vector getPromptableCompileCommands() {
        Vector<SystemCompileCommand> promptableCmds = new Vector<SystemCompileCommand>();
        SystemCompileCommand compileCmd = null;
        int i = 0;
        while (i < this.commands.size()) {
            compileCmd = (SystemCompileCommand)this.commands.get(i);
            if (compileCmd.isPromptable()) {
                promptableCmds.add(compileCmd);
            }
            ++i;
        }
        return promptableCmds;
    }

    public Vector getNonPromptableCompileCommands() {
        Vector<SystemCompileCommand> nonPromptableCmds = new Vector<SystemCompileCommand>();
        SystemCompileCommand compileCmd = null;
        int i = 0;
        while (i < this.commands.size()) {
            compileCmd = (SystemCompileCommand)this.commands.get(i);
            if (compileCmd.isNonPromptable()) {
                nonPromptableCmds.add(compileCmd);
            }
            ++i;
        }
        return nonPromptableCmds;
    }

    public SystemCompileCommand getCompileLabel(String label) {
        SystemCompileCommand compileCmd = null;
        int i = 0;
        while (i < this.commands.size()) {
            compileCmd = (SystemCompileCommand)this.commands.get(i);
            if (compileCmd.getLabel().equalsIgnoreCase(label)) {
                return compileCmd;
            }
            ++i;
        }
        return null;
    }

    public Vector getCompileId(String id) {
        Vector<SystemCompileCommand> list = new Vector<SystemCompileCommand>();
        SystemCompileCommand compileCmd = null;
        int i = 0;
        while (i < this.commands.size()) {
            compileCmd = (SystemCompileCommand)this.commands.get(i);
            if (compileCmd.getId().equalsIgnoreCase(id)) {
                list.add(compileCmd);
            }
            ++i;
        }
        return list;
    }

    public boolean isIdExists(String id) {
        SystemCompileCommand compileCmd = null;
        int idx = 0;
        while (idx < this.commands.size()) {
            compileCmd = (SystemCompileCommand)this.commands.get(idx);
            if (compileCmd.getId().equalsIgnoreCase(id)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public SystemCompileCommand getCompileCommand(int index) {
        return (SystemCompileCommand)this.commands.get(index);
    }

    public boolean isLabelExists(String nameString) {
        SystemCompileCommand compileCmd = null;
        int idx = 0;
        while (idx < this.commands.size()) {
            compileCmd = (SystemCompileCommand)this.commands.get(idx);
            if (compileCmd.getLabel().equalsIgnoreCase(nameString)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public boolean isDuplicateLabelExists(String nameString) {
        SystemCompileCommand compileCmd = null;
        boolean once = false;
        int idx = 0;
        while (idx < this.commands.size()) {
            compileCmd = (SystemCompileCommand)this.commands.get(idx);
            if (compileCmd.getLabel().equalsIgnoreCase(nameString)) {
                if (!once) {
                    once = true;
                } else {
                    return true;
                }
            }
            ++idx;
        }
        return false;
    }

    public Vector getExistingLabels() {
        Vector<String> labels = new Vector<String>();
        int idx = 0;
        while (idx < this.commands.size()) {
            labels.add(((SystemCompileCommand)this.commands.get(idx)).getLabel());
            ++idx;
        }
        return labels;
    }

    public String toString() {
        return this.getType();
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    private void flushCache() {
    }
}

