/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.util.StringTokenizer;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.useractions.UserActionsIcon;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemXMLElementWrapper;
import org.eclipse.swt.graphics.Image;

public class SystemUDActionElement
extends SystemXMLElementWrapper {
    private static final String ACTION_TAG = "Action";
    private static final String COMMENT_TAG = "Comment";
    private static final String COMMAND_TAG = "Command";
    private static final String FILETYPES_TAG = "FileTypes";
    private static final String PROMPT_ATTR = "Prompt";
    private static final String REFRESH_ATTR = "Refresh";
    private static final String COLLECT_ATTR = "Collect";
    private static final String SINGLESEL_ATTR = "SingleSelection";
    private static final String SHOW_ATTR = "Enable";
    private String initCommand;
    private Object data;

    public SystemUDActionElement(IPropertySet e, SystemUDActionManager am, ISystemProfile profile, int domainType) {
        super(e, am, profile, domainType);
    }

    public String getLabel() {
        String name = this.getName();
        if (this.getPrompt()) {
            name = String.valueOf(name) + "...";
        }
        return name;
    }

    public Image getImage() {
        if (this.isIBM()) {
            if (this.isUserChanged()) {
                return UserActionsIcon.USERACTION_IBMUSR.getImage();
            }
            return UserActionsIcon.USERACTION_IBM.getImage();
        }
        return UserActionsIcon.USERACTION_USR.getImage();
    }

    public String getTagName() {
        return ACTION_TAG;
    }

    public String getComment() {
        IProperty commentProperty = this.elm.getProperty(COMMENT_TAG);
        if (commentProperty != null) {
            return commentProperty.getValue();
        }
        return "";
    }

    public String getCommand() {
        IProperty commentProperty = this.elm.getProperty(COMMAND_TAG);
        if (commentProperty != null) {
            return commentProperty.getValue();
        }
        return "";
    }

    public boolean getPrompt() {
        return this.getBooleanAttribute(PROMPT_ATTR, false);
    }

    public boolean getRefresh() {
        return this.getBooleanAttribute(REFRESH_ATTR, false);
    }

    public boolean getShow() {
        return this.getBooleanAttribute(SHOW_ATTR, true);
    }

    public boolean getCollect() {
        return this.getBooleanAttribute(COLLECT_ATTR, false);
    }

    public boolean getSingleSelection() {
        return this.getBooleanAttribute(SINGLESEL_ATTR, false);
    }

    public String[] getFileTypes() {
        IProperty fileTypeProperty = this.elm.getProperty(FILETYPES_TAG);
        if (fileTypeProperty != null) {
            String fts = fileTypeProperty.getValue();
            StringTokenizer st = new StringTokenizer(fts);
            int n = st.countTokens();
            String[] sa = new String[n];
            int i = 0;
            while (i < n) {
                sa[i] = st.nextToken();
                ++i;
            }
            return sa;
        }
        return new String[0];
    }

    public void setComment(String s) {
        IProperty commentProperty = this.elm.getProperty(COMMENT_TAG);
        if (commentProperty != null) {
            commentProperty.setValue(s);
        } else {
            this.elm.addProperty(COMMENT_TAG, s);
        }
        this.setUserChanged(true);
    }

    public void setCommand(String s) {
        IProperty commandProperty = this.elm.getProperty(COMMAND_TAG);
        if (commandProperty != null) {
            commandProperty.setValue(s);
        } else {
            this.elm.addProperty(COMMAND_TAG, s);
        }
        this.setUserChanged(true);
    }

    public void setPrompt(boolean b) {
        this.setBooleanAttribute(PROMPT_ATTR, b);
        this.setUserChanged(true);
    }

    public void setRefresh(boolean b) {
        this.setBooleanAttribute(REFRESH_ATTR, b);
        this.setUserChanged(true);
    }

    public void setShow(boolean b) {
        this.setBooleanAttribute(SHOW_ATTR, b);
        this.setUserChanged(true);
    }

    public void setCollect(boolean b) {
        this.setBooleanAttribute(COLLECT_ATTR, b);
        this.setUserChanged(true);
    }

    public void setSingleSelection(boolean b) {
        this.setBooleanAttribute(SINGLESEL_ATTR, b);
        this.setUserChanged(true);
    }

    public void setFileTypes(String[] sa) {
        String s = "";
        int i = 0;
        while (i < sa.length) {
            s = String.valueOf(s) + " " + sa[i];
            ++i;
        }
        IProperty fileTypeProperty = this.elm.getProperty(FILETYPES_TAG);
        if (fileTypeProperty != null) {
            fileTypeProperty.setValue(s);
        } else {
            this.elm.addProperty(FILETYPES_TAG, s);
        }
        this.setUserChanged(true);
    }

    public boolean isGeneric() {
        String[] fts = this.getFileTypes();
        if (fts.length == 0) {
            return true;
        }
        int i = 0;
        while (i < fts.length) {
            if ("*".equals(fts[i])) {
                return true;
            }
            ++i;
        }
        return true;
    }

    public void setInitCommand(String s) {
        this.initCommand = s;
    }

    public String getInitCommand() {
        return this.initCommand;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }
}

