/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.internal.ui.view.SystemViewMenuListener;
import org.eclipse.rse.internal.useractions.ui.compile.ISystemCompileCommandEditPaneHoster;
import org.eclipse.rse.internal.useractions.ui.compile.ISystemCompileCommandEditPaneListener;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommandActionCopy;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommandActionDelete;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommandActionMoveDown;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommandActionMoveUp;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommandActionPaste;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommandActionRestoreDefaults;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommandEditPane;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileProfile;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileType;
import org.eclipse.rse.internal.useractions.ui.compile.SystemNewCompileSrcTypeDialog;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.rse.ui.widgets.SystemEditPaneStateMachine;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SystemWorkWithCompileCommandsDialog
extends SystemPromptDialog
implements SelectionListener,
ISystemCompileCommandEditPaneListener,
IMenuListener,
Runnable,
ISystemCompileCommandEditPaneHoster {
    protected Button applyButton;
    protected Button revertButton;
    protected Button newSrcTypeButton;
    protected Button rmvSrcTypeButton;
    protected Combo profileCombo;
    protected Combo srcTypeCombo;
    protected List listView;
    protected Label ccLabel;
    protected SystemEditPaneStateMachine sm;
    private SystemCompileCommandActionCopy copyAction;
    private SystemCompileCommandActionPaste pasteAction;
    private SystemCompileCommandActionDelete deleteAction;
    private SystemCompileCommandActionMoveUp moveUpAction;
    private SystemCompileCommandActionMoveDown moveDownAction;
    private SystemCompileCommandActionRestoreDefaults restoreAction;
    private MenuManager menuMgr;
    private Clipboard clipboard;
    private boolean menuListenerAdded;
    protected SystemCompileManager compileManager;
    protected SystemCompileCommandEditPane editpane;
    protected SystemCompileProfile[] compProfiles;
    protected SystemCompileProfile currentCompProfile;
    protected SystemCompileType currentCompType;
    protected boolean caseSensitive;
    protected boolean supportsAddSrcTypeButton;
    private String srcTypeLabel;
    private String srcTypeTooltip;
    protected boolean ignoreEvents = false;
    protected boolean restoreProfileComboSelection = true;
    protected boolean showProfileCombo;
    protected boolean resetting = false;
    protected boolean giveEditorFocus = true;
    protected int prevProfileComboSelection = 0;
    protected int prevSrcTypeComboSelection = 0;
    protected int prevListSelection = 0;
    protected String[] compileTypeNames;
    private boolean traceTest;

    public SystemWorkWithCompileCommandsDialog(Shell shell, SystemCompileManager compileManager, SystemCompileProfile currentCompProfile) {
        this(shell, compileManager, currentCompProfile, SystemUDAResources.RESID_WWCOMPCMDS_TITLE);
    }

    public SystemWorkWithCompileCommandsDialog(Shell shell, SystemCompileManager compileManager, SystemCompileProfile currentCompProfile, String title) {
        super(shell, title);
        this.compileManager = compileManager;
        this.currentCompProfile = currentCompProfile;
        this.compProfiles = new SystemCompileProfile[]{currentCompProfile};
        this.supportsAddSrcTypeButton = true;
        this.setCancelButtonLabel(SystemUDAResources.BUTTON_CLOSE);
        this.setShowOkButton(false);
        this.setOutputObject(null);
        this.setHelp();
        this.setSourceTypePromptMRI(compileManager.getSourceTypePromptMRILabel(), compileManager.getSourceTypePromptMRITooltip());
    }

    protected void setHelp() {
        this.setHelp("org.eclipse.rse.ui.wwcc0000");
    }

    public void setCompileCommandEditPane(SystemCompileCommandEditPane editPane) {
        this.editpane = editPane;
    }

    public void setProfiles(SystemCompileProfile[] profiles) {
        if (profiles == null) {
            this.compProfiles = new SystemCompileProfile[0];
        } else {
            this.compProfiles = profiles;
            this.showProfileCombo = true;
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setSupportsAddSrcTypeButton(boolean supports) {
        this.supportsAddSrcTypeButton = supports;
    }

    public void setSourceTypePromptMRI(String srcTypeMRILabel, String srcTypeMRITooltip) {
        this.srcTypeLabel = srcTypeMRILabel;
        this.srcTypeTooltip = srcTypeMRITooltip;
    }

    public void setCompileType(SystemCompileType type) {
        this.currentCompType = type;
    }

    protected Control getInitialFocusControl() {
        return this.editpane.getInitialFocusControl();
    }

    protected Control createInner(Composite parent) {
        this.editpane = this.getCompileCommandEditPane(this.getShell());
        int nbrColumns = 4;
        Composite composite = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        this.profileCombo = SystemWidgetHelpers.createLabeledReadonlyCombo((Composite)composite, null, (String)SystemUDAResources.RESID_WWCOMPCMDS_PROFILE_LABEL, (String)SystemUDAResources.RESID_WWCOMPCMDS_PROFILE_TOOLTIP);
        ((GridData)this.profileCombo.getLayoutData()).horizontalSpan = nbrColumns - 1;
        this.srcTypeCombo = SystemWidgetHelpers.createLabeledReadonlyCombo((Composite)composite, null, (String)this.srcTypeLabel, (String)this.srcTypeTooltip);
        if (this.supportsAddSrcTypeButton) {
            this.newSrcTypeButton = SystemWidgetHelpers.createPushButton((Composite)composite, null, (String)SystemUDAResources.RESID_WWCOMPCMDS_TYPES_BUTTON_ADD_LABEL, (String)SystemUDAResources.RESID_WWCOMPCMDS_TYPES_BUTTON_ADD_TOOLTIP);
            this.rmvSrcTypeButton = SystemWidgetHelpers.createPushButton((Composite)composite, null, (String)SystemUDAResources.RESID_WWCOMPCMDS_TYPES_BUTTON_RMV_LABEL, (String)SystemUDAResources.RESID_WWCOMPCMDS_TYPES_BUTTON_RMV_TOOLTIP);
            this.rmvSrcTypeButton.setEnabled(false);
        } else {
            ((GridData)this.srcTypeCombo.getLayoutData()).horizontalSpan = nbrColumns - 1;
        }
        this.addFillerLine(composite, nbrColumns);
        this.listView = SystemWidgetHelpers.createListBox((Composite)composite, (String)SystemUDAResources.RESID_WWCOMPCMDS_LIST_LABEL, null, (boolean)false, (int)1);
        GridData data = (GridData)this.listView.getLayoutData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.widthHint = 110;
        Composite rightSideComposite = SystemWidgetHelpers.createFlushComposite((Composite)composite, (int)1);
        ((GridData)rightSideComposite.getLayoutData()).horizontalSpan = nbrColumns - 1;
        this.addFillerLine(rightSideComposite, 1);
        this.ccLabel = SystemWidgetHelpers.createLabel((Composite)rightSideComposite, (String)"");
        this.addSeparatorLine(rightSideComposite, 1);
        this.editpane.createContents(rightSideComposite);
        this.addSeparatorLine(rightSideComposite, 1);
        int nbrColumns_buttonComposite = 3;
        Composite applyResetButtonComposite = SystemWidgetHelpers.createFlushComposite((Composite)rightSideComposite, (int)nbrColumns_buttonComposite);
        Label filler = SystemWidgetHelpers.createLabel((Composite)applyResetButtonComposite, (String)"");
        ((GridData)filler.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)filler.getLayoutData()).horizontalAlignment = 4;
        this.applyButton = SystemWidgetHelpers.createPushButton((Composite)applyResetButtonComposite, (Listener)this, (String)SystemUDAResources.RESID_WWCOMPCMDS_BUTTON_APPLY_LABEL, (String)SystemUDAResources.RESID_WWCOMPCMDS_BUTTON_APPLY_TOOLTIP);
        ((GridData)this.applyButton.getLayoutData()).grabExcessHorizontalSpace = false;
        this.revertButton = SystemWidgetHelpers.createPushButton((Composite)applyResetButtonComposite, (Listener)this, (String)SystemUDAResources.RESID_WWCOMPCMDS_BUTTON_REVERT_LABEL, (String)SystemUDAResources.RESID_WWCOMPCMDS_BUTTON_REVERT_TOOLTIP);
        ((GridData)this.revertButton.getLayoutData()).grabExcessHorizontalSpace = false;
        this.addGrowableFillerLine(rightSideComposite, 1);
        this.sm = new SystemEditPaneStateMachine(rightSideComposite, this.applyButton, this.revertButton);
        this.sm.setApplyLabelForNewMode(SystemUDAResources.RESID_WWCOMPCMDS_BUTTON_CREATE_LABEL, SystemUDAResources.RESID_WWCOMPCMDS_BUTTON_CREATE_TOOLTIP);
        this.sm.setUnsetMode();
        this.initProfileCombo();
        composite.layout(true);
        this.profileCombo.addSelectionListener((SelectionListener)this);
        this.srcTypeCombo.addSelectionListener((SelectionListener)this);
        if (this.supportsAddSrcTypeButton) {
            this.newSrcTypeButton.addSelectionListener((SelectionListener)this);
            this.rmvSrcTypeButton.addSelectionListener((SelectionListener)this);
        }
        this.listView.addSelectionListener((SelectionListener)this);
        this.applyButton.addSelectionListener((SelectionListener)this);
        this.revertButton.addSelectionListener((SelectionListener)this);
        this.editpane.addChangeListener(this);
        this.listView.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                SystemWorkWithCompileCommandsDialog.this.giveEditorFocus = true;
            }

            public void mouseDown(MouseEvent e) {
                SystemWorkWithCompileCommandsDialog.this.giveEditorFocus = true;
            }

            public void mouseUp(MouseEvent e) {
                SystemWorkWithCompileCommandsDialog.this.giveEditorFocus = true;
            }
        });
        this.listView.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                SystemWorkWithCompileCommandsDialog.this.giveEditorFocus = false;
            }

            public void keyReleased(KeyEvent e) {
                SystemWorkWithCompileCommandsDialog.this.giveEditorFocus = false;
            }
        });
        this.menuMgr = new MenuManager("#WWCompCmdsPopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = this.menuMgr.createContextMenu((Control)this.listView);
        this.listView.setMenu(menu);
        this.editpane.configureHeadingLabel(this.ccLabel);
        this.editpane.isComplete();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getShell().setDefaultButton(this.applyButton);
    }

    protected SystemCompileCommandEditPane getCompileCommandEditPane(Shell shell) {
        if (this.editpane == null) {
            this.editpane = this.compileManager.getCompileCommandEditPane(shell, this, this.caseSensitive);
        }
        return this.editpane;
    }

    private void initProfileCombo() {
        if (this.profileCombo != null && this.compProfiles != null && this.compProfiles.length > 0) {
            String[] names = new String[this.compProfiles.length];
            int selIdx = -1;
            int idx = 0;
            while (idx < names.length) {
                names[idx] = this.compProfiles[idx].getProfileName();
                if (this.currentCompProfile != null && this.currentCompProfile == this.compProfiles[idx]) {
                    selIdx = idx;
                }
                ++idx;
            }
            if (selIdx == -1) {
                selIdx = 0;
                this.currentCompProfile = this.compProfiles[0];
            }
            this.profileCombo.setItems(names);
            this.profileCombo.setText(names[selIdx]);
            this.prevProfileComboSelection = selIdx;
            if (this.currentCompProfile != null) {
                if (this.currentCompType != null) {
                    this.processProfileSelected(this.currentCompType.getType());
                } else {
                    this.processProfileSelected(null);
                }
            }
        }
    }

    private void processProfileSelected(String srcType) {
        ISystemRemoteElementAdapter rmtAdapter;
        if (srcType == null && (rmtAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)this.getInputObject())) != null) {
            srcType = rmtAdapter.getRemoteSourceType(this.getInputObject());
        }
        Vector types = this.currentCompProfile.getCompileTypes();
        if (srcType == null) {
            srcType = types.size() > 0 ? ((SystemCompileType)types.elementAt(0)).getType() : "";
        }
        this.compileTypeNames = new String[types.size()];
        int index = 0;
        int i = 0;
        while (i < this.compileTypeNames.length) {
            this.compileTypeNames[i] = ((SystemCompileType)types.get(i)).getType();
            if (!this.caseSensitive) {
                if (srcType.equalsIgnoreCase(this.compileTypeNames[i])) {
                    index = i;
                }
            } else if (srcType.equals(this.compileTypeNames[i])) {
                index = i;
            }
            ++i;
        }
        this.srcTypeCombo.setItems(this.compileTypeNames);
        if (this.srcTypeCombo.getItemCount() > 0) {
            this.srcTypeCombo.setText(this.srcTypeCombo.getItem(index));
            this.prevSrcTypeComboSelection = index;
            this.currentCompType = this.currentCompProfile.getCompileType(this.srcTypeCombo.getText());
            this.processSrcTypeSelected(0);
        } else {
            this.prevSrcTypeComboSelection = -1;
            this.currentCompType = null;
            this.processSrcTypeSelected(-1);
        }
    }

    private void processSrcTypeSelected(int selection) {
        Vector cmds = new Vector();
        if (this.currentCompType != null) {
            cmds = this.currentCompType.getCompileCommands();
        }
        if (this.rmvSrcTypeButton != null) {
            this.rmvSrcTypeButton.setEnabled(this.currentCompType != null && cmds.size() == 0);
        }
        if (this.currentCompType != null) {
            String[] listItems = new String[1 + cmds.size()];
            listItems[0] = SystemUDAResources.RESID_WWCOMPCMDS_LIST_NEWITEM;
            int idx = 0;
            while (idx < cmds.size()) {
                listItems[idx + 1] = ((SystemCompileCommand)cmds.get(idx)).getLabel();
                ++idx;
            }
            this.listView.setItems(listItems);
            this.listView.setSelection(selection);
        } else {
            this.listView.removeAll();
        }
        this.processCommandsListSelected();
    }

    private void processCommandsListSelected() {
        int index = this.listView.getSelectionIndex();
        if (index == 0) {
            this.sm.setNewMode();
            this.editpane.setCompileCommand(this.currentCompType, null);
            this.editpane.configureHeadingLabel(this.ccLabel);
        } else if (index > -1) {
            SystemCompileCommand currCmd = this.getCurrentlySelectedCompileCommand();
            this.sm.setEditMode();
            this.editpane.setCompileCommand(this.currentCompType, currCmd);
            this.editpane.configureHeadingLabel(this.ccLabel);
        } else {
            this.sm.setUnsetMode();
            this.editpane.setCompileCommand(null, null);
        }
        this.prevListSelection = index;
    }

    private SystemCompileProfile getCompileProfile(int currSelIdx) {
        return this.compProfiles[currSelIdx];
    }

    protected boolean processCancel() {
        if (this.sm.isSaveRequired()) {
            this.ignoreEvents = true;
            if (this.editpane.verify() != null) {
                this.ignoreEvents = false;
                this.sm.setChangesMade();
                return false;
            }
            this.ignoreEvents = false;
            this.applyPressed(false);
        }
        return super.processCancel();
    }

    private void saveData() {
        if (this.currentCompProfile != null) {
            this.currentCompProfile.writeToDisk();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.clearMessage();
        Widget source = e.widget;
        if (this.resetting) {
            return;
        }
        if (source == this.applyButton) {
            this.applyPressed(true);
        } else if (source == this.revertButton) {
            this.revertPressed();
        } else if (source == this.newSrcTypeButton) {
            this.newSrcTypePressed();
        } else if (source == this.rmvSrcTypeButton) {
            this.rmvSrcTypePressed();
        } else if (source == this.listView) {
            Control c;
            if (this.traceTest) {
                System.out.println("Inside widgetSelected for listView: " + this.listView.getSelectionIndex());
            }
            if (this.editpane.areErrorsPending()) {
                e.doit = false;
                this.resetting = true;
                this.listView.select(this.prevListSelection);
                this.resetting = false;
                return;
            }
            if (this.sm.isSaveRequired()) {
                boolean newMode;
                boolean bl = newMode = this.sm.getMode() == 4;
                if (this.editpane.verify() != null) {
                    e.doit = false;
                    this.resetting = true;
                    this.listView.select(this.prevListSelection);
                    this.resetting = false;
                    this.sm.setChangesMade();
                    return;
                }
                int newSelection = this.listView.getSelectionIndex();
                this.saveCompileCommand(this.editpane.saveChanges(), newMode, this.prevListSelection);
                this.listView.select(newSelection);
            }
            this.processCommandsListSelected();
            if (this.giveEditorFocus && (c = this.editpane.getInitialFocusControl()) != null && !c.isDisposed() && c.isVisible()) {
                c.setFocus();
            }
        } else if (source == this.profileCombo) {
            if (this.editpane.areErrorsPending()) {
                this.restoreProfileComboSelection = true;
                this.profileCombo.getDisplay().asyncExec((Runnable)this);
                return;
            }
            if (this.sm.isSaveRequired()) {
                boolean newMode;
                boolean bl = newMode = this.sm.getMode() == 4;
                if (this.editpane.verify() != null) {
                    this.restoreProfileComboSelection = true;
                    this.sm.setChangesMade();
                    this.profileCombo.getDisplay().asyncExec((Runnable)this);
                    return;
                }
                this.saveCompileCommand(this.editpane.saveChanges(), newMode, this.prevListSelection);
            }
            int idx = this.profileCombo.getSelectionIndex();
            this.currentCompProfile = this.getCompileProfile(idx);
            this.processProfileSelected(null);
            this.prevProfileComboSelection = idx;
        } else if (source == this.srcTypeCombo) {
            if (this.editpane.areErrorsPending()) {
                this.restoreProfileComboSelection = false;
                this.srcTypeCombo.getDisplay().asyncExec((Runnable)this);
                return;
            }
            if (this.sm.isSaveRequired()) {
                boolean newMode;
                boolean bl = newMode = this.sm.getMode() == 4;
                if (this.editpane.verify() != null) {
                    this.restoreProfileComboSelection = false;
                    this.sm.setChangesMade();
                    this.profileCombo.getDisplay().asyncExec((Runnable)this);
                    return;
                }
                this.saveCompileCommand(this.editpane.saveChanges(), newMode, this.prevListSelection);
            }
            int idx = this.srcTypeCombo.getSelectionIndex();
            this.currentCompType = this.currentCompProfile.getCompileType(this.srcTypeCombo.getText());
            this.processSrcTypeSelected(0);
            this.prevSrcTypeComboSelection = idx;
        }
    }

    protected void applyPressed(boolean doVerify) {
        this.ignoreEvents = true;
        if (!doVerify || this.editpane.verify() == null) {
            boolean ok;
            SystemCompileCommand editedCompileCmd = this.editpane.saveChanges();
            boolean bl = ok = editedCompileCmd != null;
            if (ok) {
                boolean newMode = this.sm.getMode() == 4;
                this.sm.applyPressed();
                this.saveCompileCommand(editedCompileCmd, newMode, this.prevListSelection);
                this.processCommandsListSelected();
                if (newMode) {
                    RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(1, 512, (Object)editedCompileCmd, null);
                } else {
                    RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(4, 512, (Object)editedCompileCmd, null);
                }
            }
        }
        this.ignoreEvents = false;
    }

    protected void revertPressed() {
        this.ignoreEvents = true;
        this.editpane.clearErrorMessage();
        this.sm.resetPressed();
        if (this.isNewSelected() || this.listView.getSelectionIndex() == -1) {
            this.editpane.setCompileCommand(this.currentCompType, null);
        } else {
            this.editpane.setCompileCommand(this.currentCompType, this.getCurrentlySelectedCompileCommand());
        }
        this.setPageComplete(true);
        this.clearErrorMessage();
        this.ignoreEvents = false;
    }

    protected void newSrcTypePressed() {
        if (this.sm.isSaveRequired()) {
            this.ignoreEvents = true;
            if (this.editpane.verify() != null) {
                this.ignoreEvents = false;
                return;
            }
            this.ignoreEvents = false;
            this.applyPressed(false);
        }
        SystemNewCompileSrcTypeDialog dlg = this.compileManager.getNewSrcTypeDialog(this.getShell(), this.caseSensitive);
        dlg.setExistingSrcTypes(this.compileTypeNames);
        dlg.open();
        if (!dlg.wasCancelled()) {
            String newSrcType = dlg.getNewSrcType();
            this.currentCompProfile.addCompileType(new SystemCompileType(this.currentCompProfile, newSrcType));
            this.saveData();
            this.processProfileSelected(newSrcType);
        }
    }

    protected void rmvSrcTypePressed() {
        if (this.sm.isSaveRequired()) {
            this.ignoreEvents = true;
            if (this.editpane.verify() != null) {
                this.ignoreEvents = false;
                return;
            }
            this.ignoreEvents = false;
            this.applyPressed(false);
        }
        this.currentCompProfile.removeCompileType(this.currentCompType);
        this.saveData();
        this.processProfileSelected(null);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void saveCompileCommand(SystemCompileCommand editedCompileCommand, boolean newMode, int selectionIndex) {
        if (newMode) {
            this.currentCompType.addCompileCommand(editedCompileCommand);
            this.listView.add(editedCompileCommand.getLabel());
            this.saveData();
            this.processSrcTypeSelected(this.listView.getItemCount() - 1);
        } else {
            this.saveData();
            this.processSrcTypeSelected(selectionIndex);
        }
    }

    public void setPageComplete(boolean complete) {
        if (this.applyButton != null && !complete) {
            this.applyButton.setEnabled(false);
        }
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        ISystemRemoteElementAdapter adapter = null;
        adapter = !(o instanceof IAdaptable) ? (ISystemRemoteElementAdapter)Platform.getAdapterManager().getAdapter(o, ISystemRemoteElementAdapter.class) : (ISystemRemoteElementAdapter)((IAdaptable)o).getAdapter(ISystemRemoteElementAdapter.class);
        return adapter;
    }

    protected boolean isNewSelected() {
        return this.listView.getSelectionIndex() == 0;
    }

    protected boolean isIBMSupplied() {
        if (this.listView.getSelectionIndex() > 0) {
            return !this.getCurrentlySelectedCompileCommand().isUserSupplied();
        }
        return false;
    }

    protected String getCurrentSelection() {
        if (this.listView.getSelectionCount() >= 1) {
            return this.listView.getSelection()[0];
        }
        return null;
    }

    protected SystemCompileCommand getCurrentlySelectedCompileCommand() {
        int selIdx = this.listView.getSelectionIndex();
        if (selIdx > 0) {
            return this.currentCompType.getCompileCommand(selIdx - 1);
        }
        return null;
    }

    public void compileCommandChanged(SystemMessage message) {
        if (message != null) {
            this.setErrorMessage(message);
        } else {
            this.clearErrorMessage();
        }
        if (!this.ignoreEvents) {
            this.sm.setChangesMade();
        }
        this.setPageComplete(message == null);
    }

    public void menuAboutToShow(IMenuManager menu) {
        Menu m;
        this.fillContextMenu(menu);
        if (!this.menuListenerAdded && menu instanceof MenuManager && (m = ((MenuManager)menu).getMenu()) != null) {
            this.menuListenerAdded = true;
            SystemViewMenuListener ml = new SystemViewMenuListener();
            m.addMenuListener((MenuListener)ml);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        String currentString = this.getCurrentSelection();
        StructuredSelection selection = null;
        if (currentString != null) {
            selection = new StructuredSelection((Object)currentString);
        }
        this.createStandardGroups(menu);
        SystemBaseAction action = null;
        boolean isNewSelected = this.isNewSelected();
        if (selection != null && !isNewSelected) {
            action = this.getDeleteAction((ISelection)selection);
            menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
            action = this.getCopyAction((ISelection)selection);
            menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
            action = this.getMoveUpAction((ISelection)selection);
            menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
            action = this.getMoveDownAction((ISelection)selection);
            menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
            action = this.getRestoreAction((ISelection)selection);
            menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
        }
        action = this.getPasteAction((ISelection)selection);
        menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
    }

    public void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.reorder"));
        menu.add((IContributionItem)new Separator("group.change"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    private SystemCompileCommandActionDelete getDeleteAction(ISelection selection) {
        if (this.deleteAction == null) {
            this.deleteAction = new SystemCompileCommandActionDelete(this);
        }
        this.deleteAction.setShell(this.getShell());
        this.deleteAction.setSelection(selection);
        return this.deleteAction;
    }

    private SystemCompileCommandActionMoveUp getMoveUpAction(ISelection selection) {
        if (this.moveUpAction == null) {
            this.moveUpAction = new SystemCompileCommandActionMoveUp(this);
        }
        this.moveUpAction.setShell(this.getShell());
        this.moveUpAction.setSelection(selection);
        return this.moveUpAction;
    }

    private SystemCompileCommandActionMoveDown getMoveDownAction(ISelection selection) {
        if (this.moveDownAction == null) {
            this.moveDownAction = new SystemCompileCommandActionMoveDown(this);
        }
        this.moveDownAction.setShell(this.getShell());
        this.moveDownAction.setSelection(selection);
        return this.moveDownAction;
    }

    private SystemCompileCommandActionCopy getCopyAction(ISelection selection) {
        if (this.copyAction == null) {
            this.copyAction = new SystemCompileCommandActionCopy(this);
        }
        this.copyAction.setShell(this.getShell());
        this.copyAction.setSelection(selection);
        return this.copyAction;
    }

    private SystemCompileCommandActionPaste getPasteAction(ISelection selection) {
        if (this.pasteAction == null) {
            this.pasteAction = new SystemCompileCommandActionPaste(this);
        }
        this.pasteAction.setShell(this.getShell());
        if (selection != null) {
            this.pasteAction.setSelection(selection);
        }
        return this.pasteAction;
    }

    private SystemCompileCommandActionRestoreDefaults getRestoreAction(ISelection selection) {
        if (this.restoreAction == null) {
            this.restoreAction = new SystemCompileCommandActionRestoreDefaults(this);
        }
        this.restoreAction.setShell(this.getShell());
        if (selection != null) {
            this.restoreAction.setSelection(selection);
        }
        return this.restoreAction;
    }

    public boolean canDelete() {
        return this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isNewSelected() && this.listView.getSelectionIndex() != -1 && !this.isIBMSupplied();
    }

    public void doDelete() {
        int idx = this.listView.getSelectionIndex();
        SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEG1052");
        SystemMessageDialog msgDlg = new SystemMessageDialog(this.getShell(), msg);
        try {
            if (msgDlg.openQuestion()) {
                SystemCompileCommand deletedCmd = this.getCurrentlySelectedCompileCommand();
                this.currentCompType.removeCompileCommand(deletedCmd);
                this.saveData();
                this.listView.remove(idx);
                if (idx <= this.listView.getItemCount() - 1) {
                    this.listView.select(idx);
                } else {
                    this.listView.select(idx - 1);
                }
                this.processCommandsListSelected();
                if (this.listView.getItemCount() == 1) {
                    this.rmvSrcTypeButton.setEnabled(true);
                }
                RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(2, 512, (Object)deletedCmd, null);
            }
        }
        catch (Exception exception) {}
    }

    public boolean canMoveUp() {
        boolean can;
        boolean bl = can = this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isNewSelected() && this.listView.getSelectionIndex() != -1;
        if (can) {
            int idx = this.listView.getSelectionIndex();
            can = idx > 1;
        }
        return can;
    }

    public void doMoveUp() {
        int idx = this.listView.getSelectionIndex();
        SystemCompileCommand currCmd = this.getCurrentlySelectedCompileCommand();
        if (currCmd == null) {
            return;
        }
        this.currentCompType.removeCompileCommand(currCmd);
        this.currentCompType.insertCompileCommand(currCmd, idx - 2);
        this.saveData();
        this.listView.remove(idx);
        this.listView.add(currCmd.getLabel(), idx - 1);
        this.listView.select(idx - 1);
        this.listView.showSelection();
        this.processCommandsListSelected();
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(16, 512, (Object)currCmd, null);
    }

    public boolean canMoveDown() {
        boolean can;
        boolean bl = can = this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isNewSelected() && this.listView.getSelectionIndex() != -1;
        if (can) {
            int idx = this.listView.getSelectionIndex();
            can = idx <= this.listView.getItemCount() - 2;
        }
        return can;
    }

    public void doMoveDown() {
        int idx = this.listView.getSelectionIndex();
        SystemCompileCommand currCmd = this.getCurrentlySelectedCompileCommand();
        if (currCmd == null) {
            return;
        }
        this.currentCompType.removeCompileCommand(currCmd);
        this.currentCompType.insertCompileCommand(currCmd, idx);
        this.saveData();
        this.listView.remove(idx);
        this.listView.add(currCmd.getLabel(), idx + 1);
        this.listView.select(idx + 1);
        this.listView.showSelection();
        this.processCommandsListSelected();
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(16, 512, (Object)currCmd, null);
    }

    public boolean canCopy() {
        boolean can = this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isNewSelected() && this.listView.getSelectionIndex() != -1;
        return can;
    }

    public void doCopy() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.getShell().getDisplay());
        }
        String selection = this.getCurrentSelection();
        TextTransfer transfer = TextTransfer.getInstance();
        this.clipboard.setContents(new Object[]{selection}, new Transfer[]{transfer});
    }

    public boolean canPaste() {
        if (this.clipboard == null) {
            return false;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        String textData = (String)this.clipboard.getContents((Transfer)textTransfer);
        return textData != null && textData.length() > 0;
    }

    public void doPaste() {
        if (this.clipboard == null) {
            return;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        String textData = (String)this.clipboard.getContents((Transfer)textTransfer);
        SystemCompileCommand oldCmd = this.currentCompType.getCompileLabel(textData);
        if (oldCmd == null) {
            return;
        }
        SystemCompileCommand newCmd = (SystemCompileCommand)oldCmd.clone();
        newCmd.setLabel(this.getUniqueCloneLabel(oldCmd));
        String newCopy = newCmd.getLabel();
        int newLocation = this.listView.getSelectionIndex();
        if (newLocation <= 0) {
            this.listView.add(newCopy);
            this.listView.select(this.listView.getItemCount() - 1);
        } else {
            this.listView.add(newCopy, newLocation);
            this.listView.select(newLocation);
        }
        this.listView.showSelection();
        this.currentCompType.insertCompileCommand(newCmd, this.listView.getSelectionIndex() - 1);
        this.saveData();
        this.processCommandsListSelected();
        this.clipboard.dispose();
        this.clipboard = null;
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(2, 512, (Object)oldCmd, null);
    }

    private String getUniqueCloneLabel(SystemCompileCommand clonableCmd) {
        String newName = SystemUDAResources.RESID_WWCOMPCMDS_COPY_NAME_1;
        newName = SystemMessage.sub((String)newName, (String)"%1", (String)clonableCmd.getLabel());
        Vector existingNames = this.currentCompType.getExistingLabels();
        boolean nameInUse = existingNames.indexOf(newName) >= 0;
        int nbr = 2;
        while (nameInUse) {
            newName = SystemUDAResources.RESID_WWCOMPCMDS_COPY_NAME_N;
            newName = SystemMessage.sub((String)newName, (String)"%1", (String)clonableCmd.getLabel());
            nameInUse = existingNames.indexOf(newName = SystemMessage.sub((String)newName, (String)"%2", (String)Integer.toString(nbr))) >= 0;
            ++nbr;
        }
        return newName;
    }

    public boolean canRestore() {
        boolean can;
        boolean bl = can = this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isNewSelected();
        if (can) {
            SystemCompileCommand cmd = this.getCurrentlySelectedCompileCommand();
            can = cmd != null ? !cmd.isUserSupplied() && !cmd.getDefaultString().equals(cmd.getCurrentString()) : false;
        }
        return can;
    }

    public void doRestore() {
        SystemCompileCommand cmd = this.getCurrentlySelectedCompileCommand();
        cmd.setCurrentString(cmd.getDefaultString());
        this.saveData();
        this.processCommandsListSelected();
    }

    public void run() {
        if (this.restoreProfileComboSelection) {
            this.profileCombo.select(this.prevProfileComboSelection);
        } else {
            this.srcTypeCombo.select(this.prevSrcTypeComboSelection);
        }
        super.run();
    }
}

