/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.monitor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.view.monitor.MonitorViewPage;
import org.eclipse.rse.internal.ui.view.monitor.SystemMonitorViewPart;
import org.eclipse.rse.internal.ui.view.monitor.TabFolderLayout;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemTableView;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MonitorViewWorkbook
extends Composite {
    private CTabFolder _folder = new CTabFolder((Composite)this, 0);
    private SystemMonitorViewPart _viewPart;

    public MonitorViewWorkbook(Composite parent, SystemMonitorViewPart viewPart) {
        super(parent, 0);
        this._folder.setLayout((Layout)new TabFolderLayout());
        this._folder.setLayoutData((Object)new GridData(1808));
        this.setLayout((Layout)new FillLayout());
        this._viewPart = viewPart;
    }

    public void dispose() {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            CTabItem item = this._folder.getItem(i);
            if (!item.isDisposed()) {
                MonitorViewPage page = (MonitorViewPage)item.getData();
                page.dispose();
            }
            ++i;
        }
        this._folder.dispose();
        super.dispose();
    }

    public CTabFolder getFolder() {
        return this._folder;
    }

    public void remove(Object root) {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            MonitorViewPage page;
            CTabItem item = this._folder.getItem(i);
            if (!item.isDisposed() && (page = (MonitorViewPage)item.getData()) != null && root == page.getInput()) {
                item.dispose();
                page.dispose();
                page = null;
                item = null;
                this._folder.redraw();
                return;
            }
            ++i;
        }
    }

    public void removeDisconnected() {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            ISubSystem subSystem;
            IAdaptable input;
            ISystemViewElementAdapter adapter;
            MonitorViewPage page;
            CTabItem item = this._folder.getItem(i);
            if (!item.isDisposed() && (page = (MonitorViewPage)item.getData()) != null && (adapter = (ISystemViewElementAdapter)(input = (IAdaptable)page.getInput()).getAdapter(ISystemViewElementAdapter.class)) != null && (subSystem = adapter.getSubSystem(input)) != null && !subSystem.isConnected()) {
                item.dispose();
                page.dispose();
                page = null;
                item = null;
                this._folder.redraw();
            }
            ++i;
        }
    }

    public CTabItem getSelectedTab() {
        if (this._folder.getItemCount() > 0) {
            int index = this._folder.getSelectionIndex();
            CTabItem item = this._folder.getItem(index);
            return item;
        }
        return null;
    }

    public MonitorViewPage getCurrentTabItem() {
        int index;
        if (this._folder.getItemCount() > 0 && (index = this._folder.getSelectionIndex()) >= 0) {
            CTabItem item = this._folder.getItem(index);
            return (MonitorViewPage)item.getData();
        }
        return null;
    }

    public void showCurrentPage() {
        this._folder.setFocus();
    }

    public Object getInput() {
        MonitorViewPage page = this.getCurrentTabItem();
        if (page != null) {
            page.setFocus();
            return page.getInput();
        }
        return null;
    }

    public SystemTableView getViewer() {
        if (this.getCurrentTabItem() != null) {
            return this.getCurrentTabItem().getViewer();
        }
        return null;
    }

    public void addItemToMonitor(IAdaptable root, boolean createTab) {
        if (!this._folder.isDisposed()) {
            int i = 0;
            while (i < this._folder.getItemCount()) {
                CTabItem item = this._folder.getItem(i);
                MonitorViewPage page = (MonitorViewPage)item.getData();
                if (page != null && root == page.getInput()) {
                    page.getViewer().refresh();
                    if (this._folder.getSelectionIndex() != i) {
                        this._folder.setSelection(item);
                    }
                    this.updateActionStates();
                    return;
                }
                ++i;
            }
            if (createTab) {
                this.createTabItem(root);
            }
        }
    }

    private void createTabItem(IAdaptable root) {
        MonitorViewPage monitorViewPage = new MonitorViewPage(this._viewPart);
        CTabItem titem = new CTabItem(this._folder, 64);
        this.setTabTitle(root, titem);
        titem.setData((Object)monitorViewPage);
        titem.setControl((Control)monitorViewPage.createTabFolderPage(this._folder, this._viewPart.getEditorActionHandler()));
        this._folder.setSelection(titem);
        monitorViewPage.setInput(root);
        SystemTableView viewer = monitorViewPage.getViewer();
        if (this._viewPart != null) {
            this._viewPart.setActiveViewerSelectionProvider(viewer);
            this._viewPart.getSite().registerContextMenu(viewer.getContextMenuManager(), (ISelectionProvider)viewer);
            this._viewPart.getSite().registerContextMenu("org.eclipse.rse.views.common", viewer.getContextMenuManager(), (ISelectionProvider)viewer);
        }
        monitorViewPage.setFocus();
        titem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Object source = e.getSource();
                if (source instanceof CTabItem) {
                    CTabItem currentItem = (CTabItem)source;
                    Object data = currentItem.getData();
                    if (data instanceof MonitorViewPage) {
                        MonitorViewPage page = (MonitorViewPage)data;
                        page.setPollingEnabled(false);
                        page.dispose();
                    }
                    MonitorViewWorkbook.this.updateActionStates();
                }
            }
        });
    }

    private void setTabTitle(IAdaptable root, CTabItem titem) {
        ISystemViewElementAdapter va = (ISystemViewElementAdapter)root.getAdapter(ISystemViewElementAdapter.class);
        if (va != null) {
            titem.setText(va.getName(root));
            titem.setImage(va.getImageDescriptor(root).createImage());
        }
    }

    public void setInput(IAdaptable root) {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            CTabItem item = this._folder.getItem(i);
            MonitorViewPage page = (MonitorViewPage)item.getData();
            if (root == page.getInput()) {
                this._folder.setSelection(i);
                page.getViewer().refresh();
                return;
            }
            ++i;
        }
    }

    public void updateActionStates() {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            MonitorViewPage page;
            CTabItem item = this._folder.getItem(i);
            if (!item.isDisposed() && (page = (MonitorViewPage)item.getData()) != null) {
                page.updateActionStates();
            }
            ++i;
        }
    }

    public void updateTitleIcon(IAdaptable root) {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            MonitorViewPage page;
            CTabItem item = this._folder.getItem(i);
            if (!item.isDisposed() && (page = (MonitorViewPage)item.getData()) != null && page.getInput() == root) {
                this.setTabTitle(root, item);
                break;
            }
            ++i;
        }
    }
}

