/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.synchronize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;

public class SynchronizeTestBase
extends RSEBaseConnectionTestCase {
    private String fPropertiesFileName;
    public static String fDefaultPropertiesFile = "localConnection.properties";
    protected IFileServiceSubSystem fss;
    protected IFileService fs;
    private IRemoteFile fHomeDirectory;
    protected IRemoteFile remoteTempDir;
    private String tempDirPath;

    public SynchronizeTestBase(String name) {
        this(name, fDefaultPropertiesFile);
    }

    public SynchronizeTestBase(String name, String propertiesFileName) {
        super(name);
        this.fPropertiesFileName = propertiesFileName;
        if (propertiesFileName != null) {
            int idx = propertiesFileName.indexOf("Connection.properties");
            String targetName = propertiesFileName.substring(0, idx);
            this.setTargetName(targetName);
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        IHost host = this.getHost(this.fPropertiesFileName);
        this.fss = (IFileServiceSubSystem)RemoteFileUtility.getFileSubSystem((IHost)host);
        this.fs = this.fss.getFileService();
        this.fss.checkIsConnected(this.getDefaultProgressMonitor());
        this.fHomeDirectory = this.fss.getRemoteFileObject(".", this.getDefaultProgressMonitor());
        this.remoteTempDir = this.fss.getRemoteFileObject(this.fHomeDirectory, "rsetest" + System.currentTimeMillis(), this.getDefaultProgressMonitor());
        this.fss.createFolder(this.remoteTempDir, this.getDefaultProgressMonitor());
        this.tempDirPath = this.remoteTempDir.getAbsolutePath();
    }

    public void tearDown() throws Exception {
        this.fss.delete(this.remoteTempDir, this.getDefaultProgressMonitor());
        super.tearDown();
    }

    public boolean isWindows() {
        return this.fss.getHost().getSystemType().isWindows();
    }

    public IProgressMonitor getMonitor() {
        return this.getDefaultProgressMonitor();
    }

    public String getTempDirPath() {
        return this.tempDirPath;
    }

    public static void fail(String message, Throwable e) {
        if (e instanceof CoreException) {
            IStatus status = ((CoreException)e).getStatus();
            if (status.getException() == null) {
                e.printStackTrace();
            }
            SynchronizeTestBase.write(status, 0);
        } else {
            e.printStackTrace();
        }
        SynchronizeTestBase.fail((String)(String.valueOf(message) + ": " + e));
    }

    private static void write(IStatus status, int indent) {
        PrintStream output = System.out;
        SynchronizeTestBase.indent(output, indent);
        output.println("Severity: " + status.getSeverity());
        SynchronizeTestBase.indent(output, indent);
        output.println("Plugin ID: " + status.getPlugin());
        SynchronizeTestBase.indent(output, indent);
        output.println("Code: " + status.getCode());
        SynchronizeTestBase.indent(output, indent);
        output.println("Message: " + status.getMessage());
        if (status.getException() != null) {
            SynchronizeTestBase.indent(output, indent);
            output.print("Exception: ");
            status.getException().printStackTrace(output);
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                SynchronizeTestBase.write(children[i], indent + 1);
                ++i;
            }
        }
    }

    private static void indent(OutputStream output, int indent) {
        int i = 0;
        while (i < indent) {
            try {
                output.write("\t".getBytes());
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    public String getUniqueString() {
        return new UniversalUniqueIdentifier().toString();
    }

    protected void create(IResource resource, boolean local) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            this.create((IResource)resource.getParent(), local);
        }
        switch (resource.getType()) {
            case 1: {
                ((IFile)resource).create((InputStream)(local ? new ByteArrayInputStream(new byte[0]) : null), true, this.getMonitor());
                break;
            }
            case 2: {
                ((IFolder)resource).create(true, local, this.getMonitor());
                break;
            }
            case 4: {
                ((IProject)resource).create(this.getMonitor());
                ((IProject)resource).open(this.getMonitor());
            }
        }
    }

    public void ensureExistsInWorkspace(final IResource[] resources, final boolean local) {
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < resources.length) {
                    SynchronizeTestBase.this.create(resources[i], local);
                    ++i;
                }
            }
        };
        try {
            SynchronizeTestBase.getWorkspace().run(body, null);
        }
        catch (CoreException e) {
            SynchronizeTestBase.fail("#ensureExistsInWorkspace(IResource[])", e);
        }
    }

    public void ensureDoesNotExistInWorkspace(IResource resource) {
        try {
            if (resource.exists()) {
                resource.delete(true, null);
            }
        }
        catch (CoreException e) {
            SynchronizeTestBase.fail("#ensureDoesNotExistInWorkspace(IResource): " + resource.getFullPath(), e);
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected static IProject getProject(String name) {
        return SynchronizeTestBase.getWorkspace().getRoot().getProject(name);
    }
}

