/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.internal.useractions.ui.SystemCmdSubstVarList;
import org.eclipse.rse.internal.useractions.ui.compile.ISystemCompileCommandSubstitutor;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileType;

public class SystemCompileCommand
implements Cloneable,
IAdaptable {
    private SystemCompileType parentType;
    private String nature;
    private String id;
    private String label;
    private String defaultString;
    private String currentString;
    private String menuOption;
    private String jobEnv;
    private int order;
    private boolean isLabelEditable = true;
    private static final String ID_IBM_PREFIX = "com.ibm";
    private static final String ID_USER_PREFIX = "user";

    public SystemCompileCommand(SystemCompileType parentType) {
        this.setParentType(parentType);
        this.setMenuOptionBoth();
    }

    public SystemCompileCommand(SystemCompileType parentType, String id, String label, String nature, String defaultString, String currentString, String menuOption, int order) {
        this.setParentType(parentType);
        this.setId(id);
        this.setLabel(label);
        this.setNature(nature);
        this.setDefaultString(defaultString);
        this.setCurrentString(currentString);
        this.setMenuOption(menuOption);
        this.setOrder(order);
        if (id == null) {
            this.configureId();
        }
    }

    public void setParentType(SystemCompileType parentType) {
        this.parentType = parentType;
    }

    public SystemCompileType getParentType() {
        return this.parentType;
    }

    public void setId(String identifier) {
        this.id = identifier;
    }

    public String getId() {
        return this.id;
    }

    private void configureId() {
        if (this.nature != null && this.label != null) {
            if (this.isIBMSupplied()) {
                this.setId("com.ibm." + this.label);
            } else if (this.isUserSupplied()) {
                this.setId("user." + this.label);
            }
        }
    }

    public void setLabel(String name) {
        this.label = name;
        this.configureId();
    }

    public String getLabel() {
        return this.label;
    }

    public void setNature(String nature) {
        this.nature = nature;
        this.configureId();
        if (this.isIBMSupplied()) {
            this.setLabelEditable(false);
            this.setCommandStringEditable(true);
        } else if (this.isUserSupplied()) {
            this.setLabelEditable(true);
            this.setCommandStringEditable(true);
        }
    }

    public void setIsIBMSupplied() {
        this.setNature("IBM defined");
    }

    public void setIsUserSupplied() {
        this.setNature("User defined");
    }

    public void setIsISVSupplied() {
        this.setNature("ISV defined");
    }

    public String getNature() {
        return this.nature;
    }

    public boolean isIBMSupplied() {
        return this.nature.equals("IBM defined");
    }

    public boolean isUserSupplied() {
        return this.nature.equals("User defined");
    }

    public boolean isISVSupplied() {
        return this.nature.equals("ISV defined");
    }

    public void setDefaultString(String defaultString) {
        this.defaultString = defaultString;
    }

    public String getDefaultString() {
        return this.defaultString;
    }

    public void setCurrentString(String currentString) {
        this.currentString = currentString;
    }

    public String getCurrentString() {
        return this.currentString;
    }

    public void setMenuOption(String menuOption) {
        this.menuOption = menuOption;
    }

    public void setMenuOptionBoth() {
        this.setMenuOption("Both");
    }

    public String getMenuOption() {
        return this.menuOption;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isPromptable() {
        return this.menuOption.equals("Both") || this.menuOption.equals("Prompt");
    }

    public boolean isNonPromptable() {
        return this.menuOption.equals("Both") || this.menuOption.equals("NoPrompt");
    }

    public void setJobEnvironment(String jobenv) {
        this.jobEnv = jobenv;
    }

    public String getJobEnvironment() {
        return this.jobEnv;
    }

    public void setLabelEditable(boolean editable) {
        this.isLabelEditable = editable;
    }

    public boolean isLabelEditable() {
        return this.isLabelEditable;
    }

    public void setCommandStringEditable(boolean editable) {
    }

    public boolean isCommandStringEditable() {
        return true;
    }

    public Object clone() {
        SystemCompileCommand clone = null;
        try {
            clone = (SystemCompileCommand)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.setNature("User defined");
        clone.setDefaultString(null);
        clone.configureId();
        if (this.jobEnv != null) {
            clone.setJobEnvironment(this.jobEnv);
        }
        return clone;
    }

    public void printCommand(String indent) {
        System.out.println(String.valueOf(indent) + "Label: '" + this.label + "', Cmd: '" + this.currentString + "'");
    }

    public String doVariableSubstitution(Object remoteObject, ISystemCompileCommandSubstitutor substitutor) {
        SystemCompileManager mgr = this.parentType.getParentProfile().getParentManager();
        mgr.setCurrentCompileCommand(this);
        SystemCmdSubstVarList substVarList = mgr.getSubstitutionVariableList();
        String substitutedString = substVarList.doSubstitutions(this.getCurrentString(), remoteObject, substitutor);
        mgr.setCurrentCompileCommand(null);
        return substitutedString;
    }

    public String toString() {
        return this.getCurrentString();
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }
}

