/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDTypeEditPaneTypesSelector;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.validators.ValidatorUserTypeTypes;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemUDSimpleTypesListEditor
implements ISystemUDTypeEditPaneTypesSelector {
    protected Text textTypes;
    protected Label typesLabel;
    protected Label nonEditableVerbage;
    private boolean autoUpperCase = false;
    private ISystemValidator typesValidator;
    private int currentDomain = -1;
    protected ISystemMessageLine msgLine;
    protected Shell shell;

    public SystemUDSimpleTypesListEditor(Composite parent, int nbrColumns) {
        this.shell = parent.getShell();
        this.createContents(parent, nbrColumns);
        this.setValidator(new ValidatorUserTypeTypes());
    }

    public void setMessageLine(ISystemMessageLine msgLine) {
        this.msgLine = msgLine;
    }

    protected void createContents(Composite parent, int nbrColumns) {
        this.textTypes = SystemWidgetHelpers.createLabeledTextField((Composite)parent, null, (String)SystemUDAResources.RESID_UDT_TYPES_LABEL, (String)SystemUDAResources.RESID_UDT_TYPES_TOOLTIP);
        this.typesLabel = SystemWidgetHelpers.getLastLabel();
        ((GridData)this.textTypes.getLayoutData()).horizontalSpan = nbrColumns - 1;
        this.textTypes.setTextLimit(512);
        this.nonEditableVerbage = SystemWidgetHelpers.createVerbiage((Composite)parent, (String)"", (int)nbrColumns, (boolean)false, (int)200);
        this.nonEditableVerbage.setVisible(false);
    }

    public void setDomain(int domain) {
        this.currentDomain = domain;
    }

    public int getDomain() {
        return this.currentDomain;
    }

    public void setValidator(ISystemValidator validator) {
        this.typesValidator = validator;
    }

    public void setTypes(String types) {
        this.textTypes.setText(types);
    }

    public void clearTypes() {
        this.textTypes.setText("");
    }

    public String getTypes() {
        if (this.autoUpperCase) {
            return this.textTypes.getText().trim().toUpperCase();
        }
        return this.textTypes.getText().trim();
    }

    public void addModifyListener(ModifyListener listener) {
        this.textTypes.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.textTypes.removeModifyListener(listener);
    }

    public SystemMessage validate() {
        return this.typesValidator.validate(this.getTypes());
    }

    public Control getControl() {
        return this.textTypes;
    }

    public void setEnabled(boolean enable) {
        this.textTypes.setEnabled(enable);
    }

    public void setEditable(boolean editable, String vendor) {
        this.textTypes.setEditable(editable);
        if (editable) {
            this.nonEditableVerbage.setVisible(false);
        } else {
            this.nonEditableVerbage.setVisible(true);
            if (vendor.equals("IBM")) {
                this.nonEditableVerbage.setText(SystemUDAResources.RESID_UDT_IBM_VERBAGE);
            } else {
                String verbage = SystemUDAResources.RESID_UDT_VENDOR_VERBAGE;
                verbage = SystemMessage.sub((String)verbage, (String)"%1", (String)vendor);
                this.nonEditableVerbage.setText(verbage);
            }
        }
    }

    public void setAutoUpperCase(boolean autoUpperCase) {
        this.autoUpperCase = autoUpperCase;
    }
}

