/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.eclipse.rse.tests.RSETestsPlugin;
import org.eclipse.rse.tests.core.IRSETestLogCollectorDelegate;
import org.eclipse.rse.tests.core.RSEWaitAndDispatchUtil;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.osgi.framework.Bundle;

public class RSECoreTestCase
extends TestCase {
    private final Properties properties = new Properties();
    private final String PROP_RSE_SYSTEMS_VIEW_ZOOM_STATE_CHANGED = "rseSystemsViewZoomStateChanged";
    private String targetName = null;
    private static final String defaultClientName;
    private String clientName = defaultClientName;
    static final QualifiedName BACKGROUND_TEST_EXECUTION_FINISHED;
    private final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
    final TestListener TEST_LISTENER = new RSETestFailureListener();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.core.RSECoreTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        defaultClientName = (String.valueOf(System.getProperty("os.name")) + '.' + System.getProperty("os.arch")).replace(' ', '_');
        BACKGROUND_TEST_EXECUTION_FINISHED = new QualifiedName(RSETestsPlugin.getDefault().getBundle().getSymbolicName(), "background_test_execution_finished");
    }

    public RSECoreTestCase() {
        this(null);
    }

    public RSECoreTestCase(String name) {
        super(name);
        this.properties.clear();
        this.initializeProperties();
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    protected void initializeProperties() {
        this.setProperty("org.eclipse.rse.tests.core.maximizeRemoteSystemsView", false);
        this.setProperty("org.eclipse.rse.tests.core.switchToPerspective", "org.eclipse.rse.ui.view.SystemPerspective");
        this.setProperty("org.eclipse.rse.tests.core.forceBackgroundExecution", false);
        this.setProperty("org.eclipse.rse.tests.core.timingsIncludeSetupAndTearDown", false);
        this.setProperty("rseSystemsViewZoomStateChanged", false);
    }

    protected final void setProperty(String key, boolean enable) {
        this.setProperty(key, enable ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    protected final boolean isProperty(String key, boolean value) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        return (value ? Boolean.TRUE : Boolean.FALSE).equals(Boolean.valueOf(this.properties.getProperty(key, "false")));
    }

    protected final void setProperty(String key, String value) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (key != null) {
            if (value != null) {
                this.properties.setProperty(key, value);
            } else {
                this.properties.remove(key);
            }
        }
    }

    protected final boolean isProperty(String key, String value) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (value != null) {
            return value.equalsIgnoreCase(this.properties.getProperty(key));
        }
        return !this.properties.containsKey(key);
    }

    protected final String getProperty(String key) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        return this.properties.getProperty(key, null);
    }

    protected String getTestNameForCheck() {
        String testName = this.getName();
        String testClass = ((Object)((Object)this)).getClass().getName();
        String testPackage = ((Object)((Object)this)).getClass().getPackage().getName();
        String testClassSimpleName = testClass.substring(testPackage.length() + 1);
        String checkName = String.valueOf(testClassSimpleName) + '.' + testName;
        if (this.targetName != null) {
            checkName = String.valueOf(checkName) + '.' + this.targetName;
        }
        if (this.clientName != null) {
            checkName = String.valueOf(this.clientName) + '.' + checkName;
        }
        return checkName;
    }

    protected boolean isTestDisabled() {
        String testPackage;
        String testName = this.getName();
        String testClass = ((Object)((Object)this)).getClass().getName();
        String testClassSimpleName = testClass.substring((testPackage = ((Object)((Object)this)).getClass().getPackage().getName()).length() + 1);
        String checkName = String.valueOf(testClassSimpleName) + '.' + testName;
        String checkString = checkName;
        if (!RSETestsPlugin.isTestCaseEnabled(checkString)) {
            System.out.println("--> disabled due to rule: " + checkString);
            return true;
        }
        checkString = String.valueOf(testClassSimpleName) + ".*";
        if (!RSETestsPlugin.isTestCaseEnabled(checkString)) {
            System.out.println("--> disabled due to rule: " + checkString);
            return true;
        }
        checkString = "*." + testName;
        if (!RSETestsPlugin.isTestCaseEnabled(checkString)) {
            System.out.println("--> disabled due to rule: " + checkString);
            return true;
        }
        if (this.targetName != null) {
            checkString = "*." + this.targetName;
            if (!RSETestsPlugin.isTestCaseEnabled(checkString)) {
                System.out.println("--> disabled due to rule: " + checkString);
                return true;
            }
            checkString = String.valueOf(checkName) + '.' + this.targetName;
            if (!RSETestsPlugin.isTestCaseEnabled(checkString)) {
                System.out.println("--> disabled due to rule: " + checkString);
                return true;
            }
            if (this.clientName != null && !RSETestsPlugin.isTestCaseEnabled(checkString = this.getTestNameForCheck())) {
                System.out.println("--> disabled due to rule: " + checkString);
                return true;
            }
        }
        if (this.clientName != null) {
            checkString = String.valueOf(this.clientName) + ".*";
            if (!RSETestsPlugin.isTestCaseEnabled(checkString)) {
                System.out.println("--> disabled due to rule: " + checkString);
                return true;
            }
            checkString = String.valueOf(this.clientName) + '.' + checkName;
            if (!RSETestsPlugin.isTestCaseEnabled(checkString)) {
                System.out.println("--> disabled due to rule: " + checkString);
                return true;
            }
        }
        return false;
    }

    final void invokeTestCaseRunImpl(TestResult result) {
        super.run(result);
    }

    public final void run(TestResult result) {
        if (this.isProperty("org.eclipse.rse.tests.core.forceBackgroundExecution", false) || !RSEWaitAndDispatchUtil.isDispatchThread()) {
            result.addListener(this.TEST_LISTENER);
            super.run(result);
            result.removeListener(this.TEST_LISTENER);
        } else {
            RSEBackgroundTestExecutionJob job = new RSEBackgroundTestExecutionJob(result);
            job.setProperty(BACKGROUND_TEST_EXECUTION_FINISHED, Boolean.FALSE);
            job.schedule();
            RSEWaitAndDispatchUtil.waitAndDispatch(0L, new RSEBackgroundTestExecutionJobWaiter(job));
        }
    }

    public void runBare() throws Throwable {
        if (this.isProperty("org.eclipse.rse.tests.core.timingsIncludeSetupAndTearDown", true)) {
            long start = this.printTestStartInformation(this.getName());
            try {
                super.runBare();
            }
            finally {
                this.printTestEndInformation(this.getName(), start);
            }
        } else {
            super.runBare();
        }
    }

    protected void runTest() throws Throwable {
        if (this.isProperty("org.eclipse.rse.tests.core.timingsIncludeSetupAndTearDown", false)) {
            long start = this.printTestStartInformation(this.getName());
            try {
                super.runTest();
            }
            finally {
                this.printTestEndInformation(this.getName(), start);
            }
        } else {
            super.runTest();
        }
    }

    protected long printTestStartInformation(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        long startTime = System.currentTimeMillis();
        if (name != null) {
            System.out.println("\n=== " + name + " started at: " + this.DATE_FORMAT.format(new Date(startTime)));
        }
        return startTime;
    }

    protected void printTestEndInformation(String name, long startTime) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        long endTime = System.currentTimeMillis();
        if (name != null) {
            long duration = endTime - startTime;
            System.out.println("=== " + name + " finished at: " + this.DATE_FORMAT.format(new Date(endTime)) + " (duration: " + duration + " ms)");
        }
    }

    protected void waitForRSEWorkspaceInit() throws InterruptedException {
        Job[] jobs = Job.getJobManager().find(null);
        int i = 0;
        while (i < jobs.length) {
            if ("Initialize RSE".equals(jobs[i].getName())) {
                System.out.println("Waiting for InitRSEJob");
                jobs[i].join();
                break;
            }
            ++i;
        }
        IRSEPersistenceManager pm = RSECorePlugin.getThePersistenceManager();
        while (!pm.isRestoreComplete() || pm.isBusy()) {
            System.err.println("Waiting for Persistence Manager");
            Thread.sleep(100L);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.waitForRSEWorkspaceInit();
        this.switchMaximizeSystemsView();
    }

    protected void flushEventQueue() throws Exception {
        Display display = Display.getCurrent();
        if (display != null) {
            Exception eventLoopException = null;
            while (!display.isDisposed()) {
                try {
                    if (display.readAndDispatch()) continue;
                    break;
                }
                catch (Exception e) {
                    if (eventLoopException == null) {
                        eventLoopException = e;
                        continue;
                    }
                    System.out.println("Multiple unhandled event loop exceptions:");
                    e.printStackTrace();
                }
            }
            if (eventLoopException != null) {
                throw eventLoopException;
            }
        } else {
            final Exception[] ex = new Exception[1];
            display = Display.getDefault();
            display.syncExec(new Runnable(){

                public void run() {
                    try {
                        RSECoreTestCase.this.flushEventQueue();
                    }
                    catch (Exception e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
        }
    }

    protected void tearDown() throws Exception {
        this.restoreMaximizeSystemsView();
        this.flushEventQueue();
        super.tearDown();
    }

    protected void switchMaximizeSystemsView() {
        final String perspectiveId = this.getProperty("org.eclipse.rse.tests.core.switchToPerspective");
        RSECoreTestCase.assertNotNull((String)"Invalid null-value for test case perspective id!", (Object)perspectiveId);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                RSECoreTestCase.this.hideView("org.eclipse.ui.internal.introview", perspectiveId);
                RSECoreTestCase.this.setProperty("rseSystemsViewZoomStateChanged", false);
                IViewPart part = RSECoreTestCase.this.showView("org.eclipse.rse.ui.view.systemView", perspectiveId);
                RSECoreTestCase.assertNotNull((String)"RSE Remote System View is not available!", (Object)part);
                IViewReference reference = RSECoreTestCase.this.findView("org.eclipse.rse.ui.view.systemView", perspectiveId);
                RSECoreTestCase.assertNotNull((String)"Failed to lookup view reference for RSE Remote Systems View!", (Object)reference);
                if (reference.getPage().getPartState((IWorkbenchPartReference)reference) != 1 && RSECoreTestCase.this.isProperty("org.eclipse.rse.tests.core.maximizeRemoteSystemsView", true)) {
                    reference.getPage().toggleZoom((IWorkbenchPartReference)reference);
                    RSECoreTestCase.this.setProperty("rseSystemsViewZoomStateChanged", true);
                } else if (reference.getPage().getPartState((IWorkbenchPartReference)reference) == 1 && RSECoreTestCase.this.isProperty("org.eclipse.rse.tests.core.maximizeRemoteSystemsView", false)) {
                    reference.getPage().toggleZoom((IWorkbenchPartReference)reference);
                    RSECoreTestCase.this.setProperty("rseSystemsViewZoomStateChanged", true);
                }
            }
        });
        if (this.isProperty("rseSystemsViewZoomStateChanged", true)) {
            System.err.println("Waiting for UI to repaint");
            RSEWaitAndDispatchUtil.waitAndDispatch(1000L);
        }
    }

    protected void restoreMaximizeSystemsView() {
        if (this.isProperty("rseSystemsViewZoomStateChanged", true)) {
            final String perspectiveId = this.getProperty("org.eclipse.rse.tests.core.switchToPerspective");
            RSECoreTestCase.assertNotNull((String)"Invalid null-value for test case perspective id!", (Object)perspectiveId);
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    IViewReference reference = RSECoreTestCase.this.findView("org.eclipse.rse.ui.view.systemView", perspectiveId);
                    RSECoreTestCase.assertNotNull((String)"Failed to lookup view reference for RSE Remote Systems View!", (Object)reference);
                    if (reference.getPage().getPartState((IWorkbenchPartReference)reference) == 1 && RSECoreTestCase.this.isProperty("org.eclipse.rse.tests.core.maximizeRemoteSystemsView", true)) {
                        reference.getPage().toggleZoom((IWorkbenchPartReference)reference);
                    } else if (reference.getPage().getPartState((IWorkbenchPartReference)reference) != 1 && RSECoreTestCase.this.isProperty("org.eclipse.rse.tests.core.maximizeRemoteSystemsView", false)) {
                        reference.getPage().toggleZoom((IWorkbenchPartReference)reference);
                    }
                    RSECoreTestCase.this.setProperty("rseSystemsViewZoomStateChanged", false);
                }
            });
        }
    }

    public final IViewReference findView(String viewId, String perspectiveId) {
        if (!($assertionsDisabled || viewId != null && perspectiveId != null)) {
            throw new AssertionError();
        }
        if (viewId == null || perspectiveId == null) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        RSECoreTestCase.assertNotNull((String)"Failed to query current workbench instance!", (Object)workbench);
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        RSECoreTestCase.assertNotNull((String)"Failed to query currently active workbench window!", (Object)window);
        try {
            workbench.showPerspective(perspectiveId, window);
        }
        catch (WorkbenchException e) {
            SystemBasePlugin.logError((String)("Failed to switch to requested perspective (id = " + perspectiveId + ")!"), (Throwable)e);
        }
        IWorkbenchPage page = window.getActivePage();
        RSECoreTestCase.assertNotNull((String)"Failed to query currently active workbench page!", (Object)page);
        return page.findViewReference(viewId);
    }

    public final IViewPart showView(String viewId, String perspectiveId) {
        if (!($assertionsDisabled || viewId != null && perspectiveId != null)) {
            throw new AssertionError();
        }
        if (viewId == null || perspectiveId == null) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        RSECoreTestCase.assertNotNull((String)"Failed to query current workbench instance!", (Object)workbench);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        RSECoreTestCase.assertNotNull((String)"Failed to query currently active workbench window!", (Object)window);
        try {
            workbench.showPerspective(perspectiveId, window);
        }
        catch (WorkbenchException e) {
            SystemBasePlugin.logError((String)("Failed to switch to requested perspective (id = " + perspectiveId + ")!"), (Throwable)e);
        }
        IWorkbenchPage page = window.getActivePage();
        RSECoreTestCase.assertNotNull((String)"Failed to query currently active workbench page!", (Object)page);
        IViewPart part = null;
        try {
            part = page.showView(viewId);
        }
        catch (PartInitException e) {
            SystemBasePlugin.logError((String)("Failed to show view (id = " + viewId + ")!"), (Throwable)e);
        }
        return part;
    }

    public final void hideView(String viewId, String perspectiveId) {
        if (!($assertionsDisabled || viewId != null && perspectiveId != null)) {
            throw new AssertionError();
        }
        if (viewId == null || perspectiveId == null) {
            return;
        }
        IViewReference viewReference = this.findView(viewId, perspectiveId);
        if (viewReference != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(viewReference);
            RSEWaitAndDispatchUtil.waitAndDispatch(1000L);
        }
    }

    protected final IPath getTestDataLocation(String relativePath, boolean appendHostOS) {
        Bundle bundle;
        if (!$assertionsDisabled && relativePath == null) {
            throw new AssertionError();
        }
        Path root = null;
        if (relativePath != null && (bundle = RSETestsPlugin.getDefault().getBundle()) != null) {
            URL url;
            IPath relative = new Path("test.data").append(relativePath);
            if (appendHostOS) {
                relative = relative.append(Platform.getOS());
            }
            if ((url = FileLocator.find((Bundle)bundle, (IPath)relative, null)) != null) {
                try {
                    root = new Path(FileLocator.resolve((URL)url).getFile());
                    if (!root.toFile().isDirectory() || !root.toFile().canRead()) {
                        root = null;
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return root;
    }

    protected final synchronized void collectTestLogs(Test test) {
        block39: {
            IPath stateLocation;
            IRSETestLogCollectorDelegate[] delegates;
            if (test != null && (delegates = RSETestsPlugin.getDefault().getTestLogCollectorDelegates()).length > 0 && (stateLocation = RSETestsPlugin.getDefault().getStateLocation()) != null && stateLocation.toFile().isDirectory()) {
                String archiveName = "RSEUnittestFailureLogs_" + test + ".zip";
                IPath archivePath = stateLocation.append(archiveName);
                if (archivePath.toFile().exists()) {
                    archivePath.toFile().delete();
                }
                ZipOutputStream stream = null;
                try {
                    try {
                        if (!archivePath.toFile().createNewFile()) break block39;
                        stream = new ZipOutputStream(new FileOutputStream(archivePath.toFile()));
                        stream.setLevel(9);
                        HashSet<String> nameCache = new HashSet<String>();
                        int i = 0;
                        while (i < delegates.length) {
                            IRSETestLogCollectorDelegate delegate = delegates[i];
                            IPath[] locations = delegate.getAbsoluteLogFileLocations();
                            if (locations != null && locations.length > 0) {
                                int j = 0;
                                while (j < locations.length) {
                                    block42: {
                                        IPath location = locations[j];
                                        if (location != null && location.isAbsolute() && location.toFile().isFile() && location.toFile().canRead()) {
                                            block44: {
                                                File file = location.toFile();
                                                String entryName = file.getName();
                                                if (nameCache.contains(entryName)) {
                                                    IPath unifier = location.removeLastSegments(1);
                                                    entryName = String.valueOf(unifier.lastSegment()) + "_" + entryName;
                                                    while (nameCache.contains(entryName) && !unifier.isEmpty()) {
                                                        unifier = location.removeLastSegments(1);
                                                        entryName = String.valueOf(unifier.lastSegment()) + "_" + entryName;
                                                    }
                                                    long count = 0L;
                                                    String base = new String(entryName.getBytes());
                                                    while (nameCache.contains(entryName)) {
                                                        entryName = String.valueOf(base) + " (" + count + ")";
                                                        ++count;
                                                    }
                                                } else {
                                                    nameCache.add(entryName);
                                                }
                                                ZipEntry zipEntry = new ZipEntry(entryName);
                                                zipEntry.setTime(file.lastModified());
                                                stream.putNextEntry(zipEntry);
                                                BufferedInputStream fileStream = null;
                                                try {
                                                    try {
                                                        fileStream = new BufferedInputStream(new FileInputStream(file));
                                                        int character = fileStream.read();
                                                        while (character >= 0) {
                                                            stream.write(character);
                                                            character = fileStream.read();
                                                        }
                                                    }
                                                    catch (IOException e) {
                                                        block41: {
                                                            if (Platform.inDebugMode()) {
                                                                e.printStackTrace();
                                                            }
                                                            try {
                                                                if (fileStream != null) {
                                                                    fileStream.close();
                                                                }
                                                            }
                                                            catch (IOException e2) {
                                                                if (!Platform.inDebugMode()) break block41;
                                                                e2.printStackTrace();
                                                            }
                                                        }
                                                        stream.closeEntry();
                                                        break block42;
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    block43: {
                                                        try {
                                                            if (fileStream != null) {
                                                                fileStream.close();
                                                            }
                                                        }
                                                        catch (IOException e) {
                                                            if (!Platform.inDebugMode()) break block43;
                                                            e.printStackTrace();
                                                        }
                                                    }
                                                    stream.closeEntry();
                                                    throw throwable;
                                                }
                                                try {
                                                    if (fileStream != null) {
                                                        fileStream.close();
                                                    }
                                                }
                                                catch (IOException e) {
                                                    if (!Platform.inDebugMode()) break block44;
                                                    e.printStackTrace();
                                                }
                                            }
                                            stream.closeEntry();
                                        }
                                    }
                                    ++j;
                                }
                            }
                            delegate.dispose();
                            ++i;
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException e) {
                            if (Platform.inDebugMode()) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                finally {
                    block45: {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException e) {
                            if (!Platform.inDebugMode()) break block45;
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private final class RSEBackgroundTestExecutionJob
    extends Job {
        private final TestResult result;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.tests.core.RSECoreTestCase");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public RSEBackgroundTestExecutionJob(TestResult result) {
            super("RSE JUnit Test Case Execution Job");
            this.setUser(false);
            this.setPriority(10);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            this.result = result;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Running test " + RSECoreTestCase.this.getName() + " ...", -1);
            this.result.addListener(RSECoreTestCase.this.TEST_LISTENER);
            RSECoreTestCase.this.invokeTestCaseRunImpl(this.result);
            this.result.removeListener(RSECoreTestCase.this.TEST_LISTENER);
            monitor.done();
            this.setProperty(BACKGROUND_TEST_EXECUTION_FINISHED, Boolean.TRUE);
            return Status.OK_STATUS;
        }
    }

    private static final class RSEBackgroundTestExecutionJobWaiter
    implements RSEWaitAndDispatchUtil.IInterruptCondition {
        private final Job job;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.tests.core.RSECoreTestCase");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public RSEBackgroundTestExecutionJobWaiter(Job job) {
            if (!$assertionsDisabled && job == null) {
                throw new AssertionError();
            }
            this.job = job;
        }

        public boolean isTrue() {
            return (Boolean)this.job.getProperty(BACKGROUND_TEST_EXECUTION_FINISHED);
        }

        public void dispose() {
        }
    }

    class RSETestFailureListener
    implements TestListener {
        RSETestFailureListener() {
        }

        public void startTest(Test test) {
        }

        public synchronized void addError(Test test, Throwable error) {
            if (test != null && error != null) {
                Status status = new Status(4, RSETestsPlugin.getDefault().getBundle().getSymbolicName(), 1, "RSE JUnit test case '" + test + "' failed with error. Possible cause: " + error.getLocalizedMessage(), error);
                RSETestsPlugin.getDefault().getLog().log((IStatus)status);
                RSECoreTestCase.this.collectTestLogs(test);
            }
        }

        public synchronized void addFailure(Test test, AssertionFailedError failure) {
            if (test != null && failure != null) {
                Status status = new Status(4, RSETestsPlugin.getDefault().getBundle().getSymbolicName(), 1, "RSE JUnit test case '" + test + "' failed. Failure: " + failure.getLocalizedMessage(), (Throwable)failure);
                RSETestsPlugin.getDefault().getLog().log((IStatus)status);
                RSECoreTestCase.this.collectTestLogs(test);
            }
        }

        public void endTest(Test test) {
        }
    }
}

