/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.util.ssl;

import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.eclipse.dstore.core.util.ssl.DStoreKeyStore;
import org.eclipse.dstore.core.util.ssl.IDataStoreTrustManager;

public class DStoreSSLContext {
    private static KeyManager[] _keyManager;

    public static void setKeyManager(KeyManager[] keyManager) {
        _keyManager = keyManager;
    }

    public static SSLContext getServerSSLContext(String filePath, String password) {
        SSLContext serverContext = null;
        try {
            if (_keyManager == null) {
                KeyStore ks = DStoreKeyStore.getKeyStore(filePath, password);
                String keymgrAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(keymgrAlgorithm);
                kmf.init(ks, password.toCharArray());
                serverContext = SSLContext.getInstance("SSL");
                serverContext.init(kmf.getKeyManagers(), null, null);
            } else {
                serverContext = SSLContext.getInstance("SSL");
                serverContext.init(_keyManager, null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverContext;
    }

    public static SSLContext getClientSSLContext(String filePath, String password, IDataStoreTrustManager trustManager) {
        SSLContext clientContext = null;
        try {
            trustManager.setKeystore(filePath, password);
            clientContext = SSLContext.getInstance("SSL");
            TrustManager[] mgrs = new TrustManager[]{trustManager};
            clientContext.init(_keyManager, mgrs, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clientContext;
    }
}

