/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.efs;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.internal.efs.Activator;
import org.eclipse.rse.internal.efs.Messages;
import org.eclipse.rse.internal.efs.RSEFileStore;
import org.eclipse.rse.services.clientserver.messages.SystemElementNotFoundException;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileContext;
import org.eclipse.rse.ui.RSEUIPlugin;

public class RSEFileStoreImpl
extends FileStore {
    private RSEFileStore _store;
    private volatile transient IRemoteFile _remoteFile;
    private static boolean _initialized;

    public RSEFileStoreImpl(RSEFileStore store) {
        this._store = store;
    }

    public IFileStore getChild(String name) {
        return this._store.getChild(name);
    }

    public String getName() {
        return this._store.getName();
    }

    public IFileStore getParent() {
        return this._store.getParent();
    }

    public URI toURI() {
        return this._store.toURI();
    }

    private static void waitForRSEInit() {
        if (!_initialized) {
            RSEUIPlugin.getDefault();
            Job[] jobs = Job.getJobManager().find(null);
            int i = 0;
            while (i < jobs.length) {
                if ("Initialize RSE".equals(jobs[i].getName())) {
                    try {
                        jobs[i].join();
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
                ++i;
            }
            _initialized = true;
        }
    }

    public static IHost getConnectionFor(String hostNameOrAddr, IProgressMonitor monitor) {
        if (hostNameOrAddr == null) {
            return null;
        }
        if (!_initialized) {
            RSEFileStoreImpl.waitForRSEInit();
        }
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IHost[] connections = sr.getHosts();
        IHost unconnected = null;
        int i = 0;
        while (i < connections.length) {
            IHost con = connections[i];
            if (hostNameOrAddr.equalsIgnoreCase(con.getHostName())) {
                IRemoteFileSubSystem fss = RSEFileStoreImpl.getRemoteFileSubSystem(con);
                if (fss != null && fss.isConnected()) {
                    return con;
                }
                unconnected = con;
            }
            ++i;
        }
        return unconnected;
    }

    public static IRemoteFileSubSystem getRemoteFileSubSystem(IHost host) {
        IRemoteFileSubSystem candidate = null;
        FileServiceSubSystem serviceCandidate = null;
        IRemoteFileSubSystem[] subSys = RemoteFileUtility.getFileSubSystems((IHost)host);
        int i = 0;
        while (i < subSys.length) {
            if (subSys[i] instanceof FileServiceSubSystem) {
                if (subSys[i].isConnected()) {
                    return subSys[i];
                }
                if (serviceCandidate == null) {
                    serviceCandidate = (FileServiceSubSystem)subSys[i];
                }
            } else if (candidate == null) {
                candidate = subSys[i];
            } else if (subSys[i].isConnected() && !candidate.isConnected()) {
                candidate = subSys[i];
            }
            ++i;
        }
        if (candidate != null && candidate.isConnected()) {
            return candidate;
        }
        if (serviceCandidate != null) {
            return serviceCandidate;
        }
        return candidate;
    }

    public static IRemoteFileSubSystem getConnectedFileSubSystem(String hostNameOrAddr, IProgressMonitor monitor) throws CoreException {
        IHost con = RSEFileStoreImpl.getConnectionFor(hostNameOrAddr, monitor);
        if (con == null) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), NLS.bind((String)Messages.CONNECTION_NOT_FOUND, (Object)hostNameOrAddr)));
        }
        IRemoteFileSubSystem subSys = RSEFileStoreImpl.getRemoteFileSubSystem(con);
        if (subSys == null) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), NLS.bind((String)Messages.NO_FILE_SUBSYSTEM, (Object)hostNameOrAddr, (Object)con.getAliasName())));
        }
        if (!subSys.isConnected()) {
            try {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                subSys.connect(monitor, false);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), NLS.bind((String)Messages.COULD_NOT_CONNECT, (Object)hostNameOrAddr, (Object)subSys.getConfigurationId()), (Throwable)e));
            }
        }
        return subSys;
    }

    private IRemoteFile getCachedRemoteFile() {
        return this._remoteFile;
    }

    private void cacheRemoteFile(IRemoteFile remoteFile) {
        if (this._remoteFile != null && this._remoteFile != remoteFile) {
            this._remoteFile.markStale(true);
        }
        this._remoteFile = remoteFile;
    }

    private IRemoteFile getRemoteFileObject(IProgressMonitor monitor, boolean forceExists) throws CoreException {
        RSEFileStore parentStore;
        IRemoteFile remoteFile = this.getCachedRemoteFile();
        if (remoteFile != null) {
            if (remoteFile.getParentRemoteFileSubSystem().isConnected()) {
                return remoteFile;
            }
            remoteFile = null;
            this.cacheRemoteFile(null);
        }
        if ((parentStore = this._store.getParentStore()) != null) {
            IRemoteFile parent = parentStore.getImpl().getRemoteFileObject(monitor, forceExists);
            if (parent == null) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), Messages.COULD_NOT_GET_REMOTE_FILE));
            }
            try {
                remoteFile = parent.getParentRemoteFileSubSystem().getRemoteFileObject(parent, this.getName(), monitor);
            }
            catch (SystemMessageException e) {
                this.rethrowCoreException((Exception)((Object)e), 271);
            }
        } else {
            IRemoteFileSubSystem subSys = RSEFileStoreImpl.getConnectedFileSubSystem(this._store.getHost(), monitor);
            try {
                remoteFile = subSys.getRemoteFileObject(this._store.getAbsolutePath(), monitor);
            }
            catch (SystemMessageException e) {
                this.rethrowCoreException((Exception)((Object)e), 271);
            }
        }
        this.cacheRemoteFile(remoteFile);
        if (forceExists && (remoteFile == null || !remoteFile.exists())) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 270, Messages.FILE_STORE_DOES_NOT_EXIST, null));
        }
        return remoteFile;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        String[] names;
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, true);
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        if (!remoteFile.isStale() && remoteFile.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance()) && !(subSys instanceof IFileServiceSubSystem)) {
            Object[] children = remoteFile.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance());
            names = new String[children.length];
            int i = 0;
            while (i < children.length) {
                names[i] = ((IRemoteFile)children[i]).getName();
                ++i;
            }
        } else {
            try {
                IRemoteFile[] children = null;
                if (subSys instanceof FileServiceSubSystem) {
                    FileServiceSubSystem fileServiceSubSystem = (FileServiceSubSystem)subSys;
                    IHostFile[] results = fileServiceSubSystem.getFileService().list(remoteFile.getAbsolutePath(), "*", 0, monitor);
                    IRemoteFileSubSystemConfiguration config = subSys.getParentRemoteFileSubSystemConfiguration();
                    RemoteFileFilterString filterString = new RemoteFileFilterString(config, remoteFile.getAbsolutePath(), "*");
                    filterString.setShowFiles(true);
                    filterString.setShowSubDirs(true);
                    RemoteFileContext context = new RemoteFileContext(subSys, remoteFile, filterString);
                    children = fileServiceSubSystem.getHostFileToRemoteFileAdapter().convertToRemoteFiles(fileServiceSubSystem, (IRemoteFileContext)context, remoteFile, results);
                } else {
                    children = subSys.list(remoteFile, monitor);
                }
                names = new String[children.length];
                int i = 0;
                while (i < children.length) {
                    names[i] = children[i].getName();
                    ++i;
                }
            }
            catch (SystemMessageException systemMessageException) {
                names = new String[]{};
            }
        }
        return names;
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        FileInfo[] infos;
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, true);
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        if (!remoteFile.isStale() && remoteFile.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance()) && !(subSys instanceof IFileServiceSubSystem)) {
            Object[] children = remoteFile.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance());
            infos = new FileInfo[children.length];
            int i = 0;
            while (i < children.length) {
                IRemoteFile file = (IRemoteFile)children[i];
                FileInfo info = new FileInfo(file.getName());
                if (!file.exists()) {
                    info.setExists(false);
                } else {
                    info.setExists(true);
                    info.setLastModified(file.getLastModified());
                    boolean isDir = file.isDirectory();
                    info.setDirectory(isDir);
                    info.setAttribute(2, !file.canWrite());
                    info.setAttribute(4, file.isExecutable());
                    info.setAttribute(8, file.isArchive());
                    info.setAttribute(16, file.isHidden());
                    if (!isDir) {
                        info.setLength(file.getLength());
                    }
                }
                infos[i] = info;
                ++i;
            }
        } else {
            try {
                IRemoteFile[] children = null;
                if (subSys instanceof FileServiceSubSystem) {
                    FileServiceSubSystem fileServiceSubSystem = (FileServiceSubSystem)subSys;
                    IHostFile[] results = fileServiceSubSystem.getFileService().list(remoteFile.getAbsolutePath(), "*", 0, monitor);
                    IRemoteFileSubSystemConfiguration config = subSys.getParentRemoteFileSubSystemConfiguration();
                    RemoteFileFilterString filterString = new RemoteFileFilterString(config, remoteFile.getAbsolutePath(), "*");
                    filterString.setShowFiles(true);
                    filterString.setShowSubDirs(true);
                    RemoteFileContext context = new RemoteFileContext(subSys, remoteFile, filterString);
                    children = fileServiceSubSystem.getHostFileToRemoteFileAdapter().convertToRemoteFiles(fileServiceSubSystem, (IRemoteFileContext)context, remoteFile, results);
                } else {
                    children = subSys.list(remoteFile, monitor);
                }
                infos = new FileInfo[children.length];
                int i = 0;
                while (i < children.length) {
                    IRemoteFile file = children[i];
                    FileInfo info = new FileInfo(file.getName());
                    if (!file.exists()) {
                        info.setExists(false);
                    } else {
                        info.setExists(true);
                        info.setLastModified(file.getLastModified());
                        boolean isDir = file.isDirectory();
                        info.setDirectory(isDir);
                        info.setAttribute(2, !file.canWrite());
                        info.setAttribute(4, file.isExecutable());
                        info.setAttribute(8, file.isArchive());
                        info.setAttribute(16, file.isHidden());
                        if (!isDir) {
                            info.setLength(file.getLength());
                        }
                    }
                    infos[i] = info;
                    ++i;
                }
            }
            catch (SystemMessageException systemMessageException) {
                infos = new FileInfo[]{};
            }
        }
        return infos;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        this.cacheRemoteFile(null);
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, false);
        String classification = remoteFile == null ? null : remoteFile.getClassification();
        FileInfo info = new FileInfo(this._store.getName());
        if (remoteFile == null || !remoteFile.exists()) {
            info.setExists(false);
            if (classification != null && classification.startsWith("broken symbolic link")) {
                int i2;
                info.setAttribute(32, true);
                int i1 = classification.indexOf(39);
                if (i1 > 0 && (i2 = classification.indexOf(65533)) > i1) {
                    info.setStringAttribute(64, classification.substring(i1 + 1, i2));
                }
            }
            return info;
        }
        info.setExists(true);
        info.setLastModified(remoteFile.getLastModified());
        boolean isDir = remoteFile.isDirectory();
        info.setDirectory(isDir);
        info.setAttribute(2, !remoteFile.canWrite());
        info.setAttribute(4, remoteFile.isExecutable());
        info.setAttribute(8, remoteFile.isArchive());
        info.setAttribute(16, remoteFile.isHidden());
        if (classification != null && classification.startsWith("symbolic link")) {
            info.setAttribute(32, true);
            int idx = classification.indexOf(58);
            if (idx > 0) {
                info.setStringAttribute(64, classification.substring(idx + 1));
            }
        }
        if (!isDir) {
            info.setLength(remoteFile.getLength());
        }
        return info;
    }

    private String getExceptionMessage(String item, Throwable e) {
        String exceptionText = e != null ? (e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getClass().getName()) : Messages.UNKNOWN_EXCEPTION;
        if (item != null && item.length() > 0) {
            return String.valueOf(exceptionText) + ": " + item;
        }
        return exceptionText;
    }

    private void rethrowCoreException(Exception e, int codeHint) throws CoreException {
        String pluginId = Activator.getDefault().getBundle().getSymbolicName();
        String msg = this.getExceptionMessage(this.toString(), e);
        int code = codeHint;
        if (e instanceof SystemElementNotFoundException) {
            code = 269;
        }
        throw new CoreException((IStatus)new Status(4, pluginId, code, msg, (Throwable)e));
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, false);
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        try {
            if ((options & 0x400) != 0) {
                subSys.setReadOnly(remoteFile, info.getAttribute(2), monitor);
            }
            if ((options & 0x800) != 0) {
                subSys.setLastModified(remoteFile, info.getLastModified(), monitor);
            }
        }
        catch (Exception e) {
            this.rethrowCoreException(e, 272);
        }
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, true);
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        if (remoteFile.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 276, Messages.CANNOT_OPEN_STREAM_ON_FOLDER, null));
        }
        if (remoteFile.isFile()) {
            try {
                return subSys.getInputStream(remoteFile.getParentPath(), remoteFile.getName(), true, monitor);
            }
            catch (SystemMessageException e) {
                this.cacheRemoteFile(null);
                this.rethrowCoreException((Exception)((Object)e), 271);
            }
        }
        throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 271, String.valueOf(Messages.FILE_STORE_DOES_NOT_EXIST) + ": " + this.toString(), null));
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        this.cacheRemoteFile(null);
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, false);
        if (remoteFile == null) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 269, Messages.COULD_NOT_GET_REMOTE_FILE, null));
        }
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        if (!remoteFile.exists()) {
            try {
                if ((options & 4) != 0) {
                    if (!remoteFile.getParentRemoteFile().exists()) {
                        throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 272, Messages.FILE_STORE_DOES_NOT_EXIST, null));
                    }
                    remoteFile = subSys.createFolder(remoteFile, monitor);
                } else {
                    remoteFile = subSys.createFolders(remoteFile, monitor);
                }
                this.cacheRemoteFile(remoteFile);
            }
            catch (SystemMessageException e) {
                this.rethrowCoreException((Exception)((Object)e), 272);
            }
            return this._store;
        }
        if (remoteFile.isFile()) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 276, Messages.FILE_NAME_EXISTS, null));
        }
        return this._store;
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        this.cacheRemoteFile(null);
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, false);
        if (remoteFile == null) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), Messages.COULD_NOT_GET_REMOTE_FILE));
        }
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        if (!remoteFile.exists()) {
            try {
                remoteFile = subSys.createFile(remoteFile, monitor);
                this.cacheRemoteFile(remoteFile);
            }
            catch (SystemMessageException e) {
                this.rethrowCoreException((Exception)((Object)e), 272);
            }
        }
        if (remoteFile.isFile()) {
            try {
                options = (options & 1) != 0 ? 1 : 0;
                return subSys.getOutputStream(remoteFile.getParentPath(), remoteFile.getName(), options, monitor);
            }
            catch (SystemMessageException e) {
                this.rethrowCoreException((Exception)((Object)e), 272);
            }
        } else if (remoteFile.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 276, Messages.CANNOT_OPEN_STREAM_ON_FOLDER, null));
        }
        return null;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, false);
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        try {
            this.cacheRemoteFile(null);
            subSys.delete(remoteFile, monitor);
        }
        catch (SystemElementNotFoundException systemElementNotFoundException) {
        }
        catch (SystemMessageException e) {
            this.rethrowCoreException((Exception)((Object)e), 273);
        }
    }
}

