/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.filters.dialogs;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.filters.dialogs.SystemFilterNewFilterPoolWizard;
import org.eclipse.rse.internal.ui.filters.dialogs.SystemFilterNewFilterPoolWizardMainPageInterface;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.filters.SystemFilterPoolDialogOutputs;
import org.eclipse.rse.ui.filters.actions.SystemFilterAbstractFilterPoolAction;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFilterPoolName;
import org.eclipse.rse.ui.wizards.AbstractSystemWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SystemFilterNewFilterPoolWizardDefaultMainPage
extends AbstractSystemWizardPage
implements SystemFilterNewFilterPoolWizardMainPageInterface,
Listener,
SelectionListener {
    protected Label labelName;
    protected Label labelMgr;
    protected Text textName;
    protected Combo mgrCombo;
    protected int mgrSelection = 0;
    protected String[] mgrNames = null;
    protected ISystemValidator[] validatorsByManager = null;
    protected SystemFilterAbstractFilterPoolAction parentWizardAction = null;

    public SystemFilterNewFilterPoolWizardDefaultMainPage(Wizard wizard, String title, String description) {
        super((IWizard)wizard, "NewFilterPool", title, description);
        this.parentWizardAction = ((SystemFilterNewFilterPoolWizard)wizard).getFilterPoolDialogActionCaller();
    }

    public void setNameValidator(ISystemValidator v) {
        this.validatorsByManager = new ISystemValidator[1];
        this.validatorsByManager[0] = v;
    }

    public void setNameValidators(ISystemValidator[] v) {
        this.validatorsByManager = v;
    }

    public void setFilterPoolManagers(ISystemFilterPoolManager[] mgrs) {
        this.mgrNames = new String[mgrs.length];
        this.validatorsByManager = new ISystemValidator[this.mgrNames.length];
        int idx = 0;
        while (idx < mgrs.length) {
            ISystemFilterPoolManager manager = mgrs[idx];
            this.mgrNames[idx] = manager.getName();
            ValidatorFilterPoolName iiv = new ValidatorFilterPoolName(manager.getSystemFilterPoolNames());
            this.validatorsByManager[idx] = iiv;
            ++idx;
        }
    }

    protected String[] getFilterPoolManagerNames() {
        return this.mgrNames;
    }

    public void setFilterPoolManagerNameSelectionIndex(int index) {
        this.mgrSelection = index;
    }

    protected int getFilterPoolManagerNameSelectionIndex() {
        return this.mgrSelection;
    }

    protected String getPoolNamePromptText() {
        String namePromptText = this.parentWizardAction.getDialogFilterPoolNamePrompt();
        return namePromptText == null ? SystemResources.RESID_FILTERPOOLNAME_LABEL : namePromptText;
    }

    protected String getPoolNameToolTip() {
        String nameTip = this.parentWizardAction.getDialogFilterPoolNameTip();
        return nameTip == null ? SystemResources.RESID_FILTERPOOLNAME_TIP : nameTip;
    }

    protected String getPoolManagerPromptText() {
        String mgrPromptText = this.parentWizardAction.getDialogFilterPoolManagerNamePrompt();
        return mgrPromptText == null ? SystemResources.RESID_FILTERPOOLMANAGERNAME_LABEL : mgrPromptText;
    }

    protected String getPoolManagerToolTip() {
        String mgrTip = this.parentWizardAction.getDialogFilterPoolManagerNameTip();
        return mgrTip == null ? SystemResources.RESID_FILTERPOOLMANAGERNAME_TIP : mgrTip;
    }

    public Control createContents(Composite parent) {
        String[] mgrs;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        Composite composite_prompts = SystemWidgetHelpers.createComposite(composite, 2);
        this.labelName = SystemWidgetHelpers.createLabel(composite_prompts, this.getPoolNamePromptText());
        this.textName = SystemWidgetHelpers.createTextField(composite_prompts, this);
        String tip = this.getPoolNameToolTip();
        if (tip != null) {
            this.textName.setToolTipText(tip);
        }
        if ((mgrs = this.getFilterPoolManagerNames()) != null) {
            this.labelMgr = SystemWidgetHelpers.createLabel(composite_prompts, this.getPoolManagerPromptText());
            this.mgrCombo = SystemWidgetHelpers.createReadonlyCombo(composite_prompts, this);
            tip = this.getPoolManagerToolTip();
            if (tip != null) {
                this.mgrCombo.setToolTipText(tip);
            }
            this.mgrCombo.setItems(mgrs);
            this.mgrCombo.select(this.mgrSelection);
            this.setPoolNameTextLimit(this.mgrSelection);
        }
        this.textName.setFocus();
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemFilterNewFilterPoolWizardDefaultMainPage.this.validateNameInput();
            }
        });
        if (this.mgrCombo != null) {
            this.mgrCombo.addSelectionListener((SelectionListener)this);
        }
        this.setPageComplete(false);
        return composite;
    }

    public Control getInitialFocusControl() {
        return this.textName;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        Object src = event.getSource();
        if (src == this.mgrCombo) {
            this.setPoolNameTextLimit(this.mgrCombo.getSelectionIndex());
        }
    }

    public void handleEvent(Event e) {
    }

    public boolean performFinish() {
        SystemMessage errMsg = null;
        Text controlInError = null;
        this.clearErrorMessage();
        errMsg = this.validateNameInput();
        if (errMsg != null) {
            controlInError = this.textName;
        }
        if (errMsg != null && controlInError != null) {
            controlInError.setFocus();
        }
        return errMsg == null;
    }

    protected SystemMessage validateNameInput() {
        int mgrIndex = 0;
        if (this.mgrCombo != null) {
            mgrIndex = this.mgrCombo.getSelectionIndex();
        }
        if (mgrIndex < 0) {
            mgrIndex = 0;
        }
        ISystemValidator iiv = this.validatorsByManager[mgrIndex];
        SystemMessage errorMessage = null;
        if (iiv != null) {
            errorMessage = iiv.validate(this.textName.getText());
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        } else {
            this.clearErrorMessage();
        }
        this.setPageComplete(errorMessage == null);
        return errorMessage;
    }

    protected void setPoolNameTextLimit(int mgrIndex) {
        if (mgrIndex < 0) {
            return;
        }
        ISystemValidator iiv = this.validatorsByManager[mgrIndex];
        if (iiv != null) {
            int limit = -1;
            limit = iiv.getMaximumNameLength();
            if (limit == -1) {
                limit = 50;
            }
            this.textName.setTextLimit(limit);
        }
    }

    public String getPoolName() {
        return this.textName.getText().trim();
    }

    public String getPoolManagerName() {
        if (this.mgrCombo != null) {
            return this.mgrCombo.getText();
        }
        return null;
    }

    public SystemFilterPoolDialogOutputs getFilterPoolDialogOutputs() {
        SystemFilterPoolDialogOutputs output = new SystemFilterPoolDialogOutputs();
        output.filterPoolName = this.getPoolName();
        output.filterPoolManagerName = this.getPoolManagerName();
        return output;
    }
}

