/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.dialogs;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.dialogs.SystemDeleteTableProvider;
import org.eclipse.rse.internal.ui.dialogs.SystemDeleteTableRow;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SystemDeleteDialog
extends SystemPromptDialog
implements ISelectionChangedListener {
    private String warningMessage;
    private String warningTip;
    private String promptLabel;
    private SystemDeleteTableProvider sdtp;
    private Table table;
    private TableViewer tableViewer;
    private GridData tableData;
    private String[] columnHeaders = new String[]{"", SystemResources.RESID_DELETE_COLHDG_OLDNAME, SystemResources.RESID_DELETE_COLHDG_TYPE};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(19, false), new ColumnWeightData(150, 150, true), new ColumnWeightData(120, 120, true)};
    private static String[] tableColumnProperties = new String[]{"org.eclipse.rse.ui.ok", "org.eclipse.jface.text", "org.eclipse.rse.ui.type"};

    public SystemDeleteDialog(Shell shell) {
        super(shell, SystemResources.RESID_DELETE_TITLE);
        super.setOkButtonLabel(SystemResources.RESID_DELETE_BUTTON);
        this.setHelp("org.eclipse.rse.ui.ddlt0000");
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        super.createMessageLine(c);
        return this.fMessageLine;
    }

    public void setWarningMessage(String msg, String tip) {
        this.warningMessage = msg;
        this.warningTip = tip;
    }

    public void setPromptLabel(String text) {
        this.promptLabel = text;
    }

    protected Control getInitialFocusControl() {
        return this.tableViewer.getControl();
    }

    protected Control createInner(Composite parent) {
        int height;
        int nbrColumns = 2;
        Composite composite = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        if (this.promptLabel == null) {
            Object input = this.getInputObject();
            if (input instanceof IStructuredSelection) {
                int size = ((IStructuredSelection)input).size();
                if (size > 1) {
                    SystemWidgetHelpers.createLabel(composite, SystemResources.RESID_DELETE_PROMPT, nbrColumns);
                } else {
                    SystemWidgetHelpers.createLabel(composite, SystemResources.RESID_DELETE_PROMPT_SINGLE, nbrColumns);
                }
            } else {
                SystemWidgetHelpers.createLabel(composite, SystemResources.RESID_DELETE_PROMPT, nbrColumns);
            }
        } else {
            SystemWidgetHelpers.createVerbiage(composite, this.promptLabel, nbrColumns, false, 200);
        }
        if (this.warningMessage != null) {
            SystemWidgetHelpers.createLabel(composite, "", nbrColumns);
            Image image = this.getShell().getDisplay().getSystemImage(8);
            Label imageLabel = null;
            if (image != null) {
                imageLabel = new Label(composite, 0);
                image.setBackground(imageLabel.getBackground());
                imageLabel.setImage(image);
                imageLabel.setLayoutData((Object)new GridData(66));
            }
            Label warningLabel = SystemWidgetHelpers.createLabel(composite, this.warningMessage);
            if (this.warningTip != null) {
                warningLabel.setToolTipText(this.warningTip);
                if (imageLabel != null) {
                    imageLabel.setToolTipText(this.warningTip);
                }
            }
            SystemWidgetHelpers.createLabel(composite, "", nbrColumns);
        }
        this.tableViewer = this.createTableViewer(composite, nbrColumns);
        this.createColumns();
        this.tableViewer.setColumnProperties(tableColumnProperties);
        this.sdtp = new SystemDeleteTableProvider();
        int width = this.tableData.widthHint;
        int nbrRows = Math.min(this.getRows().length, 8);
        int rowHeight = this.table.getItemHeight() + this.table.getGridLineWidth();
        int sbHeight = this.table.getHorizontalBar().getSize().y;
        this.tableData.heightHint = height = nbrRows * rowHeight + sbHeight;
        this.table.setLayoutData((Object)this.tableData);
        this.table.setSize(width, height);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.sdtp);
        this.tableViewer.setContentProvider((IContentProvider)this.sdtp);
        Object input = this.getInputObject();
        this.tableViewer.setInput(input);
        return composite;
    }

    private TableViewer createTableViewer(Composite parent, int nbrColumns) {
        this.table = new Table(parent, 35584);
        this.table.setLinesVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableData = new GridData();
        this.tableData.horizontalAlignment = 4;
        this.tableData.grabExcessHorizontalSpace = true;
        this.tableData.widthHint = 350;
        this.tableData.heightHint = 30;
        this.tableData.verticalAlignment = 2;
        this.tableData.grabExcessVerticalSpace = true;
        this.tableData.horizontalSpan = nbrColumns;
        this.table.setLayoutData((Object)this.tableData);
        return this.tableViewer;
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        int i = 0;
        while (i < this.columnHeaders.length) {
            layout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void setInputObject(Object inputObject) {
        super.setInputObject(inputObject);
    }

    protected boolean processOK() {
        return true;
    }

    public SystemDeleteTableRow[] getRows() {
        return (SystemDeleteTableRow[])this.sdtp.getElements(this.getInputObject());
    }

    protected ISystemViewElementAdapter getViewAdapter(Object o) {
        return SystemAdapterHelpers.getViewAdapter(o);
    }
}

