/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.subsystems;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISubSystemConfigurator;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.internal.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.util.ValidatorFileFilterString;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFileName;
import org.eclipse.rse.ui.validators.ValidatorFolderName;
import org.eclipse.rse.ui.validators.ValidatorPathName;

public abstract class RemoteFileSubSystemConfiguration
extends SubSystemConfiguration
implements IRemoteFileSubSystemConfiguration {
    protected boolean unixStyle = false;
    protected String translatedType;
    static /* synthetic */ Class class$0;

    protected void setIsUnixStyle(boolean isUnixStyle) {
        this.unixStyle = isUnixStyle;
    }

    public boolean isUnixStyle() {
        return this.unixStyle;
    }

    public boolean isCaseSensitive() {
        return this.isUnixStyle();
    }

    public boolean supportsTargets() {
        return true;
    }

    public boolean supportsEnvironmentVariablesPropertyPage() {
        return true;
    }

    public boolean supportsSearch() {
        return true;
    }

    public ISystemValidator getPathValidator() {
        return new ValidatorPathName();
    }

    public ISystemValidator getFileFilterStringValidator() {
        return new ValidatorFileFilterString(this);
    }

    public ValidatorFileName getFileNameValidator() {
        return new ValidatorFileName();
    }

    public ValidatorFolderName getFolderNameValidator() {
        return new ValidatorFolderName();
    }

    public String getSeparator() {
        return this.unixStyle ? "/" : "\\";
    }

    public char getSeparatorChar() {
        return this.unixStyle ? (char)'/' : '\\';
    }

    public String getPathSeparator() {
        return this.unixStyle ? ":" : ";";
    }

    public char getPathSeparatorChar() {
        return this.unixStyle ? (char)':' : ';';
    }

    public String getLineSeparator() {
        if (this.isUnixStyle()) {
            return "\n";
        }
        return "\r\n";
    }

    public boolean supportsDropInFilters() {
        return true;
    }

    public boolean providesCustomDropInFilters() {
        return true;
    }

    public boolean supportsFileTypes() {
        return true;
    }

    public void renameSubSystemProfile(String oldProfileName, String newProfileName) {
        IFolder folder;
        super.renameSubSystemProfile(oldProfileName, newProfileName);
        IProject project = SystemBasePlugin.getWorkspaceRoot().getProject("RemoteSystemsTempFiles");
        if (project != null && (folder = project.getFolder(oldProfileName)) != null && folder.exists()) {
            this.recursivelyUpdateIFileProperties(newProfileName, folder);
        }
    }

    protected void recursivelyUpdateIFileProperties(String newName, IFolder container) {
        try {
            IResource[] resources = container.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
                    String absoluteSubSystemName = properties.getRemoteFileSubSystem();
                    if (absoluteSubSystemName != null) {
                        int profileDelim = absoluteSubSystemName.indexOf(".");
                        String theRest = absoluteSubSystemName.substring(profileDelim, absoluteSubSystemName.length());
                        properties.setRemoteFileSubSystem(String.valueOf(newName) + theRest);
                    }
                } else if (resource instanceof IFolder) {
                    this.recursivelyUpdateIFileProperties(newName, (IFolder)resource);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    protected ISystemFilterPool createDefaultFilterPool(ISystemFilterPoolManager mgr) {
        ISystemFilterPool pool = null;
        try {
            String poolName = RemoteFileSubSystemConfiguration.getDefaultFilterPoolName((String)mgr.getName(), (String)this.getId());
            pool = mgr.createSystemFilterPool(poolName, true);
            if (pool != null && this.isUserPrivateProfile(mgr)) {
                RemoteFileFilterString myHomeFilterString = new RemoteFileFilterString(this);
                myHomeFilterString.setPath(this.getSeparator());
                String[] filterStrings = new String[]{"./*"};
                ISystemFilter filter = mgr.createSystemFilter((ISystemFilterContainer)pool, SystemFileResources.RESID_FILTER_MYHOME, filterStrings);
                filter.setNonChangable(true);
                filter.setSingleFilterStringOnly(true);
                RemoteFileFilterString rootFilesFilterString = new RemoteFileFilterString(this);
                rootFilesFilterString.setPath(this.getSeparator());
                filterStrings = new String[]{rootFilesFilterString.toString()};
                mgr.createSystemFilter((ISystemFilterContainer)pool, SystemFileResources.RESID_FILTER_ROOTFILES, filterStrings);
            } else {
                RemoteFileFilterString rootFilesFilterString = new RemoteFileFilterString(this);
                rootFilesFilterString.setPath(this.getSeparator());
                String[] filterStrings = new String[]{rootFilesFilterString.toString()};
                mgr.createSystemFilter((ISystemFilterContainer)pool, SystemFileResources.RESID_FILTER_ROOTFILES, filterStrings);
            }
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"Error creating default filter pool", (Throwable)exc);
        }
        return pool;
    }

    public String getTranslatedFilterTypeProperty(ISystemFilter selectedFilter) {
        if (this.translatedType == null) {
            this.translatedType = SystemFileResources.RESID_PROPERTY_FILE_FILTER_VALUE;
        }
        return this.translatedType;
    }

    public ISubSystem createSubSystemInternal(IHost conn) {
        return null;
    }

    protected void initializeSubSystem(ISubSystem ss, ISubSystemConfigurator[] configurators) {
        super.initializeSubSystem(ss, configurators);
    }

    public String getEditorProfileID() {
        return "universal";
    }

    public boolean isFactoryFor(Class subSystemType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean isFor = clazz.equals(subSystemType);
        return isFor;
    }
}

