/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.editors.FoldingSupport;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.HeuristicalIntervalDetector;

public final class TTCN3FoldingSupport
extends FoldingSupport {
    @Override
    public List<Position> calculatePositions(IDocument document) {
        this.positions.clear();
        this.lastLineIndex = document.getNumberOfLines();
        this.documentText = document.get();
        this.preferencesService = Platform.getPreferencesService();
        this.foldingDistance = this.preferencesService.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.distance", 0, null);
        if (this.preferencesService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.foldingEnabledPreference", true, null)) {
            Interval interval = GlobalIntervalHandler.getInterval(document);
            if (interval == null) {
                interval = new HeuristicalIntervalDetector().buildIntervals(document);
                GlobalIntervalHandler.putInterval(document, interval);
            }
            for (Interval subintervall : interval.getSubIntervals()) {
                this.recursiveTokens(subintervall);
            }
        }
        return this.positions;
    }
}

