/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigFoldingSupport;
import org.eclipse.titan.designer.editors.configeditor.ConfigTextEditor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectConfigurationParser;

public final class ReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    public static final String OUTLINEUPDATE = "Outline update";
    private ConfigTextEditor editor;
    private IDocument document;

    public ConfigTextEditor getEditor() {
        return this.editor;
    }

    public void setEditor(ConfigTextEditor editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void initialReconcile() {
        GlobalIntervalHandler.putInterval(this.document, null);
        IPreferencesService prefs = Platform.getPreferencesService();
        if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
            this.analyze();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    List<Position> positions = new ConfigFoldingSupport().calculatePositions(ReconcilingStrategy.this.document);
                    ReconcilingStrategy.this.editor.updateFoldingStructure(positions);
                }
            });
        }
    }

    void analyze() {
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            return;
        }
        IProject project = file.getProject();
        if (project == null) {
            return;
        }
        ProjectConfigurationParser projectConfigurationParser = GlobalParser.getConfigSourceParser(project);
        projectConfigurationParser.reportOutdating(file);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }
}

