/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.asn1editor.ASN1CodeSkeletons;
import org.eclipse.titan.designer.editors.asn1editor.ASN1ReferenceParser;
import org.eclipse.titan.designer.editors.asn1editor.CodeScanner;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public final class ContentAssistProcessor
implements IContentAssistProcessor {
    private static final String KEYWORD = "keyword";
    private final AbstractDecoratedTextEditor editor;

    public ContentAssistProcessor(AbstractDecoratedTextEditor editor) {
        this.editor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        ASN1ReferenceParser refParser = new ASN1ReferenceParser();
        Reference ref = refParser.findReferenceForCompletion(file, offset, doc);
        IPreferencesService prefs = Platform.getPreferencesService();
        if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            TITANDebugConsole.println("parsed the reference: " + ref);
        }
        if (ref == null || ref.getSubreferences().isEmpty()) {
            return new ICompletionProposal[0];
        }
        Scope scope = null;
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module tempModule = projectSourceParser.containedModule(file);
        if (tempModule != null) {
            scope = tempModule.getSmallestEnclosingScope(refParser.getReplacementOffset());
            ref.setMyScope(scope);
            ref.detectModid();
        }
        TemplateContextType contextType = new TemplateContextType("ASN1_SOURCE_CODE", "ASN1 Code Skeleton Context");
        ProposalCollector propCollector = new ProposalCollector(Identifier.Identifier_type.ID_ASN, "ASN1_SOURCE_CODE", contextType, doc, ref, refParser.getReplacementOffset());
        if (scope != null) {
            scope.addProposal(propCollector);
            propCollector.sortTillMarked();
            propCollector.markPosition();
        }
        if (ref.getSubreferences().size() != 1) {
            return propCollector.getCompletitions();
        }
        if (scope == null) {
            propCollector.addProposal(CodeScanner.TAGS, null, KEYWORD);
        } else {
            ASN1CodeSkeletons.addSkeletonProposals(doc, refParser.getReplacementOffset(), propCollector);
        }
        propCollector.sortTillMarked();
        propCollector.markPosition();
        propCollector.addProposal(CodeScanner.VERBS, null, KEYWORD);
        propCollector.addProposal(CodeScanner.COMPARE_TYPES, null, KEYWORD);
        propCollector.addProposal(CodeScanner.STATUS_TYPE, null, KEYWORD);
        propCollector.addProposal(CodeScanner.KEYWORDS, null, KEYWORD);
        propCollector.addProposal(CodeScanner.STORAGE, null, KEYWORD);
        propCollector.addProposal(CodeScanner.MODIFIER, null, KEYWORD);
        propCollector.addProposal(CodeScanner.ACCESS_TYPE, null, KEYWORD);
        propCollector.sortTillMarked();
        String sortingpolicy = Activator.getDefault().getPreferenceStore().getString("org.eclipse.titan.designer.proposalSorting");
        if ("alphabetically".equals(sortingpolicy)) {
            propCollector.sortAll();
        }
        return propCollector.getCompletitions();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new ContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

