/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.util.stream.LongStream;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableLongListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableLongArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableLongEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableLongSingletonList;

public enum ImmutableLongListFactoryImpl implements ImmutableLongListFactory
{
    INSTANCE;


    @Override
    public ImmutableLongList empty() {
        return ImmutableLongEmptyList.INSTANCE;
    }

    @Override
    public ImmutableLongList of() {
        return this.empty();
    }

    @Override
    public ImmutableLongList with() {
        return this.empty();
    }

    @Override
    public ImmutableLongList of(long one) {
        return this.with(one);
    }

    @Override
    public ImmutableLongList with(long one) {
        return new ImmutableLongSingletonList(one);
    }

    @Override
    public ImmutableLongList of(long ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableLongList with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableLongArrayList.newListWith(items);
    }

    @Override
    public ImmutableLongList ofAll(LongIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableLongList withAll(LongIterable items) {
        if (items instanceof ImmutableLongList) {
            return (ImmutableLongList)items;
        }
        if (items == null || items.size() == 0) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray()[0]);
        }
        return ImmutableLongArrayList.newList(items);
    }

    @Override
    public ImmutableLongList ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableLongList withAll(Iterable<Long> iterable) {
        return LongLists.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableLongList ofAll(LongStream items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableLongList withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

