/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.preferences.pages.ComboFieldEditor;
import org.eclipse.titan.designer.preferences.pages.FileListEditor;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class CodeSplittingTab {
    private static final String INVALID_CODESPLITTING_NUMBER = "Invalid code splitting number in Code Splitting tab: ";
    private static final String INVALID_CODESPLITTING_VALUE = "Invalid code splitting value in Code Splitting tab: ";
    private static final String CODE_SPLITTING_TAB_TEXT = "Code Splitting (-U)";
    private static final String CODE_SPLITTING_TAB_TOOLTIP = "Settings controlling the code splitting option";
    private static final String ENABLE_SELECTIVE_CODE_SPLITTING_TEXT = "Enable selective code splitting";
    private static final String ENABLE_SELECTIVE_CODE_SPLITTING_TOOLTIP = "Without selective code splitting, all relevant files will be splitted in the project";
    private boolean makeFileGenerationEnabled = true;
    private Composite codeSplittingTabComposite;
    private Composite codeSplittingComposite;
    private ComboFieldEditor codeSplitting;
    private Composite codeSplittingNumberComposite;
    private IntegerFieldEditor codeSplittingNumber;
    private Button enableSelectiveCodeSplitting;
    private Composite codeSplittingFileListComposite;
    private FileListEditor editor;
    private TabItem codeSplittingTabItem;
    private final IProject project;
    private final PropertyPage page;

    public CodeSplittingTab(IProject project, PropertyPage page) {
        this.project = project;
        this.page = page;
    }

    public void dispose() {
        this.codeSplittingComposite.dispose();
        this.codeSplitting.dispose();
        this.codeSplittingNumberComposite.dispose();
        this.codeSplittingNumber.dispose();
        this.enableSelectiveCodeSplitting.dispose();
        this.codeSplittingFileListComposite.dispose();
        this.editor.dispose();
        this.codeSplittingTabComposite.dispose();
        this.codeSplittingTabItem.dispose();
    }

    protected TabItem createContents(TabFolder tabFolder) {
        this.codeSplittingTabItem = new TabItem(tabFolder, 2048);
        this.codeSplittingTabItem.setText(CODE_SPLITTING_TAB_TEXT);
        this.codeSplittingTabItem.setToolTipText(CODE_SPLITTING_TAB_TOOLTIP);
        this.codeSplittingTabComposite = new Composite((Composite)tabFolder, 2);
        this.codeSplittingTabComposite.setEnabled(true);
        this.codeSplittingTabComposite.setLayout((Layout)new GridLayout());
        this.codeSplittingComposite = new Composite(this.codeSplittingTabComposite, 0);
        this.codeSplitting = new ComboFieldEditor("codeSplitting", "Splitting mode:", new String[][]{{"none", "none"}, {"type", "type"}, {"number", "number"}}, this.codeSplittingComposite);
        this.codeSplitting.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                CodeSplittingTab.this.updateCodeSplittingNumberEnabled();
            }
        });
        this.codeSplittingNumberComposite = new Composite(this.codeSplittingTabComposite, 0);
        this.codeSplittingNumberComposite.setLayout((Layout)new GridLayout());
        GridData codeSplittingNumberData = new GridData(4);
        codeSplittingNumberData.grabExcessHorizontalSpace = true;
        codeSplittingNumberData.horizontalAlignment = 4;
        this.codeSplittingNumberComposite.setLayoutData((Object)codeSplittingNumberData);
        this.codeSplittingNumber = new IntegerFieldEditor("1", "Number (1-9999):", this.codeSplittingNumberComposite, 5);
        this.codeSplittingNumber.setValidRange(1, 9999);
        this.codeSplittingNumber.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                CodeSplittingTab.this.checkCodeSplittingNumber();
            }
        });
        this.enableSelectiveCodeSplitting = new Button(this.codeSplittingTabComposite, 32);
        this.enableSelectiveCodeSplitting.setText(ENABLE_SELECTIVE_CODE_SPLITTING_TEXT);
        this.enableSelectiveCodeSplitting.setToolTipText(ENABLE_SELECTIVE_CODE_SPLITTING_TOOLTIP);
        this.enableSelectiveCodeSplitting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeSplittingTab.this.updateFileList();
            }
        });
        this.codeSplittingFileListComposite = new Composite(this.codeSplittingTabComposite, 0);
        this.codeSplittingFileListComposite.setEnabled(true);
        this.codeSplittingFileListComposite.setLayout((Layout)new GridLayout());
        GridData codeSplittingFileListData = new GridData(4);
        codeSplittingFileListData.grabExcessHorizontalSpace = true;
        codeSplittingFileListData.horizontalAlignment = 4;
        this.codeSplittingFileListComposite.setLayoutData((Object)codeSplittingFileListData);
        this.editor = new FileListEditor("codeSplittingFileList", "List of files to split", this.codeSplittingFileListComposite, this.project);
        this.editor.setPage((DialogPage)this.page);
        this.codeSplittingTabItem.setControl((Control)this.codeSplittingTabComposite);
        return this.codeSplittingTabItem;
    }

    protected void setMakefileGenerationEnabled(boolean value) {
        this.makeFileGenerationEnabled = value;
        if (this.enableSelectiveCodeSplitting != null) {
            this.enableSelectiveCodeSplitting.setEnabled(value);
        }
        if (this.codeSplittingComposite != null) {
            this.codeSplittingComposite.setEnabled(value);
        }
        if (this.codeSplitting != null) {
            this.codeSplitting.setEnabled(value, this.codeSplittingComposite);
        }
        this.updateCodeSplittingNumberEnabled();
    }

    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String temp = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "codeSplitting"));
            if (temp != null) {
                tempStorage.setValue("codeSplitting", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "selectiveCodeSplitting"))) != null) {
                tempStorage.setValue("selectiveCodeSplitting", temp);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        boolean result = false;
        String actualValue = null;
        String copyValue = null;
        try {
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "codeSplitting"));
            copyValue = tempStorage.getString("codeSplitting");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "selectiveCodeSplitting"));
            copyValue = tempStorage.getString("selectiveCodeSplitting");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            result |= this.editor.isChanged();
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return result;
    }

    public boolean checkProperties(ProjectBuildPropertyPage page) {
        if ("number".equals(this.codeSplitting.getActualValue())) {
            try {
                this.codeSplittingNumber.getIntValue();
            }
            catch (NumberFormatException e) {
                page.setErrorMessage(INVALID_CODESPLITTING_NUMBER + this.codeSplittingNumber.getStringValue());
                return false;
            }
        }
        return true;
    }

    protected void performDefaults() {
        this.codeSplitting.setSelectedValue("none");
        this.codeSplittingNumber.setStringValue("1");
        this.updateCodeSplittingNumberEnabled();
        this.editor.loadDefault();
    }

    public void loadProperties(IProject project) {
        try {
            String codeSplittingType = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "codeSplitting"));
            if (codeSplittingType == null || codeSplittingType.length() == 0) {
                this.codeSplitting.setSelectedValue("none");
                this.codeSplittingNumber.setStringValue("1");
            } else if (codeSplittingType.equals("none") || codeSplittingType.equals("type")) {
                this.codeSplitting.setSelectedValue(codeSplittingType);
                this.codeSplittingNumber.setStringValue("1");
            } else {
                this.codeSplittingNumber.setStringValue(codeSplittingType);
                try {
                    this.codeSplittingNumber.getIntValue();
                    this.codeSplitting.setSelectedValue("number");
                }
                catch (NumberFormatException e) {
                    this.codeSplitting.setSelectedValue("none");
                    this.codeSplittingNumber.setStringValue("1");
                    ErrorReporter.INTERNAL_ERROR((String)(INVALID_CODESPLITTING_NUMBER + this.codeSplittingNumber.getStringValue()));
                }
            }
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "selectiveCodeSplitting"));
            this.enableSelectiveCodeSplitting.setSelection(Boolean.parseBoolean(temp));
            this.updateCodeSplittingNumberEnabled();
            this.editor.load();
        }
        catch (CoreException e) {
            this.codeSplitting.setSelectedValue("none");
            this.codeSplittingNumber.setStringValue("1");
            this.enableSelectiveCodeSplitting.setSelection(false);
            this.setMakefileGenerationEnabled(false);
        }
    }

    public boolean saveProperties(IProject project) {
        try {
            String codeSplittingActualValue = this.codeSplitting.getActualValue();
            if (codeSplittingActualValue.equals("none") || codeSplittingActualValue.equals("type")) {
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "codeSplitting"), codeSplittingActualValue);
            } else if (codeSplittingActualValue.equals("number")) {
                try {
                    this.codeSplittingNumber.getIntValue();
                    project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "codeSplitting"), this.codeSplittingNumber.getStringValue());
                }
                catch (NumberFormatException e) {
                    ErrorReporter.logError((String)(INVALID_CODESPLITTING_NUMBER + this.codeSplittingNumber.getStringValue()));
                }
            } else {
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "codeSplitting"), "none");
                ErrorReporter.INTERNAL_ERROR((String)(INVALID_CODESPLITTING_VALUE + codeSplittingActualValue));
            }
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "selectiveCodeSplitting"), Boolean.toString(this.enableSelectiveCodeSplitting.getSelection()));
            this.editor.store();
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return true;
    }

    private void checkCodeSplittingNumber() {
        if (!this.codeSplittingNumber.isValid()) {
            this.page.setErrorMessage(INVALID_CODESPLITTING_NUMBER + this.codeSplittingNumber.getStringValue());
        } else {
            this.page.setErrorMessage(null);
        }
    }

    private void updateCodeSplittingNumberEnabled() {
        if (this.makeFileGenerationEnabled && "number".equals(this.codeSplitting.getActualValue())) {
            this.codeSplittingNumber.setEnabled(true, this.codeSplittingNumberComposite);
            this.checkCodeSplittingNumber();
            this.enableSelectiveCodeSplitting.setEnabled(true);
            this.updateFileList();
        } else if (this.makeFileGenerationEnabled && "type".equals(this.codeSplitting.getActualValue())) {
            this.codeSplittingNumber.setEnabled(false, this.codeSplittingNumberComposite);
            this.page.setErrorMessage(null);
            this.enableSelectiveCodeSplitting.setEnabled(true);
            this.updateFileList();
        } else {
            this.codeSplittingNumber.setEnabled(false, this.codeSplittingNumberComposite);
            this.page.setErrorMessage(null);
            this.enableSelectiveCodeSplitting.setEnabled(false);
            this.updateFileList();
        }
    }

    private void updateFileList() {
        if (this.makeFileGenerationEnabled && this.enableSelectiveCodeSplitting.getSelection() && this.enableSelectiveCodeSplitting.getEnabled()) {
            this.editor.setEnabled(true, this.codeSplittingFileListComposite);
        } else {
            this.editor.setEnabled(false, this.codeSplittingFileListComposite);
            this.page.setErrorMessage(null);
        }
    }
}

