/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.DecodeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.EncodeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErrorBehaviorAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErrorBehaviorList;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.PrintingAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.PrintingType;
import org.eclipse.titan.designer.AST.TTCN3.attributes.PrototypeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_FunctionBase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.compiler.ProjectSourceCompiler;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public final class Def_Extfunction
extends Def_FunctionBase {
    private static final String FULLNAMEPART1 = ".<formal_parameter_list>";
    private static final String FULLNAMEPART2 = ".<type>";
    private static final String FULLNAMEPART3 = ".<errorbehavior_list>";
    public static final String PORTRETURNNOTALLOWED = "External functions can not return ports";
    private static final String KIND = "external function";
    private final Assignment.Assignment_type assignmentType;
    private final TemplateRestriction.Restriction_type templateRestriction;
    private Def_FunctionBase.EncodingPrototype_type prototype;
    private Type inputType;
    private Type outputType;
    private ExternalFunctionEncodingType_type functionEncodingType;
    private IType.MessageEncoding_type encodingType;
    private String encodingOptions;
    private ErrorBehaviorList errorBehaviorList;
    private PrintingType printingType;

    public Def_Extfunction(Identifier identifier, FormalParameterList formalParameters, Type returnType, boolean returnsTemplate, TemplateRestriction.Restriction_type templateRestriction) {
        super(identifier, null, false, false, false, false, formalParameters, returnType);
        this.assignmentType = returnType == null ? Assignment.Assignment_type.A_EXT_FUNCTION : (returnsTemplate ? Assignment.Assignment_type.A_EXT_FUNCTION_RTEMP : Assignment.Assignment_type.A_EXT_FUNCTION_RVAL);
        this.formalParameterList.setMyDefinition(this);
        this.templateRestriction = templateRestriction;
        this.prototype = Def_FunctionBase.EncodingPrototype_type.NONE;
        this.functionEncodingType = ExternalFunctionEncodingType_type.MANUAL;
        this.encodingType = IType.MessageEncoding_type.UNDEFINED;
        this.encodingOptions = null;
        this.errorBehaviorList = null;
        this.printingType = null;
        this.formalParameterList.setFullNameParent(this);
        if (this.returnType != null) {
            this.returnType.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return this.assignmentType;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.formalParameterList == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.returnType == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.errorBehaviorList == child) {
            return builder.append(FULLNAMEPART3);
        }
        return builder;
    }

    public Def_FunctionBase.EncodingPrototype_type getPrototype() {
        return this.prototype;
    }

    public Type getInputType() {
        return this.inputType;
    }

    public Type getOutputType() {
        return this.outputType;
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public String getOutlineIcon() {
        if (this.returnType == null) {
            return "function_external.gif";
        }
        return "function_external_return.gif";
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.formalParameterList.setMyScope(scope);
        if (this.returnType != null) {
            this.returnType.setMyScope(scope);
        }
        scope.addSubScope(this.formalParameterList.getLocation(), this.formalParameterList);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isUsed = false;
        this.prototype = Def_FunctionBase.EncodingPrototype_type.NONE;
        this.functionEncodingType = ExternalFunctionEncodingType_type.MANUAL;
        this.encodingType = IType.MessageEncoding_type.UNDEFINED;
        this.encodingOptions = null;
        this.errorBehaviorList = null;
        this.printingType = null;
        this.lastTimeChecked = timestamp;
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionExternalFunction", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.returnType != null) {
            this.returnType.check(timestamp);
            IType returnedType = this.returnType.getTypeRefdLast(timestamp);
            if (returnedType != null && IType.Type_type.TYPE_PORT.equals((Object)returnedType.getTypetype()) && this.returnType.getLocation() != null) {
                this.returnType.getLocation().reportSemanticError(PORTRETURNNOTALLOWED);
            }
        }
        this.formalParameterList.reset();
        this.formalParameterList.check(timestamp, this.getAssignmentType());
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
            this.analyzeExtensionAttributes(timestamp);
            this.checkPrototype(timestamp);
            this.checkFunctionType(timestamp);
        }
    }

    @Override
    public void postCheck() {
        super.postCheck();
    }

    public void analyzeExtensionAttributes(CompilationTimeStamp timestamp) {
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        ArrayList<AttributeSpecification> specifications = null;
        for (SingleWithAttribute attribute : realAttributes) {
            Qualifiers qualifiers;
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType()) || (qualifiers = attribute.getQualifiers()) != null && qualifiers.getNofQualifiers() != 0) continue;
            if (specifications == null) {
                specifications = new ArrayList<AttributeSpecification>();
            }
            specifications.add(attribute.getAttributeSpecification());
        }
        if (specifications == null) {
            return;
        }
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        for (AttributeSpecification specification : specifications) {
            ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
            analyzer.parse(specification);
            List<ExtensionAttribute> temp = analyzer.getAttributes();
            if (temp == null) continue;
            attributes.addAll(temp);
        }
        for (ExtensionAttribute extensionAttribute : attributes) {
            switch (extensionAttribute.getAttributeType()) {
                case PROTOTYPE: {
                    if (Def_FunctionBase.EncodingPrototype_type.NONE.equals((Object)this.prototype)) {
                        this.prototype = ((PrototypeAttribute)extensionAttribute).getPrototypeType();
                        break;
                    }
                    this.location.reportSemanticError("duplicate attribute `prototype'.");
                    break;
                }
                case ENCODE: {
                    switch (this.functionEncodingType) {
                        case MANUAL: {
                            break;
                        }
                        case ENCODE: {
                            this.location.reportSemanticError("duplicate attribute `encode'.");
                            break;
                        }
                        case DECODE: {
                            this.location.reportSemanticError("`decode' and `encode' attributes cannot be used at the same time.");
                            break;
                        }
                    }
                    this.encodingType = ((EncodeAttribute)extensionAttribute).getEncodingType();
                    this.encodingOptions = ((EncodeAttribute)extensionAttribute).getOptions();
                    this.functionEncodingType = ExternalFunctionEncodingType_type.ENCODE;
                    break;
                }
                case DECODE: {
                    switch (this.functionEncodingType) {
                        case MANUAL: {
                            break;
                        }
                        case ENCODE: {
                            this.location.reportSemanticError("`decode' and `encode' attributes cannot be used at the same time.");
                            break;
                        }
                        case DECODE: {
                            this.location.reportSemanticError("duplicate attribute `decode'.");
                            break;
                        }
                    }
                    this.encodingType = ((DecodeAttribute)extensionAttribute).getEncodingType();
                    this.encodingOptions = ((DecodeAttribute)extensionAttribute).getOptions();
                    this.functionEncodingType = ExternalFunctionEncodingType_type.DECODE;
                    break;
                }
                case ERRORBEHAVIOR: {
                    if (this.errorBehaviorList == null) {
                        this.errorBehaviorList = ((ErrorBehaviorAttribute)extensionAttribute).getErrrorBehaviorList();
                        break;
                    }
                    this.errorBehaviorList.addAllBehaviors(((ErrorBehaviorAttribute)extensionAttribute).getErrrorBehaviorList());
                    break;
                }
                case PRINTING: {
                    if (this.printingType == null) {
                        this.printingType = ((PrintingAttribute)extensionAttribute).getPrintingType();
                        break;
                    }
                    this.location.reportSemanticError("duplicate attribute `printing'.");
                    break;
                }
            }
        }
    }

    private void checkPrototype(CompilationTimeStamp timestamp) {
        if (Def_FunctionBase.EncodingPrototype_type.NONE.equals((Object)this.prototype)) {
            return;
        }
        if (Def_FunctionBase.EncodingPrototype_type.CONVERT.equals((Object)this.prototype)) {
            if (this.formalParameterList.getNofParameters() == 1) {
                FormalParameter parameter = this.formalParameterList.getParameterByIndex(0);
                switch (parameter.getRealAssignmentType()) {
                    case A_PAR_VAL: 
                    case A_PAR_VAL_IN: {
                        this.inputType = parameter.getType(timestamp);
                        break;
                    }
                    default: {
                        String message = MessageFormat.format("The parameter must be an `in'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), parameter.getAssignmentName());
                        parameter.getLocation().reportSemanticError(message);
                        break;
                    }
                }
            } else {
                String message = MessageFormat.format("The external function must have one parameter instead of {0} for attribute `prototype({1})''", this.formalParameterList.getNofParameters(), this.prototype.getName());
                this.formalParameterList.getLocation().reportSemanticError(message);
            }
        } else if (this.formalParameterList.getNofParameters() == 2) {
            FormalParameter firstParameter = this.formalParameterList.getParameterByIndex(0);
            if (Def_FunctionBase.EncodingPrototype_type.SLIDING.equals((Object)this.prototype)) {
                if (Assignment.Assignment_type.A_PAR_VAL_INOUT.semanticallyEquals(firstParameter.getRealAssignmentType())) {
                    Type firstParameterType = firstParameter.getType(timestamp);
                    IType last = firstParameterType.getTypeRefdLast(timestamp);
                    if (last.getIsErroneous(timestamp)) {
                        this.inputType = firstParameterType;
                    } else {
                        switch (last.getTypetypeTtcn3()) {
                            case TYPE_OCTETSTRING: 
                            case TYPE_CHARSTRING: 
                            case TYPE_BITSTRING: {
                                this.inputType = firstParameterType;
                                break;
                            }
                            default: {
                                String message = MessageFormat.format("The type of the first parameter must be `octetstring'' or `charstring'' for attribute `prototype({0})''", this.prototype.getName());
                                firstParameter.getLocation().reportSemanticError(message);
                                break;
                            }
                        }
                    }
                } else {
                    firstParameter.getLocation().reportSemanticError(MessageFormat.format("The first parameter must be an `inout'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), firstParameter.getAssignmentName()));
                }
            } else if (Assignment.Assignment_type.A_PAR_VAL_IN.semanticallyEquals(firstParameter.getRealAssignmentType())) {
                this.inputType = firstParameter.getType(timestamp);
            } else {
                firstParameter.getLocation().reportSemanticError(MessageFormat.format("The first parameter must be an `in'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), firstParameter.getAssignmentName()));
            }
            FormalParameter secondParameter = this.formalParameterList.getParameterByIndex(1);
            if (Assignment.Assignment_type.A_PAR_VAL_OUT.semanticallyEquals(secondParameter.getRealAssignmentType())) {
                this.outputType = secondParameter.getType(timestamp);
            } else {
                secondParameter.getLocation().reportSemanticError(MessageFormat.format("The second parameter must be an `out'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), secondParameter.getAssignmentName()));
            }
        } else {
            this.formalParameterList.getLocation().reportSemanticError(MessageFormat.format("The function must have two parameters for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), this.formalParameterList.getNofParameters()));
        }
        if (Def_FunctionBase.EncodingPrototype_type.FAST.equals((Object)this.prototype)) {
            if (this.returnType != null) {
                this.returnType.getLocation().reportSemanticError(MessageFormat.format("The external function cannot have return type fo attribute `prototype({0})''", this.prototype.getName()));
            }
        } else if (this.returnType == null) {
            this.location.reportSemanticError(MessageFormat.format("The external function must have a return type for attribute `prototype({0})''", this.prototype.getName()));
        } else {
            if (Assignment.Assignment_type.A_FUNCTION_RTEMP.semanticallyEquals(this.assignmentType)) {
                this.returnType.getLocation().reportSemanticError(MessageFormat.format("The external function must return a value instead of a template for attribute `prototype({0})''", this.prototype.getName()));
            }
            if (Def_FunctionBase.EncodingPrototype_type.CONVERT.equals((Object)this.prototype)) {
                this.outputType = this.returnType;
            } else {
                IType last = this.returnType.getTypeRefdLast(timestamp);
                if (!last.getIsErroneous(timestamp) && !IType.Type_type.TYPE_INTEGER.equals((Object)last.getTypetypeTtcn3())) {
                    this.returnType.getLocation().reportSemanticError(MessageFormat.format("The return type of the function must be `integer'' instead of `{0}'' for attribute `prototype({1})''", this.returnType.getTypename(), this.prototype.getName()));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void checkFunctionType(CompilationTimeStamp timestamp) {
        switch (1.$SwitchMap$org$eclipse$titan$designer$AST$TTCN3$definitions$Def_Extfunction$ExternalFunctionEncodingType_type[this.functionEncodingType.ordinal()]) {
            case 1: {
                if (this.errorBehaviorList == null) break;
                this.errorBehaviorList.getLocation().reportSemanticError("Attribute `errorbehavior' can only be used together with `encode' or `decode'");
                this.errorBehaviorList.check(timestamp);
                break;
            }
            case 2: {
                switch (1.$SwitchMap$org$eclipse$titan$designer$AST$TTCN3$definitions$Def_FunctionBase$EncodingPrototype_type[this.prototype.ordinal()]) {
                    case 1: {
                        this.location.reportSemanticError("Attribute `encode' cannot be used without `prototype'");
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.location.reportSemanticError(MessageFormat.format("Attribute `encode'' cannot be used without `prototype({0})''", new Object[]{this.prototype.getName()}));
                        break;
                    }
                }
                if (this.inputType == null) ** GOTO lbl36
                if (!this.inputType.hasEncoding(timestamp, this.encodingType, this.encodingOptions)) ** GOTO lbl32
                switch (1.$SwitchMap$org$eclipse$titan$designer$AST$IType$MessageEncoding_type[this.encodingType.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (this.prototype != Def_FunctionBase.EncodingPrototype_type.CONVERT) {
                            this.location.reportSemanticError(MessageFormat.format("Only `prototype(convert)'' is allowed for `{0}'' encoding functions", new Object[]{this.encodingType.getEncodingName()}));
                            break;
                        }
                        if (this.inputType instanceof Referenced_Type) {
                            refChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                            refd = ((IReferencingType)this.inputType).getTypeRefd(timestamp, refChain);
                            refChain.release();
                            refd.setEncodingFunction(this.encodingType == IType.MessageEncoding_type.PER ? "PER" : this.encodingOptions, this);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                ** GOTO lbl36
lbl32:
                // 1 sources

                if (this.encodingType == IType.MessageEncoding_type.CUSTOM) {
                    this.inputType.getLocation().reportSemanticError(MessageFormat.format("Input type `{0}'' does not support custom encoding `{1}''", new Object[]{this.inputType.getTypename(), this.encodingOptions}));
                } else {
                    this.inputType.getLocation().reportSemanticError(MessageFormat.format("Input type `{0}'' does not support `{1}'' encoding.", new Object[]{this.inputType.getTypename(), this.encodingType.getEncodingName()}));
                }
lbl36:
                // 4 sources

                if (this.outputType != null) {
                    switch (1.$SwitchMap$org$eclipse$titan$designer$AST$IType$MessageEncoding_type[this.encodingType.ordinal()]) {
                        case 4: {
                            streamType = Type.getStreamType(this.encodingType, 0);
                            streamType2 = Type.getStreamType(this.encodingType, 1);
                            streamType3 = Type.getStreamType(this.encodingType, 2);
                            if (streamType.isIdentical(timestamp, this.outputType) || streamType2.isIdentical(timestamp, this.outputType) || streamType3.isIdentical(timestamp, this.outputType)) break;
                            this.outputType.getLocation().reportSemanticError(MessageFormat.format("The output type of {0} encoding should be `{1}'', `{2}'' or `{3}'' instead of `{4}''", new Object[]{this.encodingType.getEncodingName(), streamType.getTypename(), streamType2.getTypename(), streamType3.getTypename(), this.outputType.getTypename()}));
                            break;
                        }
                        case 2: 
                        case 3: {
                            streamType = Type.getStreamType(this.encodingType, 0);
                            if (streamType.isIdentical(timestamp, this.outputType)) break;
                            this.outputType.getLocation().reportSemanticError(MessageFormat.format("The output type of {0} encoding should be `{1}'' instead of `{2}''", new Object[]{this.encodingType.getEncodingName(), streamType.getTypename(), this.outputType.getTypename()}));
                            break;
                        }
                        default: {
                            streamType = Type.getStreamType(this.encodingType, 0);
                            streamType2 = Type.getStreamType(this.encodingType, 1);
                            if (streamType.isIdentical(timestamp, this.outputType) || streamType2.isIdentical(timestamp, this.outputType)) break;
                            this.outputType.getLocation().reportSemanticError(MessageFormat.format("The output type of {0} encoding should be `{1}'' or `{2}'' instead of `{3}''", new Object[]{this.encodingType.getEncodingName(), streamType.getTypename(), streamType2.getTypename(), this.outputType.getTypename()}));
                            break;
                        }
                    }
                }
                if (this.errorBehaviorList != null) {
                    this.errorBehaviorList.check(timestamp);
                }
                if (this.printingType == null) break;
                this.printingType.check(timestamp);
                break;
            }
            case 3: {
                if (Def_FunctionBase.EncodingPrototype_type.NONE.equals((Object)this.prototype)) {
                    this.location.reportSemanticError("Attribute `decode' cannot be used without `prototype'");
                }
                if (this.inputType != null) {
                    switch (1.$SwitchMap$org$eclipse$titan$designer$AST$IType$MessageEncoding_type[this.encodingType.ordinal()]) {
                        case 4: {
                            streamType = Type.getStreamType(this.encodingType, 0);
                            streamType2 = Type.getStreamType(this.encodingType, 1);
                            streamType3 = Type.getStreamType(this.encodingType, 2);
                            if (streamType.isIdentical(timestamp, this.inputType) || streamType2.isIdentical(timestamp, this.inputType) || streamType3.isIdentical(timestamp, this.inputType)) break;
                            this.inputType.getLocation().reportSemanticError(MessageFormat.format("The input type of {0} decoding should be `{1}'', `{2}'' or `{3}'' instead of `{4}''", new Object[]{this.encodingType.getEncodingName(), streamType.getTypename(), streamType2.getTypename(), streamType3.getTypename(), this.inputType.getTypename()}));
                            break;
                        }
                        case 2: 
                        case 3: {
                            streamType = Type.getStreamType(this.encodingType, 0);
                            if (streamType.isIdentical(timestamp, this.inputType)) break;
                            this.inputType.getLocation().reportSemanticError(MessageFormat.format("The input type of {0} decoding should be `{1}'' instead of `{2}''", new Object[]{this.encodingType.getEncodingName(), streamType.getTypename(), this.inputType.getTypename()}));
                            break;
                        }
                        default: {
                            streamType = Type.getStreamType(this.encodingType, 0);
                            streamType2 = Type.getStreamType(this.encodingType, 1);
                            if (streamType.isIdentical(timestamp, this.inputType) || streamType2.isIdentical(timestamp, this.inputType)) break;
                            this.outputType.getLocation().reportSemanticError(MessageFormat.format("The input type of {0} decoding should be `{1}'' or `{2}'' instead of `{3}''", new Object[]{this.encodingType.getEncodingName(), streamType.getTypename(), streamType2.getTypename(), this.inputType.getTypename()}));
                            break;
                        }
                    }
                }
                if (this.outputType != null && !this.outputType.hasEncoding(timestamp, this.encodingType, this.encodingOptions)) {
                    if (this.encodingType == IType.MessageEncoding_type.CUSTOM) {
                        this.outputType.getLocation().reportSemanticError(MessageFormat.format("Output type `{0}'' does not support custom encoding `{1}''", new Object[]{this.outputType.getTypename(), this.encodingOptions}));
                    } else {
                        this.outputType.getLocation().reportSemanticError(MessageFormat.format("Output type `{0}'' does not support {1} encoding", new Object[]{this.outputType.getTypename(), this.encodingType.getEncodingName()}));
                    }
                } else if (this.encodingType == IType.MessageEncoding_type.CUSTOM || this.encodingType == IType.MessageEncoding_type.PER) {
                    if (this.prototype != Def_FunctionBase.EncodingPrototype_type.SLIDING) {
                        this.getLocation().reportSemanticError(MessageFormat.format("Only `prototype(sliding)' is allowed for {0} decoding functions", new Object[]{this.encodingType.getEncodingName()}));
                    } else if (this.outputType != null && this.outputType instanceof IReferencingType) {
                        chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                        ((IReferencingType)this.outputType).getTypeRefd(timestamp, chain).setDecodingFunction(this.encodingType == IType.MessageEncoding_type.PER ? "PER" : this.encodingOptions, this);
                        chain.release();
                    }
                }
                if (this.errorBehaviorList == null) break;
                this.errorBehaviorList.check(timestamp);
                break;
            }
        }
        if (this.printingType != null && (this.functionEncodingType != ExternalFunctionEncodingType_type.ENCODE || this.encodingType != IType.MessageEncoding_type.JSON)) {
            this.location.reportSemanticError("Attribute `printing' is only allowed for JSON encoding functions");
        }
    }

    @Override
    public String getProposalDescription() {
        StringBuilder nameBuilder = new StringBuilder(this.identifier.getDisplayName());
        nameBuilder.append('(');
        this.formalParameterList.getAsProposalDesriptionPart(nameBuilder);
        nameBuilder.append(')');
        return nameBuilder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(index).getReferenceType())) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            StringBuilder patternBuilder = new StringBuilder(this.identifier.getDisplayName());
            patternBuilder.append('(');
            this.formalParameterList.getAsProposalPart(patternBuilder);
            patternBuilder.append(')');
            propCollector.addTemplateProposal(this.identifier.getDisplayName(), new Template(this.getProposalDescription(), "", propCollector.getContextIdentifier(), patternBuilder.toString(), false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            super.addProposal(propCollector, index);
        } else if (subrefs.size() > index + 1 && this.returnType != null && ISubReference.Subreference_type.parameterisedSubReference.equals((Object)subrefs.get(index).getReferenceType()) && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.returnType.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() <= index || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(index).getReferenceType())) {
            return;
        }
        if (this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && this.returnType != null) {
                this.returnType.addDeclaration(declarationCollector, index + 1);
            } else {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public String getOutlineText() {
        StringBuilder text = new StringBuilder(this.identifier.getDisplayName());
        if (this.formalParameterList == null || this.lastTimeChecked == null) {
            return text.toString();
        }
        text.append('(');
        for (int i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
            FormalParameter parameter;
            if (i != 0) {
                text.append(", ");
            }
            if (Assignment.Assignment_type.A_PAR_TIMER.semanticallyEquals((parameter = this.formalParameterList.getParameterByIndex(i)).getRealAssignmentType())) {
                text.append("timer");
                continue;
            }
            Type type = parameter.getType(this.lastTimeChecked);
            if (type == null) {
                text.append("Unknown type");
                continue;
            }
            text.append(type.getTypename());
        }
        text.append(')');
        return text.toString();
    }

    @Override
    public TemplateRestriction.Restriction_type getTemplateRestriction() {
        return this.templateRestriction;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0 && this.identifier != null) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.formalParameterList != null) {
                if (enveloped) {
                    this.formalParameterList.updateSyntax(reparser, false);
                    reparser.updateLocation(this.formalParameterList.getLocation());
                } else if (reparser.envelopsDamage(this.formalParameterList.getLocation())) {
                    this.formalParameterList.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.formalParameterList.getLocation());
                }
            }
            if (this.returnType != null) {
                if (enveloped) {
                    this.returnType.updateSyntax(reparser, false);
                    reparser.updateLocation(this.returnType.getLocation());
                } else if (reparser.envelopsDamage(this.returnType.getLocation())) {
                    this.returnType.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.returnType.getLocation());
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    this.withAttributesPath.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.formalParameterList != null) {
            this.formalParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.formalParameterList.getLocation());
        }
        if (this.returnType != null) {
            this.returnType.updateSyntax(reparser, false);
            reparser.updateLocation(this.returnType.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.formalParameterList != null) {
            this.formalParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.returnType != null) {
            this.returnType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.formalParameterList != null && !this.formalParameterList.accept(v)) {
            return false;
        }
        return this.returnType == null || this.returnType.accept(v);
    }

    @Override
    public String getGenName() {
        StringBuilder returnValue = new StringBuilder();
        if (this.functionEncodingType == ExternalFunctionEncodingType_type.MANUAL || this.functionEncodingType == ExternalFunctionEncodingType_type.ENCODE && (this.encodingType == IType.MessageEncoding_type.CUSTOM || this.encodingType == IType.MessageEncoding_type.PER) || this.functionEncodingType == ExternalFunctionEncodingType_type.DECODE && (this.encodingType == IType.MessageEncoding_type.CUSTOM || this.encodingType == IType.MessageEncoding_type.PER)) {
            returnValue.append(this.myScope.getModuleScopeGen().getIdentifier().getName());
            returnValue.append("_externalfunctions.");
        }
        returnValue.append(this.identifier.getName());
        return returnValue.toString();
    }

    @Override
    public String getGenNameFromScope(JavaGenData aData, StringBuilder source, String prefix) {
        if (this.functionEncodingType == ExternalFunctionEncodingType_type.MANUAL || this.functionEncodingType == ExternalFunctionEncodingType_type.ENCODE && (this.encodingType == IType.MessageEncoding_type.CUSTOM || this.encodingType == IType.MessageEncoding_type.PER) || this.functionEncodingType == ExternalFunctionEncodingType_type.DECODE && (this.encodingType == IType.MessageEncoding_type.CUSTOM || this.encodingType == IType.MessageEncoding_type.PER)) {
            StringBuilder moduleName = new StringBuilder();
            moduleName.append(this.myScope.getModuleScopeGen().getIdentifier().getName());
            moduleName.append("_externalfunctions");
            String packageRoot = ProjectSourceCompiler.getPackageUserProvidedRoot(this.myScope.getModuleScopeGen().getProject());
            aData.addImport(packageRoot + "." + moduleName.toString());
            StringBuilder returnValue = new StringBuilder(moduleName);
            returnValue.append('.');
            returnValue.append(this.identifier.getName());
            return returnValue.toString();
        }
        return super.getGenNameFromScope(aData, source, prefix);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        String genName = this.getGenName();
        if (this.formalParameterList != null) {
            this.formalParameterList.setGenName(genName);
        }
        if (this.functionEncodingType == ExternalFunctionEncodingType_type.MANUAL || this.functionEncodingType == ExternalFunctionEncodingType_type.ENCODE && (this.encodingType == IType.MessageEncoding_type.CUSTOM || this.encodingType == IType.MessageEncoding_type.PER) || this.functionEncodingType == ExternalFunctionEncodingType_type.DECODE && (this.encodingType == IType.MessageEncoding_type.CUSTOM || this.encodingType == IType.MessageEncoding_type.PER)) {
            return;
        }
        StringBuilder sb = aData.getSrc();
        StringBuilder source = new StringBuilder();
        if (VisibilityModifier.Private.equals((Object)this.getVisibilityModifier())) {
            source.append("\tprivate");
        } else {
            source.append("\tpublic");
        }
        source.append(" static final ");
        switch (this.assignmentType) {
            case A_EXT_FUNCTION: {
                source.append("void");
                break;
            }
            case A_EXT_FUNCTION_RVAL: {
                source.append(this.returnType.getGenNameValue(aData, source));
                break;
            }
            case A_EXT_FUNCTION_RTEMP: {
                source.append(this.returnType.getGenNameTemplate(aData, source));
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous definition `" + this.getFullName() + "''"));
                return;
            }
        }
        source.append(' ');
        source.append(genName);
        source.append('(');
        if (this.formalParameterList != null) {
            this.formalParameterList.generateCode(aData, source);
        }
        source.append(") {\n");
        switch (this.functionEncodingType) {
            case ENCODE: {
                this.generate_code_encode(aData, source);
                break;
            }
            case DECODE: {
                this.generate_code_decode(aData, source);
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous definition `" + this.getFullName() + "''"));
                return;
            }
        }
        source.append("\t}\n");
        sb.append((CharSequence)source);
    }

    private void generate_code_encode(JavaGenData aData, StringBuilder source) {
        String resultName;
        aData.addCommonLibraryImport("TTCN_Buffer");
        aData.addCommonLibraryImport("TTCN_EncDec");
        aData.addCommonLibraryImport("TTCN_Logger");
        String firstParName = this.formalParameterList.getParameterByIndex(0).getIdentifier().getName();
        int prettyPrinting = this.printingType != null && this.printingType.getPrintingType() == PrintingType.PrintingTypeEnum.PRETTY ? 1 : 0;
        source.append("\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEBUG_ENCDEC)) {\n");
        source.append("\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.DEBUG_ENCDEC);\n");
        source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_event_str(\"{0}(): Encoding {1}: \");\n", this.identifier.getDisplayName(), this.inputType.getTypename()));
        source.append(MessageFormat.format("\t\t\t{0}.log();\n", firstParName));
        source.append("\t\t\tTTCN_Logger.end_event();\n");
        source.append("\t\t}\n");
        source.append("\t\tTTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_DEFAULT);\n");
        source.append("\t\tfinal TTCN_Buffer ttcn_buffer = new TTCN_Buffer();\n");
        source.append(MessageFormat.format("\t\t{0}.encode({1}_descr_, ttcn_buffer, TTCN_EncDec.coding_type.CT_{2}, {3});\n", firstParName, this.inputType.getGenNameTypeDescriptor(aData, source), this.encodingType.getEncodingName(), prettyPrinting));
        switch (this.prototype) {
            case CONVERT: {
                resultName = "ret_val";
                source.append(MessageFormat.format("\t\tfinal {0} ret_val = new {0}();\n", this.outputType.getGenNameValue(aData, source)));
                break;
            }
            case FAST: {
                resultName = this.formalParameterList.getParameterByIndex(1).getIdentifier().getName();
                break;
            }
            default: {
                resultName = "";
            }
        }
        if (this.outputType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetypeTtcn3() == IType.Type_type.TYPE_BITSTRING) {
            aData.addCommonLibraryImport("AdditionalFunctions");
            source.append("\t\tfinal TitanOctetString tmp_os = new TitanOctetString();\n");
            source.append("\t\tttcn_buffer.get_string(tmp_os);\n");
            source.append(MessageFormat.format("\t\t{0}.operator_assign(AdditionalFunctions.oct2bit(tmp_os));\n", resultName));
        } else {
            source.append(MessageFormat.format("\t\tttcn_buffer.get_string({0});\n", resultName));
        }
        source.append("\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEBUG_ENCDEC)) {\n");
        source.append("\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.DEBUG_ENCDEC);\n");
        source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_event_str(\"{0}(): Stream after encoding: \");\n", this.identifier.getDisplayName()));
        source.append(MessageFormat.format("\t\t\t{0}.log();\n", resultName));
        source.append("\t\t\tTTCN_Logger.end_event();\n");
        source.append("\t\t}\n");
        if (this.prototype == Def_FunctionBase.EncodingPrototype_type.CONVERT) {
            source.append("\t\treturn ret_val;\n");
        }
    }

    private void generate_code_decode(JavaGenData aData, StringBuilder source) {
        String generatedEncodingOptions;
        String resultName;
        aData.addCommonLibraryImport("TTCN_Buffer");
        aData.addCommonLibraryImport("TTCN_EncDec");
        aData.addCommonLibraryImport("TTCN_EncDec.error_type");
        aData.addCommonLibraryImport("TTCN_Logger");
        String firstParName = this.formalParameterList.getParameterByIndex(0).getIdentifier().getName();
        source.append("\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEBUG_ENCDEC)) {\n");
        source.append("\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.DEBUG_ENCDEC);\n");
        source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_event_str(\"{0}(): Stream before decoding: \");\n", this.identifier.getDisplayName()));
        source.append(MessageFormat.format("\t\t\t{0}.log();\n", firstParName));
        source.append("\t\t\tTTCN_Logger.end_event();\n");
        source.append("\t\t}\n");
        if (this.errorBehaviorList != null) {
            this.errorBehaviorList.generateCode(aData, source);
        } else if (this.prototype == Def_FunctionBase.EncodingPrototype_type.BACKTRACK || this.prototype == Def_FunctionBase.EncodingPrototype_type.SLIDING) {
            source.append("\t\tTTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_WARNING);\n");
        } else {
            source.append("\t\tTTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_DEFAULT);\n");
        }
        source.append("\t\tTTCN_EncDec.clear_error();\n");
        if (this.inputType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetypeTtcn3() == IType.Type_type.TYPE_BITSTRING) {
            aData.addCommonLibraryImport("AdditionalFunctions");
            source.append(MessageFormat.format("\t\tfinal TTCN_Buffer ttcn_buffer = new TTCN_Buffer(AdditionalFunctions.bit2oct({0}));\n", firstParName));
        } else {
            source.append(MessageFormat.format("\t\tfinal TTCN_Buffer ttcn_buffer = new TTCN_Buffer({0});\n", firstParName));
        }
        if (this.prototype == Def_FunctionBase.EncodingPrototype_type.CONVERT) {
            source.append(MessageFormat.format("\t\tfinal {0} ret_val = new {0}();\n", this.outputType.getGenNameValue(aData, source)));
            resultName = "ret_val";
        } else {
            resultName = this.formalParameterList.getParameterByIndex(1).getIdentifier().getName();
        }
        if (this.encodingType == IType.MessageEncoding_type.TEXT) {
            source.append("\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEBUG_ENCDEC)) {\n");
            source.append("\t\t\tTTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_LOG_MATCHING, TTCN_EncDec.error_behavior_type.EB_WARNING);\n");
            source.append("\t\t}\n");
        }
        if (this.encodingOptions == null) {
            generatedEncodingOptions = "0";
        } else {
            switch (this.encodingType) {
                case XER: 
                case BER: {
                    aData.addBuiltinTypeImport("TTCN_EncDec");
                    generatedEncodingOptions = "TTCN_EncDec." + this.encodingOptions;
                    break;
                }
                default: {
                    generatedEncodingOptions = this.encodingOptions;
                }
            }
        }
        source.append(MessageFormat.format("\t\t{0}.decode({1}_descr_, ttcn_buffer, TTCN_EncDec.coding_type.CT_{2}, {3});\n", resultName, this.outputType.getGenNameTypeDescriptor(aData, source), this.encodingType.getEncodingName(), generatedEncodingOptions));
        source.append("\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEBUG_ENCDEC)) {\n");
        source.append("\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.DEBUG_ENCDEC);\n");
        source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_event_str(\"{0}(): Decoded {1}: \");\n", this.identifier.getDisplayName(), this.outputType.getTypename()));
        source.append(MessageFormat.format("\t\t\t{0}.log();\n", resultName));
        source.append("\t\t\tTTCN_Logger.end_event();\n");
        source.append("\t\t}\n");
        if (this.prototype != Def_FunctionBase.EncodingPrototype_type.SLIDING) {
            aData.addBuiltinTypeImport("TitanCharString");
            aData.addBuiltinTypeImport("TitanOctetString");
            source.append("\t\tif (TTCN_EncDec.get_last_error_type() == TTCN_EncDec.error_type.ET_NONE) {\n");
            source.append("\t\t\tif (ttcn_buffer.get_pos() < ttcn_buffer.get_len()) {\n");
            source.append("\t\t\t\tttcn_buffer.cut();\n");
            source.append("\t\t\t\tfinal TitanOctetString tmp_os = new TitanOctetString();\n");
            source.append("\t\t\t\tttcn_buffer.get_string(tmp_os);\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event_log2str();\n");
            if (this.inputType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetypeTtcn3() == IType.Type_type.TYPE_BITSTRING) {
                source.append("\t\t\t\tAdditionalFunctions.oct2bit(tmp_os).log();\n");
            } else {
                source.append("\t\t\t\ttmp_os.log();\n");
            }
            source.append("\t\t\t\tfinal TitanCharString remaining_stream = TTCN_Logger.end_event_log2str();\n");
            source.append(MessageFormat.format("\t\t\t\tTTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_EXTRA_DATA, \"{0}(): Warning: Data remained at the end of the stream after successful decoding: %s\", remaining_stream.get_value());\n", this.identifier.getDisplayName()));
            source.append("\t\t\t}\n");
            if (this.prototype == Def_FunctionBase.EncodingPrototype_type.BACKTRACK) {
                aData.addBuiltinTypeImport("TitanInteger");
                source.append("\t\t\treturn new TitanInteger(0);\n");
                source.append("\t\t} else {\n");
                source.append("\t\t\treturn new TitanInteger(1);\n");
                source.append("\t\t}\n");
            } else {
                source.append("\t\t}\n");
                if (this.prototype == Def_FunctionBase.EncodingPrototype_type.CONVERT) {
                    source.append("\t\treturn ret_val;\n");
                }
            }
        } else {
            aData.addBuiltinTypeImport("TitanInteger");
            source.append("\t\tswitch (TTCN_EncDec.get_last_error_type()) {\n");
            source.append("\t\tcase ET_NONE: {\n");
            source.append("\t\t\tttcn_buffer.cut();\n");
            if (this.inputType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetypeTtcn3() == IType.Type_type.TYPE_BITSTRING) {
                aData.addBuiltinTypeImport("TitanOctetString");
                source.append("\t\t\tTitanOctetString tmp_os = new TitanOctetString();\n");
                source.append("\t\t\tttcn_buffer.get_string(tmp_os);\n");
                source.append(MessageFormat.format("\t\t\t{0}.operator_assign(AdditionalFunctions.oct2bit(tmp_os));\n", firstParName));
            } else {
                source.append(MessageFormat.format("\t\t\tttcn_buffer.get_string({0});\n", firstParName));
            }
            source.append("\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEBUG_ENCDEC)) {\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.DEBUG_ENCDEC);\n");
            source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_event_str(\"{0}(): stream after decoding: \");\n", this.identifier.getDisplayName()));
            source.append(MessageFormat.format("\t\t\t\t{0}.log();\n", firstParName));
            source.append("\t\t\t\tTTCN_Logger.end_event();\n");
            source.append("\t\t\t}\n");
            source.append("\t\t\treturn new TitanInteger(0); }\n");
            source.append("\t\tcase ET_INCOMPL_MSG:\n");
            source.append("\t\tcase ET_LEN_ERR:\n");
            source.append("\t\t\treturn new TitanInteger(2);\n");
            source.append("\t\tdefault:\n");
            source.append("\t\t\treturn new TitanInteger(1);\n");
            source.append("\t\t}\n");
        }
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        int i;
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText(KIND).addText(" ");
        this.hoverContent.addStyledText(this.getFullName(), 1);
        this.hoverContent.addText("(");
        for (i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
            FormalParameter fp = this.formalParameterList.getParameterByIndex(i);
            if (i > 0) {
                this.hoverContent.addText(", ");
            }
            this.hoverContent.addText(fp.getFormalParamType()).addText(" ").addText(fp.getType(this.lastTimeChecked).getTypename()).addText(" ").addText(fp.getIdentifier().getDisplayName());
        }
        this.hoverContent.addText(")");
        this.hoverContent.addText(this.returnType != null ? " return " + this.returnType.getTypename() : "");
        this.hoverContent.closeHeader();
        if (dc != null) {
            dc.addDescsContent(this.hoverContent);
            dc.addParamsContent(this.hoverContent, this.formalParameterList);
            dc.addReturnContent(this.hoverContent);
            dc.addVerdictsContent(this.hoverContent);
            dc.addRequirementsContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        } else if (this.formalParameterList != null && this.formalParameterList.getNofParameters() > 0) {
            this.hoverContent.addTag("Parameters");
            for (i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
                FormalParameter param = this.formalParameterList.getParameterByIndex(i);
                String paramType = param.getFormalParamType();
                StringBuilder sb = new StringBuilder(param.getIdentifier().getDisplayName());
                sb.append(" (").append(paramType != null ? paramType : "<?>").append(")");
                this.hoverContent.addIndentedText(sb.toString(), "");
            }
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(indentation).append("@desc").append("\n");
        if (this.formalParameterList != null && this.formalParameterList.getNofParameters() > 0) {
            for (int i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
                FormalParameter param = this.formalParameterList.getParameterByIndex(i);
                sb.append(ind).append("@param").append(" ").append(param.getIdentifier().getDisplayName()).append("\n");
            }
        }
        if (this.returnType != null) {
            sb.append(ind).append("@return").append("\n");
        }
        sb.append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }

    @Override
    public FormalParameterList.IsIdenticalResult isIdentical(CompilationTimeStamp timestamp, Def_FunctionBase other) {
        return null;
    }

    public static enum ExternalFunctionEncodingType_type {
        MANUAL,
        ENCODE,
        DECODE;

    }
}

