/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.simulation.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.time4sys.model.time4sys.Project;
import org.polarsys.time4sys.simulation.commands.AutoRecordingCommand;
import org.polarsys.time4sys.simulation.commands.CommandRunner;

public abstract class AbstractTransformationCommandHandler<T extends EObject, R>
extends AbstractHandler {
    protected final Class<T> clazz;
    private String name;

    private static Project getProject(EObject obj) {
        EObject current = obj.eContainer();
        while (current != null && !(current instanceof Project)) {
            current = current.eContainer();
        }
        return (Project)current;
    }

    public AbstractTransformationCommandHandler(Class<T> theHandledClass) {
        this.clazz = theHandledClass;
        this.name = "Test";
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        final ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        try {
            window.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (selection instanceof ITreeSelection) {
                        AbstractTransformationCommandHandler.this.execute((ITreeSelection)selection, monitor, window);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return selection;
    }

    private void execute(ITreeSelection selection, IProgressMonitor monitor, IWorkbenchWindow window) {
        monitor.beginTask(this.name, selection.size());
        try {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                T obj = this.adapt(it.next());
                if (obj != null) {
                    Project project = AbstractTransformationCommandHandler.getProject(obj);
                    CommandRunner cmdRunner = new CommandRunner(window, (Object)project);
                    TransfoRunnable<T, R> aCmd = this.createRecordingCommand(cmdRunner.getDomain(), obj);
                    aCmd.project = project;
                    cmdRunner.execute(aCmd);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public CommandStack getCommandStack(IWorkbenchWindow window, TransactionalEditingDomain theDomain) {
        CommandStack commandStack = null;
        if (theDomain == null && window != null) {
            IEditorPart activeEditor;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (activeEditor = page.getActiveEditor()) instanceof IEditingDomainProvider) {
                EditingDomain editingDomain = ((IEditingDomainProvider)activeEditor).getEditingDomain();
                commandStack = editingDomain.getCommandStack();
            }
        } else {
            commandStack = theDomain.getCommandStack();
        }
        return commandStack;
    }

    protected T adapt(Object obj) {
        if (this.clazz.isInstance(obj)) {
            return (T)((EObject)obj);
        }
        return null;
    }

    protected abstract TransfoRunnable<T, R> createRecordingCommand(TransactionalEditingDomain var1, T var2);

    public static abstract class TransfoRunnable<T, R>
    extends AutoRecordingCommand {
        protected final T obj;
        protected Project project;
        protected R result;
        protected final TransactionalEditingDomain theDomain;

        public TransfoRunnable(TransactionalEditingDomain domain, T value, String label) {
            super(domain, label);
            this.obj = value;
            this.theDomain = domain;
        }

        protected void setResult(R value) {
            this.result = value;
        }

        public Collection<R> getResult() {
            return Collections.singletonList(this.result);
        }
    }
}

