/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.srm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OccurencePolicyKind implements Enumerator
{
    MEMORIZED(0, "Memorized", "Memorized"),
    BOUNDED(1, "Bounded", "Bounded"),
    MEMORYLESS(2, "Memoryless", "Memoryless"),
    UNDEF(3, "Undef", "Undef"),
    OTHER(4, "Other", "Other");

    public static final int MEMORIZED_VALUE = 0;
    public static final int BOUNDED_VALUE = 1;
    public static final int MEMORYLESS_VALUE = 2;
    public static final int UNDEF_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    private static final OccurencePolicyKind[] VALUES_ARRAY;
    public static final List<OccurencePolicyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OccurencePolicyKind[]{MEMORIZED, BOUNDED, MEMORYLESS, UNDEF, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OccurencePolicyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OccurencePolicyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OccurencePolicyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OccurencePolicyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OccurencePolicyKind get(int value) {
        switch (value) {
            case 0: {
                return MEMORIZED;
            }
            case 1: {
                return BOUNDED;
            }
            case 2: {
                return MEMORYLESS;
            }
            case 3: {
                return UNDEF;
            }
            case 4: {
                return OTHER;
            }
        }
        return null;
    }

    private OccurencePolicyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

