/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class GuardedPattern
extends Pattern {
    public Pattern primaryPattern;
    public Expression condition;
    public int whenSourceStart = -1;

    public GuardedPattern(Pattern primaryPattern, Expression condition) {
        this.primaryPattern = primaryPattern;
        this.condition = condition;
        this.sourceStart = primaryPattern.sourceStart;
        this.sourceEnd = condition.sourceEnd;
    }

    @Override
    public LocalVariableBinding[] bindingsWhenTrue() {
        return LocalVariableBinding.merge(this.primaryPattern.bindingsWhenTrue(), this.condition.bindingsWhenTrue());
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.primaryPattern.analyseCode(currentScope, flowContext, flowInfo);
        FlowInfo mergedFlow = this.condition.analyseCode(currentScope, flowContext, flowInfo);
        return mergedFlow.safeInitsWhenTrue();
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, BranchLabel patternMatchLabel, BranchLabel matchFailLabel) {
        BranchLabel guardCheckLabel = new BranchLabel(codeStream);
        this.primaryPattern.generateCode(currentScope, codeStream, guardCheckLabel, matchFailLabel);
        guardCheckLabel.place();
        this.condition.generateOptimizedBoolean(currentScope, codeStream, null, matchFailLabel, true);
    }

    @Override
    public boolean matchFailurePossible() {
        return !this.isUnguarded() || this.primaryPattern.matchFailurePossible();
    }

    @Override
    public boolean isUnconditional(TypeBinding t) {
        return this.isUnguarded() && this.primaryPattern.isUnconditional(t);
    }

    @Override
    public boolean isUnguarded() {
        Constant cst = this.condition.optimizedBooleanConstant();
        return cst != null && cst != Constant.NotAConstant && cst.booleanValue();
    }

    @Override
    public void setIsEitherOrPattern() {
        this.primaryPattern.setIsEitherOrPattern();
    }

    @Override
    public boolean coversType(TypeBinding type) {
        return this.isUnguarded() && this.primaryPattern.coversType(type);
    }

    @Override
    public boolean dominates(Pattern p) {
        return this.isUnguarded() && this.primaryPattern.dominates(p);
    }

    @Override
    public Pattern[] getAlternatives() {
        return this.primaryPattern.getAlternatives();
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        if (this.resolvedType != null || this.primaryPattern == null) {
            return this.resolvedType;
        }
        this.resolvedType = this.primaryPattern.resolveType(scope);
        try {
            scope.resolvingGuardExpression = true;
            this.condition.resolveTypeExpectingWithBindings(this.primaryPattern.bindingsWhenTrue(), scope, TypeBinding.BOOLEAN);
        }
        finally {
            scope.resolvingGuardExpression = false;
        }
        Constant cst = this.condition.optimizedBooleanConstant();
        if (cst.typeID() == 5 && !cst.booleanValue()) {
            scope.problemReporter().falseLiteralInGuard(this.condition);
        }
        if (!this.isUnguarded()) {
            this.primaryPattern.setIsGuarded();
        }
        this.resolvedType = this.primaryPattern.resolvedType;
        return this.resolvedType;
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        this.primaryPattern.print(indent, output).append(" when ");
        return this.condition.print(indent, output);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.primaryPattern.traverse(visitor, scope);
            this.condition.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    protected boolean isApplicable(TypeBinding other, BlockScope scope) {
        return this.primaryPattern.isApplicable(other, scope);
    }
}

