/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.SourcePosition;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.declaration.ASTBasedAnnotationElementDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.AnnotationElementDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.AnnotationMirrorImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.SourcePositionImpl;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.compiler.util.Util;

public class AnnotationValueImpl
implements EclipseMirrorObject,
AnnotationValue {
    private EclipseMirrorObject _parent;
    private final BaseProcessorEnv _env;
    private final Object _value;
    private final String _name;
    private final int _index;

    public AnnotationValueImpl(Object value, int index, AnnotationElementDeclarationImpl element, BaseProcessorEnv env) {
        this._value = value;
        this._env = env;
        this._parent = element;
        this._name = null;
        this._index = index;
        assert (this._env != null) : "missing environment";
        assert (this._parent != null) : "missing element";
    }

    public AnnotationValueImpl(Object value, String name, int index, AnnotationMirrorImpl annotation, BaseProcessorEnv env) {
        assert (value != null) : "value is null";
        this._value = value;
        this._env = env;
        this._parent = annotation;
        this._name = name;
        this._index = index;
        assert (this._env != null) : "missing environment";
        assert (this._parent != null) : "missing element";
    }

    @Override
    public SourcePosition getPosition() {
        ArrayInitializer arrayInit;
        List exprs;
        EclipseMirrorObject.MirrorKind kind = this._parent.kind();
        ASTNode astNode = null;
        switch (kind) {
            case ANNOTATION_MIRROR: {
                AnnotationMirrorImpl anno = (AnnotationMirrorImpl)this._parent;
                astNode = anno.getASTNodeForElement(this._name);
                break;
            }
            case ANNOTATION_ELEMENT: {
                AnnotationElementDeclarationImpl element = (AnnotationElementDeclarationImpl)this._parent;
                astNode = element.getAstNodeForDefault();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (astNode == null) {
            return null;
        }
        if (this._index >= 0 && astNode.getNodeType() == 4 && (exprs = (arrayInit = (ArrayInitializer)astNode).expressions()) != null && this._index < exprs.size()) {
            astNode = (ASTNode)exprs.get(this._index);
        }
        if (astNode == null) {
            return null;
        }
        CompilationUnit unit = this.getCompilationUnit();
        if (unit == null) {
            return null;
        }
        int offset = astNode.getStartPosition();
        return new SourcePositionImpl(astNode.getStartPosition(), astNode.getLength(), unit.getLineNumber(offset), unit.getColumnNumber(offset), this);
    }

    CompilationUnit getCompilationUnit() {
        EclipseMirrorObject.MirrorKind kind = this._parent.kind();
        switch (kind) {
            case ANNOTATION_MIRROR: {
                return ((AnnotationMirrorImpl)this._parent).getCompilationUnit();
            }
            case ANNOTATION_ELEMENT: {
                if (((EclipseDeclarationImpl)this._parent).isBindingBased()) {
                    return ((AnnotationElementDeclarationImpl)this._parent).getCompilationUnit();
                }
                return ((ASTBasedAnnotationElementDeclarationImpl)this._parent).getCompilationUnit();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isFromSource() {
        EclipseMirrorObject.MirrorKind kind = this._parent.kind();
        switch (kind) {
            case ANNOTATION_MIRROR: {
                return ((AnnotationMirrorImpl)this._parent).isFromSource();
            }
            case ANNOTATION_ELEMENT: {
                if (((EclipseDeclarationImpl)this._parent).isBindingBased()) {
                    return ((AnnotationElementDeclarationImpl)this._parent).isFromSource();
                }
                return ((ASTBasedAnnotationElementDeclarationImpl)this._parent).isFromSource();
            }
        }
        throw new IllegalStateException();
    }

    public IFile getResource() {
        EclipseMirrorObject.MirrorKind kind = this._parent.kind();
        switch (kind) {
            case ANNOTATION_MIRROR: {
                return ((AnnotationMirrorImpl)this._parent).getResource();
            }
            case ANNOTATION_ELEMENT: {
                if (((EclipseDeclarationImpl)this._parent).isBindingBased()) {
                    return ((AnnotationElementDeclarationImpl)this._parent).getResource();
                }
                return ((ASTBasedAnnotationElementDeclarationImpl)this._parent).getResource();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.ANNOTATION_VALUE;
    }

    @Override
    public BaseProcessorEnv getEnvironment() {
        return this._env;
    }

    @Override
    public String toString() {
        if (this._value == null) {
            return "null";
        }
        if (this._value instanceof String) {
            String value = (String)this._value;
            StringBuffer sb = new StringBuffer();
            sb.append('\"');
            int i = 0;
            while (i < value.length()) {
                Util.appendEscapedChar((StringBuffer)sb, (char)value.charAt(i), (boolean)true);
                ++i;
            }
            sb.append('\"');
            return sb.toString();
        }
        if (this._value instanceof Character) {
            StringBuffer sb = new StringBuffer();
            sb.append('\'');
            Util.appendEscapedChar((StringBuffer)sb, (char)((Character)this._value).charValue(), (boolean)false);
            sb.append('\'');
            return sb.toString();
        }
        if (this._value instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumDecl = (EnumConstantDeclaration)this._value;
            return enumDecl.getDeclaringType().toString() + "." + enumDecl.getSimpleName();
        }
        if (this._value instanceof Collection) {
            Collection values = (Collection)this._value;
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            boolean first = true;
            for (AnnotationValue annoValue : values) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(annoValue.toString());
            }
            sb.append('}');
            return sb.toString();
        }
        if (this._value instanceof TypeMirror) {
            return this._value.toString() + ".class";
        }
        return this._value.toString();
    }
}

