/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.corrections.QuickFixProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.RefactorProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.NewAnnotationMemberProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.NewCUProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.NewMethodCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.NewVariableCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.ConfigurationHandler;
import org.eclipse.jdt.ls.core.internal.handlers.ResponseStore;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.AssignToVariableAssistCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.CUCorrectionCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.CodeActionComparator;
import org.eclipse.jdt.ls.core.internal.text.correction.NonProjectFixProcessor;
import org.eclipse.jdt.ls.core.internal.text.correction.QuickAssistProcessor;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactoringCorrectionCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CodeActionHandler {
    public static final ResponseStore<Either<ChangeCorrectionProposal, CodeActionProposal>> codeActionStore = new ResponseStore(ForkJoinPool.commonPool().getParallelism());
    public static final String COMMAND_ID_APPLY_EDIT = "java.apply.workspaceEdit";
    private QuickFixProcessor quickFixProcessor;
    private RefactorProcessor refactorProcessor;
    private QuickAssistProcessor quickAssistProcessor;
    private SourceAssistProcessor sourceAssistProcessor;
    private NonProjectFixProcessor nonProjectFixProcessor;
    private PreferenceManager preferenceManager;

    public CodeActionHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
        this.quickFixProcessor = new QuickFixProcessor();
        this.sourceAssistProcessor = new SourceAssistProcessor(preferenceManager);
        this.quickAssistProcessor = new QuickAssistProcessor(preferenceManager);
        this.refactorProcessor = new RefactorProcessor(preferenceManager);
        this.nonProjectFixProcessor = new NonProjectFixProcessor(preferenceManager);
    }

    public List<Either<Command, CodeAction>> getCodeActionCommands(CodeActionParams params, IProgressMonitor monitor) {
        CompilationUnit astRoot;
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        Map<String, Object> formattingOptions = ConfigurationHandler.getFormattingOptions(params.getTextDocument().getUri());
        if (formattingOptions != null && !formattingOptions.isEmpty()) {
            Object tabSizeValue = formattingOptions.get("java.format.tabSize");
            Object insertSpacesValue = formattingOptions.get("java.format.insertSpaces");
            HashMap<String, String> customOptions = new HashMap<String, String>();
            if (tabSizeValue != null) {
                try {
                    int tabSize = Integer.parseInt(String.valueOf(tabSizeValue));
                    if (tabSize > 0) {
                        customOptions.put("org.eclipse.jdt.core.formatter.tabulation.size", Integer.toString(tabSize));
                    }
                }
                catch (Exception tabSize) {
                    // empty catch block
                }
            }
            if (insertSpacesValue != null) {
                boolean insertSpaces = Boolean.parseBoolean(String.valueOf(insertSpacesValue));
                customOptions.put("org.eclipse.jdt.core.formatter.tabulation.char", insertSpaces ? "space" : "tab");
            }
            if (!customOptions.isEmpty()) {
                unit.setOptions(customOptions);
            }
        }
        if ((astRoot = CodeActionHandler.getASTRoot(unit, monitor)) == null || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        InnovationContext context = CodeActionHandler.getContext(unit, astRoot, params.getRange());
        List<Diagnostic> diagnostics = params.getContext().getDiagnostics().stream().filter(d -> "Java".equals(d.getSource())).collect(Collectors.toList());
        IProblemLocationCore[] locations = CodeActionHandler.getProblemLocationCores(unit, diagnostics);
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ArrayList<String> codeActionKinds = new ArrayList<String>();
        if (params.getContext().getOnly() != null && !params.getContext().getOnly().isEmpty()) {
            codeActionKinds.addAll(params.getContext().getOnly());
        } else {
            List<String> defaultCodeActionKinds = Arrays.asList("quickfix", "refactor", "quickassist", "source");
            codeActionKinds.addAll(defaultCodeActionKinds);
        }
        ArrayList<Either<Command, CodeAction>> codeActions = new ArrayList<Either<Command, CodeAction>>();
        ArrayList<ChangeCorrectionProposal> proposals = new ArrayList<ChangeCorrectionProposal>();
        ChangeCorrectionProposalComparator comparator = new ChangeCorrectionProposalComparator();
        if (CodeActionHandler.containsKind(codeActionKinds, "quickfix")) {
            try {
                codeActions.addAll(this.nonProjectFixProcessor.getCorrections(params, context, locations));
                List<ChangeCorrectionProposal> quickfixProposals = this.quickFixProcessor.getCorrections(params, context, locations);
                this.quickFixProcessor.addAddAllMissingImportsProposal(context, quickfixProposals);
                TreeSet<ChangeCorrectionProposal> quickSet = new TreeSet<ChangeCorrectionProposal>(comparator);
                quickSet.addAll(quickfixProposals);
                proposals.addAll(quickSet);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem resolving quick fix code actions", e);
            }
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (CodeActionHandler.containsKind(codeActionKinds, "refactor")) {
            try {
                List<ChangeCorrectionProposal> refactorProposals = this.refactorProcessor.getProposals(params, context, locations);
                refactorProposals.sort(comparator);
                proposals.addAll(refactorProposals);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem resolving refactor code actions", e);
            }
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (CodeActionHandler.containsKind(codeActionKinds, "quickassist")) {
            try {
                List<ChangeCorrectionProposal> quickassistProposals = this.quickAssistProcessor.getAssists(params, context, locations);
                quickassistProposals.sort(comparator);
                proposals.addAll(quickassistProposals);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem resolving quick assist code actions", e);
            }
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        try {
            for (ChangeCorrectionProposal proposal : proposals) {
                Optional<Either<Command, CodeAction>> codeActionFromProposal = this.getCodeActionFromProposal(params.getTextDocument().getUri(), proposal, params.getContext());
                if (!codeActionFromProposal.isPresent() || codeActions.contains(codeActionFromProposal.get())) continue;
                codeActions.add(codeActionFromProposal.get());
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem converting proposal to code actions", e);
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (CodeActionHandler.containsKind(codeActionKinds, "source")) {
            codeActions.addAll(this.sourceAssistProcessor.getSourceActionCommands(params, context, locations, monitor));
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        codeActions.sort(new CodeActionComparator());
        this.populateDataFields(codeActions);
        return codeActions;
    }

    private void populateDataFields(List<Either<Command, CodeAction>> codeActions) {
        ResponseStore.ResponseItem<Either<ChangeCorrectionProposal, CodeActionProposal>> response = codeActionStore.createResponse();
        ArrayList proposals = new ArrayList();
        codeActions.forEach(action -> {
            if (action.isRight()) {
                void codeActionData;
                Object originalProposal;
                Either proposal = null;
                Object originalData = ((CodeAction)action.getRight()).getData();
                Object object = originalData;
                if (!(object instanceof CodeActionData)) {
                    ((CodeAction)action.getRight()).setData(null);
                    return;
                }
                CodeActionData codeActionData2 = (CodeActionData)object;
                CodeActionData cfr_ignored_0 = (CodeActionData)object;
                Object object2 = originalProposal = codeActionData.getProposal();
                if (object2 instanceof ChangeCorrectionProposal) {
                    void changeCorrectionProposal;
                    ChangeCorrectionProposal changeCorrectionProposal2 = (ChangeCorrectionProposal)((Object)((Object)object2));
                    ChangeCorrectionProposal cfr_ignored_1 = (ChangeCorrectionProposal)((Object)((Object)object2));
                    proposal = Either.forLeft((Object)changeCorrectionProposal);
                } else {
                    void codeActionProposal;
                    Object object3 = originalProposal;
                    if (!(object3 instanceof CodeActionProposal)) {
                        ((CodeAction)action.getRight()).setData(null);
                        return;
                    }
                    CodeActionProposal codeActionProposal2 = (CodeActionProposal)object3;
                    CodeActionProposal cfr_ignored_2 = (CodeActionProposal)object3;
                    proposal = Either.forRight((Object)codeActionProposal);
                }
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("rid", String.valueOf(response.getId()));
                data.put("pid", String.valueOf(proposals.size()));
                ((CodeAction)action.getRight()).setData(data);
                proposals.add(proposal);
            }
        });
        if (!proposals.isEmpty()) {
            response.setProposals(proposals);
            codeActionStore.store(response);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Optional<Either<Command, CodeAction>> getCodeActionFromProposal(String uri, ChangeCorrectionProposal proposal, CodeActionContext context) throws CoreException {
        String name = proposal.getName();
        Command command = null;
        ChangeCorrectionProposal changeCorrectionProposal = proposal;
        if (changeCorrectionProposal instanceof CUCorrectionCommandProposal) {
            void commandProposal;
            CUCorrectionCommandProposal cUCorrectionCommandProposal = (CUCorrectionCommandProposal)changeCorrectionProposal;
            CUCorrectionCommandProposal cfr_ignored_0 = (CUCorrectionCommandProposal)changeCorrectionProposal;
            command = new Command(name, commandProposal.getCommand(), commandProposal.getCommandArguments());
        } else {
            ChangeCorrectionProposal changeCorrectionProposal2 = proposal;
            if (changeCorrectionProposal2 instanceof RefactoringCorrectionCommandProposal) {
                void commandProposal;
                RefactoringCorrectionCommandProposal refactoringCorrectionCommandProposal = (RefactoringCorrectionCommandProposal)changeCorrectionProposal2;
                RefactoringCorrectionCommandProposal cfr_ignored_1 = (RefactoringCorrectionCommandProposal)changeCorrectionProposal2;
                command = new Command(name, commandProposal.getCommand(), commandProposal.getCommandArguments());
            } else {
                ChangeCorrectionProposal changeCorrectionProposal3 = proposal;
                if (changeCorrectionProposal3 instanceof AssignToVariableAssistCommandProposal) {
                    void commandProposal;
                    AssignToVariableAssistCommandProposal assignToVariableAssistCommandProposal = (AssignToVariableAssistCommandProposal)changeCorrectionProposal3;
                    AssignToVariableAssistCommandProposal cfr_ignored_2 = (AssignToVariableAssistCommandProposal)changeCorrectionProposal3;
                    command = new Command(name, commandProposal.getCommand(), commandProposal.getCommandArguments());
                } else if (!this.preferenceManager.getClientPreferences().isResolveCodeActionSupported()) {
                    WorkspaceEdit edit = ChangeUtil.convertToWorkspaceEdit(proposal.getChange());
                    if (!ChangeUtil.hasChanges(edit)) {
                        return Optional.empty();
                    }
                    command = new Command(name, COMMAND_ID_APPLY_EDIT, Collections.singletonList(edit));
                }
            }
        }
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind(proposal.getKind())) {
            CodeAction codeAction = new CodeAction(name);
            codeAction.setKind(proposal.getKind());
            if (command == null) {
                if (!this.preferenceManager.getPreferences().isValidateAllOpenBuffersOnChanges() && (proposal instanceof NewCUProposal || proposal instanceof NewMethodCorrectionProposal || proposal instanceof NewAnnotationMemberProposal || proposal instanceof NewVariableCorrectionProposal)) {
                    codeAction.setCommand(new Command("refresh Diagnostics", "java.project.refreshDiagnostics", Arrays.asList(uri, "thisFile", false, true)));
                }
                codeAction.setData((Object)new CodeActionData((Object)proposal, -proposal.getRelevance()));
            } else {
                codeAction.setCommand(command);
                codeAction.setData((Object)new CodeActionData(null, -proposal.getRelevance()));
            }
            if (proposal.getKind() != "quickassist") {
                codeAction.setDiagnostics(context.getDiagnostics());
            }
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.ofNullable(command != null ? Either.forLeft((Object)command) : null);
    }

    /*
     * WARNING - void declaration
     */
    public static IProblemLocationCore[] getProblemLocationCores(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        IProblemLocationCore[] locations = new IProblemLocationCore[diagnostics.size()];
        int i = 0;
        while (i < diagnostics.size()) {
            Diagnostic diagnostic = diagnostics.get(i);
            int start = DiagnosticsHelper.getStartOffset(unit, diagnostic.getRange());
            int end = DiagnosticsHelper.getEndOffset(unit, diagnostic.getRange());
            boolean isError = diagnostic.getSeverity() == DiagnosticSeverity.Error;
            int problemId = CodeActionHandler.getProblemId(diagnostic);
            ArrayList<String> arguments = new ArrayList<String>();
            Object object = diagnostic.getData();
            if (object instanceof JsonArray) {
                void data;
                JsonArray cfr_ignored_0 = (JsonArray)object;
                JsonArray cfr_ignored_1 = (JsonArray)object;
                for (JsonElement e : data) {
                    arguments.add(e.getAsString());
                }
            }
            locations[i] = new ProblemLocationCore(start, end - start, problemId, arguments.toArray(new String[0]), isError, "org.eclipse.jdt.core.problem");
            ++i;
        }
        return locations;
    }

    private static int getProblemId(Diagnostic diagnostic) {
        int $ = 0;
        try {
            Either code = diagnostic.getCode();
            if (code != null) {
                if (code.getLeft() != null) {
                    $ = Integer.parseInt((String)code.getLeft());
                } else if (code.getRight() != null) {
                    $ = (Integer)code.getRight();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return $;
    }

    public static CompilationUnit getASTRoot(ICompilationUnit unit) {
        return CodeActionHandler.getASTRoot(unit, (IProgressMonitor)new NullProgressMonitor());
    }

    public static CompilationUnit getASTRoot(ICompilationUnit unit, IProgressMonitor monitor) {
        return CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
    }

    public static InnovationContext getContext(ICompilationUnit unit, CompilationUnit astRoot, Range range) {
        int start = DiagnosticsHelper.getStartOffset(unit, range);
        int end = DiagnosticsHelper.getEndOffset(unit, range);
        InnovationContext context = new InnovationContext(unit, start, end - start);
        context.setASTRoot(astRoot);
        return context;
    }

    private static boolean containsKind(List<String> codeActionKinds, String baseKind) {
        return codeActionKinds.stream().anyMatch(kind -> kind.startsWith(baseKind));
    }

    private static class ChangeCorrectionProposalComparator
    implements Comparator<ChangeCorrectionProposal> {
        private ChangeCorrectionProposalComparator() {
        }

        @Override
        public int compare(ChangeCorrectionProposal p1, ChangeCorrectionProposal p2) {
            String k1 = p1.getKind();
            String k2 = p2.getKind();
            if (!(StringUtils.isBlank((CharSequence)k1) || StringUtils.isBlank((CharSequence)k2) || k1.equals(k2))) {
                return k1.compareTo(k2);
            }
            int r1 = p1.getRelevance();
            int r2 = p2.getRelevance();
            int relevanceDif = r2 - r1;
            if (relevanceDif != 0) {
                return relevanceDif;
            }
            return p1.getName().compareToIgnoreCase(p2.getName());
        }
    }

    public static class CodeActionData {
        private final Object proposal;
        private final int priority;

        public CodeActionData(Object proposal) {
            this.proposal = proposal;
            this.priority = CodeActionComparator.LOWEST_PRIORITY;
        }

        public CodeActionData(Object proposal, int priority) {
            this.proposal = proposal;
            this.priority = priority;
        }

        public Object getProposal() {
            return this.proposal;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

