/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CastCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeMethodSignatureProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ImplementInterfaceProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.NewVariableCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.TypeChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;

public class TypeMismatchSubProcessor {
    private TypeMismatchSubProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    public static void addTypeMismatchProposals(IInvocationContext context, IProblemLocationCore problem, Collection<ChangeCorrectionProposal> proposals) throws CoreException {
        BodyDeclaration decl;
        BodyDeclaration bodyDeclaration;
        boolean nullOrVoid;
        Expression expression;
        Expression leftHandSide;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        AST ast = astRoot.getAST();
        ASTNode selectedNode = problem.getCoveredNode(astRoot);
        if (!(selectedNode instanceof Expression)) {
            return;
        }
        Expression nodeToCast = (Expression)selectedNode;
        SimpleName receiverNode = null;
        ITypeBinding castTypeBinding = null;
        int parentNodeType = selectedNode.getParent().getNodeType();
        if (parentNodeType == 7) {
            Assignment assign = (Assignment)selectedNode.getParent();
            leftHandSide = assign.getLeftHandSide();
            if (selectedNode.equals((Object)leftHandSide)) {
                nodeToCast = assign.getRightHandSide();
            }
            castTypeBinding = assign.getLeftHandSide().resolveTypeBinding();
            Expression expression2 = leftHandSide;
            if (expression2 instanceof Name) {
                void name;
                Name name2 = (Name)expression2;
                Name cfr_ignored_0 = (Name)expression2;
                receiverNode = name;
            } else {
                Expression expression3 = leftHandSide;
                if (expression3 instanceof FieldAccess) {
                    void fieldAccess;
                    FieldAccess fieldAccess2 = (FieldAccess)expression3;
                    FieldAccess cfr_ignored_1 = (FieldAccess)expression3;
                    receiverNode = fieldAccess.getName();
                }
            }
        } else if (parentNodeType == 59) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)selectedNode.getParent();
            if (selectedNode.equals((Object)frag.getName()) || selectedNode.equals((Object)frag.getInitializer())) {
                nodeToCast = frag.getInitializer();
                castTypeBinding = ASTNodes.getType((VariableDeclaration)frag).resolveBinding();
                receiverNode = frag.getName();
            }
        } else if (parentNodeType == 80) {
            receiverNode = ((MemberValuePair)selectedNode.getParent()).getName();
            castTypeBinding = ASTResolving.guessBindingForReference((ASTNode)nodeToCast);
        } else if (parentNodeType == 79) {
            receiverNode = ((SingleMemberAnnotation)selectedNode.getParent()).getTypeName();
            castTypeBinding = ASTResolving.guessBindingForReference((ASTNode)nodeToCast);
        } else {
            castTypeBinding = ASTResolving.guessBindingForReference((ASTNode)nodeToCast);
        }
        if (castTypeBinding == null) {
            return;
        }
        ITypeBinding currBinding = nodeToCast.resolveTypeBinding();
        if (currBinding == null && (expression = nodeToCast) instanceof MethodInvocation) {
            void methodInvocation;
            leftHandSide = (MethodInvocation)expression;
            MethodInvocation cfr_ignored_2 = (MethodInvocation)expression;
            IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
            if (methodBinding != null) {
                currBinding = methodBinding.getReturnType();
            }
        }
        if (!(nodeToCast instanceof ArrayInitializer)) {
            ITypeBinding boxUnboxedTypeBinding;
            ITypeBinding castFixType = null;
            if (currBinding == null || castTypeBinding.isCastCompatible(currBinding) || nodeToCast instanceof CastExpression) {
                castFixType = castTypeBinding;
            } else if (JavaModelUtil.is50OrHigher((IJavaProject)cu.getJavaProject()) && (boxUnboxedTypeBinding = TypeMismatchSubProcessor.boxUnboxPrimitives(castTypeBinding, currBinding, ast)) != castTypeBinding && boxUnboxedTypeBinding.isCastCompatible(currBinding)) {
                castFixType = boxUnboxedTypeBinding;
            }
            if (castFixType != null) {
                proposals.add(TypeMismatchSubProcessor.createCastProposal(context, castFixType, nodeToCast, 7));
            }
        }
        boolean bl = nullOrVoid = currBinding == null || "void".equals(currBinding.getName());
        if (!nullOrVoid && parentNodeType == 41 && (bodyDeclaration = (decl = ASTResolving.findParentBodyDeclaration((ASTNode)selectedNode))) instanceof MethodDeclaration) {
            void methodDeclaration;
            MethodDeclaration methodDeclaration2 = (MethodDeclaration)bodyDeclaration;
            MethodDeclaration cfr_ignored_3 = (MethodDeclaration)bodyDeclaration;
            currBinding = Bindings.normalizeTypeBinding((ITypeBinding)currBinding);
            if (currBinding == null) {
                currBinding = ast.resolveWellKnownType("java.lang.Object");
            }
            if (currBinding.isWildcardType()) {
                currBinding = ASTResolving.normalizeWildcardType((ITypeBinding)currBinding, (boolean)true, (AST)ast);
            }
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturntype_description, BasicElementLabels.getJavaElementName((String)currBinding.getName()));
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, "quickfix", cu, rewrite, 6);
            ImportRewrite imports = proposal.createImportRewrite(astRoot);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)decl, imports);
            Type newReturnType = imports.addImport(currBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.RETURN_TYPE);
            rewrite.replace((ASTNode)methodDeclaration.getReturnType2(), (ASTNode)newReturnType, null);
            proposals.add(proposal);
        }
        if (!nullOrVoid && receiverNode != null) {
            if ((currBinding = Bindings.normalizeTypeBinding((ITypeBinding)currBinding)) == null) {
                currBinding = ast.resolveWellKnownType("java.lang.Object");
            }
            if (currBinding.isWildcardType()) {
                currBinding = ASTResolving.normalizeWildcardType((ITypeBinding)currBinding, (boolean)true, (AST)ast);
            }
            TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, (Expression)receiverNode, currBinding, true, 6, proposals);
        }
        TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, nodeToCast, castTypeBinding, false, 5, proposals);
        if (castTypeBinding == ast.resolveWellKnownType("boolean") && currBinding != null && !currBinding.isPrimitive() && !Bindings.isVoidType((ITypeBinding)currBinding)) {
            String label = CorrectionMessages.TypeMismatchSubProcessor_insertnullcheck_description;
            ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
            InfixExpression expression4 = ast.newInfixExpression();
            expression4.setLeftOperand((Expression)rewrite.createMoveTarget((ASTNode)nodeToCast));
            expression4.setRightOperand((Expression)ast.newNullLiteral());
            expression4.setOperator(InfixExpression.Operator.NOT_EQUALS);
            rewrite.replace((ASTNode)nodeToCast, (ASTNode)expression4, null);
            proposals.add(new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 2));
        }
    }

    public static ITypeBinding boxUnboxPrimitives(ITypeBinding castType, ITypeBinding toCast, AST ast) {
        if (castType.isPrimitive() && !toCast.isPrimitive()) {
            return Bindings.getBoxedTypeBinding((ITypeBinding)castType, (AST)ast);
        }
        if (!castType.isPrimitive() && toCast.isPrimitive()) {
            return Bindings.getUnboxedTypeBinding((ITypeBinding)castType, (AST)ast);
        }
        return castType;
    }

    /*
     * WARNING - void declaration
     */
    public static void addChangeSenderTypeProposals(IInvocationContext context, Expression nodeToCast, ITypeBinding castTypeBinding, boolean isAssignedNode, int relevance, Collection<ChangeCorrectionProposal> proposals) throws JavaModelException {
        IBinding callerBinding = Bindings.resolveExpressionBinding((Expression)nodeToCast, (boolean)false);
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ICompilationUnit targetCu = null;
        ITypeBinding declaringType = null;
        IBinding callerBindingDecl = callerBinding;
        IBinding iBinding = callerBinding;
        if (iBinding instanceof IVariableBinding) {
            void variableBinding;
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            IVariableBinding cfr_ignored_0 = (IVariableBinding)iBinding;
            if (variableBinding.isEnumConstant()) {
                return;
            }
            if (!variableBinding.isField()) {
                targetCu = cu;
            } else {
                callerBindingDecl = variableBinding.getVariableDeclaration();
                ITypeBinding declaringClass = variableBinding.getDeclaringClass();
                if (declaringClass == null) {
                    return;
                }
                declaringType = declaringClass.getTypeDeclaration();
            }
        } else {
            IBinding iBinding2 = callerBinding;
            if (iBinding2 instanceof IMethodBinding) {
                void methodBinding;
                IMethodBinding declaringClass = (IMethodBinding)iBinding2;
                IMethodBinding cfr_ignored_1 = (IMethodBinding)iBinding2;
                if (!methodBinding.isConstructor()) {
                    declaringType = methodBinding.getDeclaringClass().getTypeDeclaration();
                    callerBindingDecl = methodBinding.getMethodDeclaration();
                }
            } else {
                IBinding iBinding3 = callerBinding;
                if (iBinding3 instanceof ITypeBinding) {
                    void typeBinding;
                    ITypeBinding iTypeBinding = (ITypeBinding)iBinding3;
                    ITypeBinding cfr_ignored_2 = (ITypeBinding)iBinding3;
                    if (nodeToCast.getLocationInParent() == SingleMemberAnnotation.TYPE_NAME_PROPERTY && (callerBindingDecl = Bindings.findMethodInType((ITypeBinding)(declaringType = typeBinding), (String)"value", null)) == null) {
                        return;
                    }
                }
            }
        }
        if (declaringType != null && declaringType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)declaringType);
        }
        if (targetCu != null && ASTResolving.isUseableTypeInContext((ITypeBinding)castTypeBinding, (IBinding)callerBindingDecl, (boolean)false)) {
            proposals.add(new TypeChangeCorrectionProposal(targetCu, callerBindingDecl, astRoot, castTypeBinding, isAssignedNode, relevance));
        }
        if (!isAssignedNode) {
            ITypeBinding typeDecl;
            ICompilationUnit nodeCu;
            ITypeBinding nodeType = nodeToCast.resolveTypeBinding();
            if (castTypeBinding.isInterface() && nodeType != null && nodeType.isClass() && !nodeType.isAnonymous() && nodeType.isFromSource() && (nodeCu = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)(typeDecl = nodeType.getTypeDeclaration()))) != null && ASTResolving.isUseableTypeInContext((ITypeBinding)castTypeBinding, (IBinding)typeDecl, (boolean)true)) {
                proposals.add(new ImplementInterfaceProposal(nodeCu, typeDecl, astRoot, castTypeBinding, relevance - 1));
            }
        }
    }

    public static ASTRewriteCorrectionProposal createCastProposal(IInvocationContext context, ITypeBinding castTypeBinding, Expression nodeToCast, int relevance) {
        ICompilationUnit cu = context.getCompilationUnit();
        String castType = BindingLabelProviderCore.getBindingLabel((IBinding)castTypeBinding, (long)JavaElementLabels.ALL_DEFAULT);
        String label = nodeToCast.getNodeType() == 11 ? Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changecast_description, castType) : Messages.format(CorrectionMessages.TypeMismatchSubProcessor_addcast_description, castType);
        return new CastCorrectionProposal(label, cu, nodeToCast, castTypeBinding, relevance);
    }

    public static void addIncompatibleReturnTypeProposals(IInvocationContext context, IProblemLocationCore problem, Collection<ChangeCorrectionProposal> proposals) throws JavaModelException {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        MethodDeclaration decl = ASTResolving.findParentMethodDeclaration((ASTNode)selectedNode);
        if (decl == null) {
            return;
        }
        IMethodBinding methodDeclBinding = decl.resolveBinding();
        if (methodDeclBinding == null) {
            return;
        }
        ITypeBinding returnType = methodDeclBinding.getReturnType();
        IMethodBinding overridden = Bindings.findOverriddenMethod((IMethodBinding)methodDeclBinding, (boolean)false);
        if (overridden == null || overridden.getReturnType() == returnType) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        IMethodBinding methodDecl = methodDeclBinding.getMethodDeclaration();
        ITypeBinding overriddenReturnType = overridden.getReturnType();
        if (!JavaModelUtil.is50OrHigher((IJavaProject)context.getCompilationUnit().getJavaProject())) {
            overriddenReturnType = overriddenReturnType.getErasure();
        }
        proposals.add(new TypeChangeCorrectionProposal(cu, (IBinding)methodDecl, astRoot, overriddenReturnType, false, 8));
        ICompilationUnit targetCu = cu;
        IMethodBinding overriddenDecl = overridden.getMethodDeclaration();
        ITypeBinding overridenDeclType = overriddenDecl.getDeclaringClass();
        if (overridenDeclType.isFromSource() && (targetCu = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)overridenDeclType)) != null && ASTResolving.isUseableTypeInContext((ITypeBinding)returnType, (IBinding)overriddenDecl, (boolean)false)) {
            TypeChangeCorrectionProposal proposal = new TypeChangeCorrectionProposal(targetCu, (IBinding)overriddenDecl, astRoot, returnType, false, 7);
            if (overridenDeclType.isInterface()) {
                proposal.setDisplayName(Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturnofimplemented_description, BasicElementLabels.getJavaElementName((String)overriddenDecl.getName())));
            } else {
                proposal.setDisplayName(Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturnofoverridden_description, BasicElementLabels.getJavaElementName((String)overriddenDecl.getName())));
            }
            proposals.add(proposal);
        }
    }

    public static void addIncompatibleThrowsProposals(IInvocationContext context, IProblemLocationCore problem, Collection<ChangeCorrectionProposal> proposals) throws JavaModelException {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration decl = (MethodDeclaration)selectedNode;
        IMethodBinding methodDeclBinding = decl.resolveBinding();
        if (methodDeclBinding == null) {
            return;
        }
        IMethodBinding overridden = Bindings.findOverriddenMethod((IMethodBinding)methodDeclBinding, (boolean)false);
        if (overridden == null) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ITypeBinding[] methodExceptions = methodDeclBinding.getExceptionTypes();
        ITypeBinding[] definedExceptions = overridden.getExceptionTypes();
        ArrayList<ITypeBinding> undeclaredExceptions = new ArrayList<ITypeBinding>();
        ChangeMethodSignatureProposal.ChangeDescription[] changes = new ChangeMethodSignatureProposal.ChangeDescription[methodExceptions.length];
        int i = 0;
        while (i < methodExceptions.length) {
            if (!TypeMismatchSubProcessor.isDeclaredException(methodExceptions[i], definedExceptions)) {
                changes[i] = new ChangeMethodSignatureProposal.RemoveDescription();
                undeclaredExceptions.add(methodExceptions[i]);
            }
            ++i;
        }
        if (undeclaredExceptions.size() == 0) {
            return;
        }
        String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_removeexceptions_description, BasicElementLabels.getJavaElementName((String)methodDeclBinding.getName()));
        proposals.add(new ChangeMethodSignatureProposal(label, cu, (ASTNode)astRoot, methodDeclBinding, null, changes, 8));
        ITypeBinding declaringType = overridden.getDeclaringClass();
        ICompilationUnit targetCu = null;
        if (declaringType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)declaringType);
        }
        if (targetCu != null) {
            ChangeMethodSignatureProposal.ChangeDescription[] changes2 = new ChangeMethodSignatureProposal.ChangeDescription[definedExceptions.length + undeclaredExceptions.size()];
            int i2 = 0;
            while (i2 < undeclaredExceptions.size()) {
                changes2[i2 + definedExceptions.length] = new ChangeMethodSignatureProposal.InsertDescription((ITypeBinding)undeclaredExceptions.get(i2), "");
                ++i2;
            }
            IMethodBinding overriddenDecl = overridden.getMethodDeclaration();
            Object[] args = new String[]{BasicElementLabels.getJavaElementName((String)declaringType.getName()), BasicElementLabels.getJavaElementName((String)overridden.getName())};
            String label2 = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_addexceptions_description, args);
            proposals.add(new ChangeMethodSignatureProposal(label2, targetCu, (ASTNode)astRoot, overriddenDecl, null, changes2, 7));
        }
    }

    private static boolean isDeclaredException(ITypeBinding curr, ITypeBinding[] declared) {
        int i = 0;
        while (i < declared.length) {
            if (Bindings.isSuperType((ITypeBinding)declared[i], (ITypeBinding)curr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void addTypeMismatchInForEachProposals(IInvocationContext context, IProblemLocationCore problem, Collection<ChangeCorrectionProposal> proposals) {
        ITypeBinding expectedBinding;
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null || selectedNode.getLocationInParent() != EnhancedForStatement.EXPRESSION_PROPERTY) {
            return;
        }
        EnhancedForStatement forStatement = (EnhancedForStatement)selectedNode.getParent();
        ITypeBinding expressionBinding = forStatement.getExpression().resolveTypeBinding();
        if (expressionBinding == null) {
            return;
        }
        if (expressionBinding.isArray()) {
            expectedBinding = expressionBinding.getComponentType();
        } else {
            IMethodBinding iteratorMethod = Bindings.findMethodInHierarchy((ITypeBinding)expressionBinding, (String)"iterator", (String[])new String[0]);
            if (iteratorMethod == null) {
                return;
            }
            ITypeBinding[] typeArguments = iteratorMethod.getReturnType().getTypeArguments();
            if (typeArguments.length != 1) {
                return;
            }
            expectedBinding = typeArguments[0];
        }
        AST ast = astRoot.getAST();
        expectedBinding = Bindings.normalizeForDeclarationUse((ITypeBinding)expectedBinding, (AST)ast);
        SingleVariableDeclaration parameter = forStatement.getParameter();
        ICompilationUnit cu = context.getCompilationUnit();
        if (parameter.getName().getLength() == 0) {
            SimpleName simpleName = null;
            Type type = parameter.getType();
            if (type instanceof SimpleType) {
                void type2;
                SimpleType simpleType = (SimpleType)type;
                SimpleType cfr_ignored_0 = (SimpleType)type;
                Name name = type2.getName();
                if (name instanceof SimpleName) {
                    SimpleName simpleName2 = (SimpleName)name;
                    SimpleName cfr_ignored_1 = (SimpleName)name;
                    simpleName = name;
                }
            } else {
                Type type3 = parameter.getType();
                if (type3 instanceof NameQualifiedType) {
                    void type4;
                    name = (NameQualifiedType)type3;
                    NameQualifiedType cfr_ignored_2 = (NameQualifiedType)type3;
                    simpleName = type4.getName();
                }
            }
            if (simpleName != null) {
                String name = simpleName.getIdentifier();
                int relevance = StubUtility.hasLocalVariableName((IJavaProject)cu.getJavaProject(), (String)name) ? 10 : 7;
                String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_create_loop_variable_description, BasicElementLabels.getJavaElementName((String)name));
                proposals.add(new NewVariableCorrectionProposal(label, cu, 1, simpleName, null, relevance));
                return;
            }
        }
        String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_incompatible_for_each_type_description, new String[]{BasicElementLabels.getJavaElementName((String)parameter.getName().getIdentifier()), BindingLabelProviderCore.getBindingLabel((IBinding)expectedBinding, (long)0x200009L)});
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, "quickfix", cu, rewrite, 5);
        ImportRewrite importRewrite = proposal.createImportRewrite(astRoot);
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)ASTResolving.findParentBodyDeclaration((ASTNode)selectedNode), importRewrite);
        Type newType = importRewrite.addImport(expectedBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
        rewrite.replace((ASTNode)parameter.getType(), (ASTNode)newType, null);
        proposals.add(proposal);
    }
}

