/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.DimensionRewrite;
import org.eclipse.jdt.internal.corext.dom.TypeAnnotationRewrite;
import org.eclipse.jdt.internal.corext.fix.TypeParametersFixCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.JavadocTagsSubProcessor;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;

public class TypeChangeCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private final IBinding fBinding;
    private final CompilationUnit fAstRoot;
    private final ITypeBinding fNewType;
    private final ITypeBinding[] fTypeProposals;
    private final ImportRewrite.TypeLocation fTypeLocation;
    private final boolean fIsNewTypeVar;
    private static String VAR_TYPE = "var";

    public TypeChangeCorrectionProposal(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding newType, boolean offerSuperTypeProposals, int relevance) {
        this(targetCU, binding, astRoot, newType, false, offerSuperTypeProposals, relevance);
    }

    public TypeChangeCorrectionProposal(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding oldType, int relevance) {
        this(targetCU, binding, astRoot, oldType, true, false, relevance);
    }

    private TypeChangeCorrectionProposal(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding newType, boolean isNewTypeVar, boolean offerSuperTypeProposals, int relevance) {
        super("", "quickfix", targetCU, (ASTRewrite)null, relevance);
        Assert.isTrue((binding != null && (binding.getKind() == 4 || binding.getKind() == 3) && Bindings.isDeclarationBinding((IBinding)binding) ? 1 : 0) != 0);
        this.fBinding = binding;
        this.fAstRoot = astRoot;
        this.fIsNewTypeVar = isNewTypeVar;
        if (offerSuperTypeProposals) {
            this.fTypeProposals = ASTResolving.getRelaxingTypes((AST)astRoot.getAST(), (ITypeBinding)newType);
            this.sortTypes(this.fTypeProposals);
            this.fNewType = this.fTypeProposals[0];
        } else {
            this.fNewType = !this.fIsNewTypeVar ? newType : null;
            this.fTypeProposals = null;
        }
        String typeName = isNewTypeVar ? VAR_TYPE : BindingLabelProviderCore.getBindingLabel((IBinding)this.fNewType, (long)JavaElementLabels.ALL_DEFAULT);
        if (binding.getKind() == 3) {
            IVariableBinding varBinding = (IVariableBinding)binding;
            Object[] args = new String[]{BasicElementLabels.getJavaElementName((String)varBinding.getName()), BasicElementLabels.getJavaElementName((String)typeName)};
            if (varBinding.isField()) {
                this.fTypeLocation = ImportRewrite.TypeLocation.FIELD;
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_field_name, args));
            } else if (astRoot.findDeclaringNode(binding) instanceof SingleVariableDeclaration) {
                this.fTypeLocation = ImportRewrite.TypeLocation.PARAMETER;
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_param_name, args));
            } else {
                this.fTypeLocation = ImportRewrite.TypeLocation.LOCAL_VARIABLE;
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_variable_name, args));
            }
        } else {
            Object[] args = new String[]{binding.getName(), typeName};
            this.fTypeLocation = ImportRewrite.TypeLocation.RETURN_TYPE;
            this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_method_name, args));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode boundNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        CompilationUnit newRoot = this.fAstRoot;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ImportRewrite imports = this.createImportRewrite(newRoot);
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(newRoot, declNode.getStartPosition(), imports);
            ImportRemover remover = new ImportRemover(this.getCompilationUnit().getJavaProject(), newRoot);
            Object type = this.fIsNewTypeVar ? ast.newSimpleType(ast.newName(VAR_TYPE)) : imports.addImport(this.fNewType, ast, (ImportRewrite.ImportRewriteContext)context, this.fTypeLocation);
            ASTNode aSTNode = declNode;
            if (aSTNode instanceof MethodDeclaration) {
                TagElement returnTag;
                void methodDecl;
                MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode;
                MethodDeclaration cfr_ignored_0 = (MethodDeclaration)aSTNode;
                Type origReturnType = methodDecl.getReturnType2();
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, type, null);
                DimensionRewrite.removeAllChildren((ASTNode)methodDecl, (ChildListPropertyDescriptor)MethodDeclaration.EXTRA_DIMENSIONS2_PROPERTY, (ASTRewrite)rewrite, null);
                TypeAnnotationRewrite.removePureTypeAnnotations((ASTNode)methodDecl, (ChildListPropertyDescriptor)MethodDeclaration.MODIFIERS2_PROPERTY, (ASTRewrite)rewrite, null);
                Javadoc javadoc = methodDecl.getJavadoc();
                if (javadoc != null && origReturnType != null && origReturnType.isPrimitiveType() && ((PrimitiveType)origReturnType).getPrimitiveTypeCode() == PrimitiveType.VOID && (returnTag = JavadocTagsSubProcessor.findTag(javadoc, "@return", null)) == null) {
                    returnTag = ast.newTagElement();
                    returnTag.setTagName("@return");
                    TextElement commentStart = ast.newTextElement();
                    returnTag.fragments().add(commentStart);
                    ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
                    JavadocTagsSubProcessor.insertTag(tagsRewriter, returnTag, null);
                }
            } else {
                ASTNode aSTNode2 = declNode;
                if (aSTNode2 instanceof AnnotationTypeMemberDeclaration) {
                    void methodDecl;
                    AnnotationTypeMemberDeclaration origReturnType = (AnnotationTypeMemberDeclaration)aSTNode2;
                    AnnotationTypeMemberDeclaration cfr_ignored_1 = (AnnotationTypeMemberDeclaration)aSTNode2;
                    rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)AnnotationTypeMemberDeclaration.TYPE_PROPERTY, type, null);
                } else if (declNode instanceof VariableDeclarationFragment) {
                    ASTNode parent = declNode.getParent();
                    ASTNode aSTNode3 = parent;
                    if (aSTNode3 instanceof FieldDeclaration) {
                        ASTNode aSTNode4;
                        void fieldDecl;
                        FieldDeclaration tagsRewriter = (FieldDeclaration)aSTNode3;
                        FieldDeclaration cfr_ignored_2 = (FieldDeclaration)aSTNode3;
                        if (fieldDecl.fragments().size() > 1 && (aSTNode4 = fieldDecl.getParent()) instanceof AbstractTypeDeclaration) {
                            void typeDecl;
                            AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)aSTNode4;
                            AbstractTypeDeclaration cfr_ignored_3 = (AbstractTypeDeclaration)aSTNode4;
                            VariableDeclarationFragment placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                            FieldDeclaration newField = ast.newFieldDeclaration(placeholder);
                            newField.setType((Type)type);
                            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)typeDecl, typeDecl.getBodyDeclarationsProperty());
                            if (fieldDecl.fragments().indexOf(declNode) == 0) {
                                listRewrite.insertBefore((ASTNode)newField, parent, null);
                            } else {
                                listRewrite.insertAfter((ASTNode)newField, parent, null);
                            }
                        } else {
                            rewrite.set((ASTNode)fieldDecl, (StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY, type, null);
                            DimensionRewrite.removeAllChildren((ASTNode)declNode, (ChildListPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, (ASTRewrite)rewrite, null);
                            TypeAnnotationRewrite.removePureTypeAnnotations((ASTNode)fieldDecl, (ChildListPropertyDescriptor)FieldDeclaration.MODIFIERS2_PROPERTY, (ASTRewrite)rewrite, null);
                        }
                    } else {
                        ASTNode aSTNode5 = parent;
                        if (aSTNode5 instanceof VariableDeclarationStatement) {
                            void varDecl;
                            VariableDeclarationStatement typeDecl = (VariableDeclarationStatement)aSTNode5;
                            VariableDeclarationStatement cfr_ignored_4 = (VariableDeclarationStatement)aSTNode5;
                            if (varDecl.fragments().size() > 1 && varDecl.getParent() instanceof Block) {
                                VariableDeclarationFragment placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                                VariableDeclarationStatement newStat = ast.newVariableDeclarationStatement(placeholder);
                                newStat.setType((Type)type);
                                ListRewrite listRewrite = rewrite.getListRewrite(varDecl.getParent(), Block.STATEMENTS_PROPERTY);
                                if (varDecl.fragments().indexOf(declNode) == 0) {
                                    listRewrite.insertBefore((ASTNode)newStat, parent, null);
                                } else {
                                    listRewrite.insertAfter((ASTNode)newStat, parent, null);
                                }
                                if (this.fIsNewTypeVar) {
                                    this.handledInferredParameterizedType((ASTNode)newStat, declNode, ast, rewrite, imports, (ImportRewrite.ImportRewriteContext)context);
                                }
                            } else {
                                Type oldType = (Type)rewrite.get((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY);
                                rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY, type, null);
                                DimensionRewrite.removeAllChildren((ASTNode)declNode, (ChildListPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, (ASTRewrite)rewrite, null);
                                if (this.fIsNewTypeVar) {
                                    this.handledInferredParameterizedType(parent, declNode, ast, rewrite, imports, (ImportRewrite.ImportRewriteContext)context);
                                    TypeAnnotationRewrite.removePureTypeAnnotations((ASTNode)parent, (ChildListPropertyDescriptor)VariableDeclarationStatement.MODIFIERS2_PROPERTY, (ASTRewrite)rewrite, null);
                                    if (oldType != null) {
                                        remover.registerRemovedNode((ASTNode)oldType);
                                    }
                                }
                            }
                        } else {
                            ASTNode aSTNode6 = parent;
                            if (aSTNode6 instanceof VariableDeclarationExpression) {
                                void varDecl;
                                VariableDeclarationExpression oldType = (VariableDeclarationExpression)aSTNode6;
                                VariableDeclarationExpression cfr_ignored_5 = (VariableDeclarationExpression)aSTNode6;
                                Type oldType2 = (Type)rewrite.get((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationExpression.TYPE_PROPERTY);
                                rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationExpression.TYPE_PROPERTY, type, null);
                                DimensionRewrite.removeAllChildren((ASTNode)declNode, (ChildListPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, (ASTRewrite)rewrite, null);
                                if (this.fIsNewTypeVar) {
                                    this.handledInferredParameterizedType(parent, declNode, ast, rewrite, imports, (ImportRewrite.ImportRewriteContext)context);
                                    TypeAnnotationRewrite.removePureTypeAnnotations((ASTNode)parent, (ChildListPropertyDescriptor)VariableDeclarationExpression.MODIFIERS2_PROPERTY, (ASTRewrite)rewrite, null);
                                    if (oldType2 != null) {
                                        remover.registerRemovedNode((ASTNode)oldType2);
                                    }
                                }
                            }
                        }
                    }
                } else {
                    ASTNode aSTNode7 = declNode;
                    if (aSTNode7 instanceof SingleVariableDeclaration) {
                        void variableDeclaration;
                        SingleVariableDeclaration parent = (SingleVariableDeclaration)aSTNode7;
                        SingleVariableDeclaration cfr_ignored_6 = (SingleVariableDeclaration)aSTNode7;
                        Type oldType = (Type)rewrite.get((ASTNode)variableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY);
                        rewrite.set((ASTNode)variableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY, type, null);
                        DimensionRewrite.removeAllChildren((ASTNode)declNode, (ChildListPropertyDescriptor)SingleVariableDeclaration.EXTRA_DIMENSIONS2_PROPERTY, (ASTRewrite)rewrite, null);
                        TypeAnnotationRewrite.removePureTypeAnnotations((ASTNode)declNode, (ChildListPropertyDescriptor)SingleVariableDeclaration.MODIFIERS2_PROPERTY, (ASTRewrite)rewrite, null);
                        if (this.fIsNewTypeVar && oldType != null) {
                            remover.registerRemovedNode((ASTNode)oldType);
                        }
                    }
                }
            }
            return rewrite;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void sortTypes(ITypeBinding[] typeProposals) {
        ITypeBinding oldType;
        IBinding iBinding = this.fBinding;
        if (iBinding instanceof IMethodBinding) {
            void methodBinding;
            IMethodBinding iMethodBinding = (IMethodBinding)iBinding;
            IMethodBinding cfr_ignored_0 = (IMethodBinding)iBinding;
            oldType = methodBinding.getReturnType();
        } else {
            oldType = ((IVariableBinding)this.fBinding).getType();
        }
        if (!oldType.isParameterizedType()) {
            return;
        }
        final ITypeBinding oldTypeDeclaration = oldType.getTypeDeclaration();
        Arrays.sort(typeProposals, new Comparator<ITypeBinding>(){

            @Override
            public int compare(ITypeBinding o1, ITypeBinding o2) {
                return this.rank(o2) - this.rank(o1);
            }

            private int rank(ITypeBinding type) {
                if (type.getTypeDeclaration().equals((Object)oldTypeDeclaration)) {
                    return 1;
                }
                return 0;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void handledInferredParameterizedType(ASTNode node, ASTNode declaringNode, AST ast, ASTRewrite rewrite, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context) {
        ClassInstanceCreation variableDeclFragment;
        Expression expression;
        VariableDeclarationFragment varFrag;
        if (ast == null || rewrite == null || importRewrite == null || context == null) {
            return;
        }
        Expression processNode = null;
        List fragments = null;
        ASTNode aSTNode = node;
        if (aSTNode instanceof VariableDeclarationStatement) {
            void variableDecl;
            VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)aSTNode;
            VariableDeclarationStatement cfr_ignored_0 = (VariableDeclarationStatement)aSTNode;
            fragments = variableDecl.fragments();
        } else {
            ASTNode aSTNode2 = node;
            if (aSTNode2 instanceof VariableDeclarationExpression) {
                void variableDecl;
                VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)aSTNode2;
                VariableDeclarationExpression cfr_ignored_1 = (VariableDeclarationExpression)aSTNode2;
                fragments = variableDecl.fragments();
            }
        }
        if (fragments != null && fragments.size() == 1 && (processNode = (varFrag = (VariableDeclarationFragment)fragments.get(0)).getInitializer()) == null && (expression = declaringNode) instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)expression;
            VariableDeclarationFragment cfr_ignored_2 = (VariableDeclarationFragment)expression;
            processNode = variableDeclFragment.getInitializer();
        }
        ASTNode createdType = null;
        expression = processNode;
        if (expression instanceof ClassInstanceCreation) {
            void creation;
            Type type;
            variableDeclFragment = (ClassInstanceCreation)expression;
            ClassInstanceCreation cfr_ignored_3 = (ClassInstanceCreation)expression;
            Type type2 = type = creation.getType();
            if (type2 instanceof ParameterizedType) {
                void parameterizedType;
                ParameterizedType parameterizedType2 = (ParameterizedType)type2;
                ParameterizedType cfr_ignored_4 = (ParameterizedType)type2;
                createdType = parameterizedType;
            }
        }
        if (createdType == null) {
            return;
        }
        ArrayList changedNodes = new ArrayList();
        node.accept((ASTVisitor)new TypeParametersFixCore.InsertTypeArgumentsVisitor(changedNodes));
        if (changedNodes.isEmpty()) {
            return;
        }
        ITypeBinding binding = createdType.resolveBinding();
        if (binding != null) {
            ITypeBinding[] typeArguments = binding.getTypeArguments();
            ListRewrite argumentsRewrite = rewrite.getListRewrite(createdType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
            int i = 0;
            while (i < typeArguments.length) {
                ITypeBinding typeArgument = typeArguments[i];
                Type argumentNode = importRewrite.addImport(typeArgument, ast, context, ImportRewrite.TypeLocation.TYPE_ARGUMENT);
                argumentsRewrite.insertLast((ASTNode)argumentNode, null);
                ++i;
            }
        }
    }
}

