/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.commands;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;

public class ProjectCommand {
    public static final String VM_LOCATION = "org.eclipse.jdt.ls.core.vm.location";
    public static final String SOURCE_PATHS = "org.eclipse.jdt.ls.core.sourcePaths";
    public static final String OUTPUT_PATH = "org.eclipse.jdt.ls.core.outputPath";
    public static final String REFERENCED_LIBRARIES = "org.eclipse.jdt.ls.core.referencedLibraries";
    private static final String TEST_SCOPE_VALUE = "test";

    public static Map<String, Object> getProjectSettings(String uri, List<String> settingKeys) throws CoreException, URISyntaxException {
        IJavaProject javaProject = ProjectCommand.getJavaProjectFromUri(uri);
        IProject project = javaProject.getProject();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        Iterator<String> iterator = settingKeys.iterator();
        block12: while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "org.eclipse.jdt.ls.core.vm.location": {
                    File location;
                    IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                    if (vmInstall == null || (location = vmInstall.getInstallLocation()) == null) continue block12;
                    settings.putIfAbsent(key, location.getAbsolutePath());
                    break;
                }
                case "org.eclipse.jdt.ls.core.sourcePaths": {
                    String[] sourcePaths = (String[])Arrays.stream(ProjectUtils.listSourcePaths(javaProject)).map(p -> project.getFolder(p.makeRelativeTo(project.getFullPath())).getLocation().toOSString()).toArray(String[]::new);
                    settings.putIfAbsent(key, sourcePaths);
                    break;
                }
                case "org.eclipse.jdt.ls.core.outputPath": {
                    IPath outputPath = javaProject.getOutputLocation();
                    if (outputPath == null) {
                        settings.putIfAbsent(key, "");
                        break;
                    }
                    settings.putIfAbsent(key, project.getFolder(outputPath.makeRelativeTo(project.getFullPath())).getLocation().toOSString());
                    break;
                }
                case "org.eclipse.jdt.ls.core.referencedLibraries": {
                    String[] referencedLibraries = (String[])Arrays.stream(ProjectUtils.listReferencedLibraries(javaProject)).map(p -> p.toOSString()).toArray(String[]::new);
                    settings.putIfAbsent(key, referencedLibraries);
                    break;
                }
                default: {
                    settings.putIfAbsent(key, javaProject.getOption(key, true));
                }
            }
        }
        return settings;
    }

    public static ClasspathResult getClasspaths(String uri, ClasspathOptions options) throws CoreException, URISyntaxException {
        return ProjectCommand.getClasspathsFromJavaProject(ProjectCommand.getJavaProjectFromUri(uri), options);
    }

    public static ClasspathResult getClasspathsFromJavaProject(final IJavaProject javaProject, ClasspathOptions options) throws CoreException, URISyntaxException {
        Optional<IBuildSupport> bs = JavaLanguageServerPlugin.getProjectsManager().getBuildSupport(javaProject.getProject());
        if (!bs.isPresent()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "No BuildSupport for the project: " + javaProject.getElementName()));
        }
        final ILaunchConfiguration launchConfig = bs.get().getLaunchConfiguration(javaProject, options.scope);
        final JavaLaunchDelegate delegate = new JavaLaunchDelegate();
        final ClasspathResult[] result = new ClasspathResult[1];
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ISchedulingRule currentRule = Job.getJobManager().currentRule();
        Object schedulingRule = currentRule != null && currentRule.contains(javaProject.getSchedulingRule()) ? null : javaProject.getSchedulingRule();
        workspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                String[][] paths = delegate.getClasspathAndModulepath(launchConfig);
                result[0] = new ClasspathResult(javaProject.getProject().getLocationURI(), paths[0], paths[1]);
            }
        }, schedulingRule, 1, (IProgressMonitor)new NullProgressMonitor());
        if (result[0] != null) {
            return result[0];
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Failed to get the classpaths."));
    }

    public static boolean isTestFile(String uri) throws CoreException {
        ICompilationUnit compilationUnit = JDTUtils.resolveCompilationUnit(uri);
        if (compilationUnit == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Given URI does not belong to an existing Java source file."));
        }
        IJavaProject javaProject = compilationUnit.getJavaProject();
        if (javaProject == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Given URI does not belong to an existing Java project."));
        }
        if ("jdt.ls-java-project".equals(javaProject.getProject().getName())) {
            return false;
        }
        IPath compilationUnitPath = compilationUnit.getPath();
        IPath[] iPathArray = ProjectCommand.listTestSourcePaths(javaProject);
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath testpath = iPathArray[n2];
            if (testpath.isPrefixOf(compilationUnitPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static List<URI> getAllJavaProjects() {
        LinkedList<URI> javaProjects = new LinkedList<URI>();
        IJavaProject[] iJavaProjectArray = ProjectUtils.getJavaProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            javaProjects.add(ProjectUtils.getProjectRealFolder(javaProject.getProject()).toFile().toURI());
            ++n2;
        }
        return javaProjects;
    }

    public static void importProject(IProgressMonitor monitor) {
        JavaLanguageServerPlugin.getProjectsManager().importProjects(monitor);
    }

    private static IPath[] listTestSourcePaths(IJavaProject project) throws JavaModelException {
        ArrayList<IPath> result = new ArrayList<IPath>();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (ProjectCommand.isTestClasspathEntry(entry)) {
                result.add(entry.getPath());
            }
            ++n2;
        }
        return result.toArray(new IPath[0]);
    }

    private static boolean isTestClasspathEntry(IClasspathEntry entry) {
        if (entry.getEntryKind() != 3) {
            return false;
        }
        if (entry.isTest()) {
            return true;
        }
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            String attributeName = attribute.getName();
            if (attributeName.contains("scope")) {
                return attribute.getValue() != null && attribute.getValue().toLowerCase().contains(TEST_SCOPE_VALUE);
            }
            ++n2;
        }
        return false;
    }

    public static IJavaProject getJavaProjectFromUri(String uri) throws CoreException, URISyntaxException {
        ITypeRoot typeRoot = JDTUtils.resolveTypeRoot(uri);
        if (typeRoot != null) {
            IJavaProject javaProject = typeRoot.getJavaProject();
            if (javaProject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Given URI does not belong to an existing Java project."));
            }
            return javaProject;
        }
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(new URI(uri));
        if (containers == null || containers.length == 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Given URI does not belong to any Java project."));
        }
        Arrays.sort(containers, (a, b) -> a.getFullPath().segmentCount() - b.getFullPath().segmentCount());
        IJavaProject targetElement = null;
        IContainer[] iContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            targetElement = JavaCore.create((IProject)container.getProject());
            if (targetElement != null && targetElement.exists()) break;
            ++n2;
        }
        if (targetElement == null || targetElement.getJavaProject() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Given URI does not belong to any Java project."));
        }
        return targetElement.getJavaProject();
    }

    public static SymbolInformation resolveWorkspaceSymbol(SymbolInformation request) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot(request.getLocation().getUri());
        if (unit == null || !unit.exists()) {
            return null;
        }
        Location location = request.getLocation();
        try {
            ArrayDeque<IJavaElement> children = new ArrayDeque<IJavaElement>(Arrays.asList(unit.getChildren()));
            while (!children.isEmpty()) {
                IJavaElement child = (IJavaElement)children.pop();
                if (!(child instanceof IType)) continue;
                if (request.getName().equals(child.getElementName())) {
                    location = JDTUtils.toLocation(child);
                    break;
                }
                children.addAll(Arrays.asList(((IParent)child).getChildren()));
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logError("Problem resolving symbol information for " + unit.getElementName());
        }
        SymbolInformation si = new SymbolInformation();
        si.setName(request.getName());
        si.setContainerName(request.getContainerName());
        si.setLocation(location);
        si.setKind(request.getKind());
        return si;
    }

    public static class ClasspathOptions {
        public String scope;
    }

    public static class ClasspathResult {
        public URI projectRoot;
        public String[] classpaths;
        public String[] modulepaths;

        public ClasspathResult(URI projectRoot, String[] classpaths, String[] modulepaths) {
            this.projectRoot = projectRoot;
            this.classpaths = classpaths;
            this.modulepaths = modulepaths;
        }
    }
}

