/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.ls.core.internal.IDecompiler;
import org.eclipse.jdt.ls.core.internal.JDTUtils;

public class DisassemblerContentProvider
implements IDecompiler {
    public static final String DISASSEMBLED_HEADER = " // Failed to get sources. Instead, stub sources have been generated by the disassembler.\n // Implementation of methods is unavailable.\n";
    private static final String LF = "\n";

    @Override
    public String getContent(URI uri, IProgressMonitor monitor) throws CoreException {
        IClassFile classFile = JDTUtils.resolveClassFile(uri);
        if (classFile != null) {
            return this.getSource(classFile, monitor);
        }
        try {
            return DisassemblerContentProvider.getContent(Files.readAllBytes(Paths.get(uri)), monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Error opening " + uri, (Throwable)e));
        }
    }

    @Override
    public String getSource(IClassFile classFile, IProgressMonitor monitor) throws CoreException {
        return DisassemblerContentProvider.getContent(classFile.getBytes(), monitor);
    }

    public static String getContent(byte[] bytes, IProgressMonitor monitor) throws CoreException {
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String disassembledByteCode = null;
        try {
            disassembledByteCode = disassembler.disassemble(bytes, LF, 16);
            if (disassembledByteCode != null) {
                disassembledByteCode = DISASSEMBLED_HEADER + disassembledByteCode;
            }
        }
        catch (ClassFormatException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Error disassembling", (Throwable)e));
        }
        return disassembledByteCode;
    }
}

