"use strict";
// *****************************************************************************
// Copyright (C) 2017-2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StatusBarImpl = exports.StatusBarAlignment = exports.StatusBar = void 0;
const React = require("react");
const inversify_1 = require("inversify");
const debounce = require("lodash.debounce");
const common_1 = require("../../common");
const react_widget_1 = require("../widgets/react-widget");
const frontend_application_state_1 = require("../frontend-application-state");
const label_parser_1 = require("../label-parser");
const preferences_1 = require("../preferences");
const status_bar_types_1 = require("./status-bar-types");
Object.defineProperty(exports, "StatusBar", { enumerable: true, get: function () { return status_bar_types_1.StatusBar; } });
Object.defineProperty(exports, "StatusBarAlignment", { enumerable: true, get: function () { return status_bar_types_1.StatusBarAlignment; } });
const status_bar_view_model_1 = require("./status-bar-view-model");
const hover_service_1 = require("../hover-service");
const widgets_1 = require("../widgets");
let StatusBarImpl = class StatusBarImpl extends react_widget_1.ReactWidget {
    constructor(commands, entryService, applicationStateService, preferences, viewModel, hoverService) {
        super();
        this.commands = commands;
        this.entryService = entryService;
        this.applicationStateService = applicationStateService;
        this.preferences = preferences;
        this.viewModel = viewModel;
        this.hoverService = hoverService;
        this.debouncedUpdate = debounce(() => this.update(), 50);
        delete this.scrollOptions;
        this.id = 'theia-statusBar';
        this.addClass('noselect');
        // Hide the status bar until the `workbench.statusBar.visible` preference returns with a `true` value.
        this.hide();
        this.preferences.ready.then(() => {
            const preferenceValue = this.preferences.get('workbench.statusBar.visible', true);
            this.setHidden(!preferenceValue);
        });
        this.toDispose.push(this.preferences.onPreferenceChanged(preference => {
            if (preference.preferenceName === 'workbench.statusBar.visible') {
                this.setHidden(!preference.newValue);
            }
        }));
        this.toDispose.push(this.viewModel.onDidChange(() => this.debouncedUpdate()));
    }
    get ready() {
        return this.applicationStateService.reachedAnyState('initialized_layout', 'ready');
    }
    async setElement(id, entry) {
        await this.ready;
        this.viewModel.set(id, entry);
    }
    async removeElement(id) {
        await this.ready;
        this.viewModel.remove(id);
    }
    async setBackgroundColor(color) {
        await this.ready;
        this.internalSetBackgroundColor(color);
        this.update();
    }
    internalSetBackgroundColor(color) {
        this.backgroundColor = color;
        this.node.style.backgroundColor = this.backgroundColor || '';
    }
    async setColor(color) {
        await this.ready;
        this.internalSetColor(color);
        this.update();
    }
    internalSetColor(color) {
        this.color = color;
    }
    render() {
        const leftEntries = Array.from(this.viewModel.getLeft(), entry => this.renderElement(entry));
        const rightEntries = Array.from(this.viewModel.getRight(), entry => this.renderElement(entry));
        return React.createElement(React.Fragment, null,
            React.createElement("div", { className: 'area left' }, leftEntries),
            React.createElement("div", { className: 'area right' }, rightEntries));
    }
    onclick(entry) {
        return () => {
            if (entry.command) {
                const args = entry.arguments || [];
                this.commands.executeCommand(entry.command, ...args);
            }
        };
    }
    createAttributes(viewEntry) {
        const attrs = {};
        const entry = viewEntry.entry;
        attrs.id = 'status-bar-' + viewEntry.id;
        attrs.className = 'element';
        if (entry.command || entry.onclick || entry.tooltip) {
            attrs.className += ' hasCommand';
        }
        if (entry.command) {
            attrs.onClick = this.onclick(entry);
        }
        else if (entry.onclick) {
            attrs.onClick = e => { var _a; return (_a = entry.onclick) === null || _a === void 0 ? void 0 : _a.call(entry, e.nativeEvent); };
        }
        if (viewEntry.compact && viewEntry.alignment !== undefined) {
            attrs.className += viewEntry.alignment === status_bar_types_1.StatusBarAlignment.RIGHT ? ' compact-right' : ' compact-left';
        }
        if (entry.tooltip) {
            attrs.onMouseEnter = e => this.hoverService.requestHover({
                content: entry.tooltip,
                target: e.currentTarget,
                position: 'top'
            });
        }
        if (entry.className) {
            attrs.className += ' ' + entry.className;
        }
        if (entry.accessibilityInformation) {
            attrs['aria-label'] = entry.accessibilityInformation.label;
            attrs.role = entry.accessibilityInformation.role;
        }
        else {
            attrs['aria-label'] = [entry.text, entry.tooltip].join(', ');
        }
        attrs.style = {
            color: entry.color || this.color,
            backgroundColor: entry.backgroundColor
        };
        return attrs;
    }
    renderElement(entry) {
        const childStrings = this.entryService.parse(entry.entry.text);
        const children = [];
        childStrings.forEach((val, key) => {
            if (!(typeof val === 'string') && label_parser_1.LabelIcon.is(val)) {
                const animation = val.animation ? ` fa-${val.animation}` : '';
                if (val.name.startsWith('codicon-')) {
                    children.push(React.createElement("span", { key: key, className: `codicon ${val.name}${animation}` }));
                }
                else if (val.name.startsWith('fa-')) {
                    children.push(React.createElement("span", { key: key, className: `fa ${val.name}${animation}` }));
                }
                else {
                    children.push(React.createElement("span", { key: key, className: `${(0, widgets_1.codicon)(val.name)}${animation}` }));
                }
            }
            else {
                children.push(React.createElement("span", { key: key }, val));
            }
        });
        const elementInnerDiv = React.createElement(React.Fragment, null, children);
        return React.createElement('div', Object.assign({ key: entry.id }, this.createAttributes(entry)), elementInnerDiv);
    }
};
StatusBarImpl = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(common_1.CommandService)),
    __param(1, (0, inversify_1.inject)(label_parser_1.LabelParser)),
    __param(2, (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService)),
    __param(3, (0, inversify_1.inject)(preferences_1.PreferenceService)),
    __param(4, (0, inversify_1.inject)(status_bar_view_model_1.StatusBarViewModel)),
    __param(5, (0, inversify_1.inject)(hover_service_1.HoverService)),
    __metadata("design:paramtypes", [Object, label_parser_1.LabelParser,
        frontend_application_state_1.FrontendApplicationStateService, Object, status_bar_view_model_1.StatusBarViewModel,
        hover_service_1.HoverService])
], StatusBarImpl);
exports.StatusBarImpl = StatusBarImpl;
//# sourceMappingURL=status-bar.js.map