/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.ls.core.internal.BuildWorkspaceStatus;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;

public class BuildWorkspaceHandler {
    private final ProjectsManager projectsManager;

    public BuildWorkspaceHandler(ProjectsManager projectsManager) {
        this.projectsManager = projectsManager;
    }

    public BuildWorkspaceStatus buildWorkspace(boolean forceReBuild, IProgressMonitor monitor) {
        try {
            IProject[] projects;
            if (monitor.isCanceled()) {
                return BuildWorkspaceStatus.CANCELLED;
            }
            this.projectsManager.cleanupResources(ProjectsManager.getDefaultProject());
            if (forceReBuild) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ResourcesPlugin.getWorkspace().build(15, (IProgressMonitor)subMonitor.split(50));
                ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)subMonitor.split(50));
            } else {
                ResourcesPlugin.getWorkspace().build(10, monitor);
            }
            ArrayList<IMarker> problemMarkers = new ArrayList<IMarker>();
            IProject[] iProjectArray = projects = ProjectUtils.getAllProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                List<IMarker> markers;
                IProject project = iProjectArray[n2];
                if (!project.equals((Object)ProjectsManager.getDefaultProject()) && (markers = ResourceUtils.getErrorMarkers((IResource)project)) != null) {
                    problemMarkers.addAll(markers);
                }
                ++n2;
            }
            List errors = problemMarkers.stream().filter(m -> m.getAttribute("severity", 0) == 2).map(e -> BuildWorkspaceHandler.convertMarker(e)).collect(Collectors.toList());
            if (errors.isEmpty()) {
                return BuildWorkspaceStatus.SUCCEED;
            }
            String newline = System.getProperty("line.separator");
            JavaLanguageServerPlugin.logError("Error occured while building workspace. Details: " + newline + String.join((CharSequence)newline, errors));
            return BuildWorkspaceStatus.WITH_ERROR;
        }
        catch (CoreException e2) {
            JavaLanguageServerPlugin.logException("Failed to build workspace.", e2);
            return BuildWorkspaceStatus.FAILED;
        }
        catch (OperationCanceledException e3) {
            return BuildWorkspaceStatus.CANCELLED;
        }
    }

    private static String convertMarker(IMarker marker) {
        int line;
        StringBuilder builder = new StringBuilder();
        String message = marker.getAttribute("message", "<no message>");
        String code = String.valueOf(marker.getAttribute("id", 0));
        builder.append(" message: ").append(message).append(";");
        builder.append(" code: ").append(code).append(";");
        IResource resource = marker.getResource();
        if (resource != null) {
            builder.append(" resource: ").append(resource.getLocation()).append(";");
        }
        if ((line = marker.getAttribute("lineNumber", -1)) > 0) {
            builder.append(" line: ").append(line);
        }
        return builder.toString();
    }
}

