/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.jdt.editor.listener;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swtbot.generator.framework.AnnotationRule;
import org.eclipse.swtbot.generator.jdt.editor.document.ClassDocument;
import org.eclipse.swtbot.generator.ui.BotGeneratorEventDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationSelectionListener
extends SelectionAdapter {
    protected ToolItem dropDown;
    protected Menu menu;
    protected Map<CTabItem, SourceViewer> tabViewer;
    protected CTabFolder classTabFolder;

    public AbstractAnnotationSelectionListener(ToolItem dropdown, BotGeneratorEventDispatcher recorder, Map<CTabItem, SourceViewer> tabViewer, CTabFolder classTabFolder) {
        this.dropDown = dropdown;
        this.menu = new Menu((Control)dropdown.getParent());
        this.tabViewer = tabViewer;
        this.classTabFolder = classTabFolder;
        this.addItems(recorder.getCurrentGenerator().createAnnotationRules());
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.detail == 4) {
            ToolItem item = (ToolItem)event.widget;
            Rectangle rect = item.getBounds();
            Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
            this.menu.setLocation(pt.x, pt.y + rect.height);
            this.menu.setVisible(true);
        }
    }

    public void addItems(List<AnnotationRule> items) {
        this.menu = new Menu((Control)this.dropDown.getParent());
        if (items != null) {
            List<AnnotationRule> filteredAnnotations = this.filterRules(items);
            for (AnnotationRule item : filteredAnnotations) {
                MenuItem menuItem = new MenuItem(this.menu, 32);
                menuItem.setText(item.getAnnotation());
                menuItem.setData((Object)item);
                menuItem.addSelectionListener((SelectionListener)this.getSelectionAdapter(menuItem));
            }
        }
        this.update();
    }

    public void update() {
        SourceViewer viewer = null;
        if (this.classTabFolder != null && this.tabViewer != null) {
            viewer = this.tabViewer.get(this.classTabFolder.getSelection());
        }
        if (viewer != null) {
            ClassDocument doc = (ClassDocument)viewer.getDocument();
            if (doc.getActiveMethod() != null && this.menu.getItems().length != 0) {
                this.dropDown.setEnabled(true);
                MenuItem[] menuItemArray = this.menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem i = menuItemArray[n2];
                    if (this.checkDocAnnotation(doc, i)) {
                        i.setSelection(true);
                    } else {
                        i.setSelection(false);
                    }
                    ++n2;
                }
            } else {
                this.dropDown.setEnabled(false);
            }
        } else {
            this.dropDown.setEnabled(false);
        }
    }

    protected abstract List<AnnotationRule> filterRules(List<AnnotationRule> var1);

    protected abstract SelectionAdapter getSelectionAdapter(MenuItem var1);

    protected abstract boolean checkDocAnnotation(ClassDocument var1, MenuItem var2);
}

