/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.shareproject;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.utility.ArrayStructuredContentProvider;
import org.eclipse.team.svn.ui.utility.ColumnedViewerComparator;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.ui.PlatformUI;

public class SelectRepositoryLocationPage
extends AbstractVerifiedWizardPage {
    protected boolean useExistingLocation;
    protected IRepositoryLocation location;
    protected TableViewer repositoriesView;
    protected IRepositoryLocation[] repositories;
    protected boolean importProject;

    public SelectRepositoryLocationPage(IRepositoryLocation[] repositories) {
        this(repositories, false);
    }

    public SelectRepositoryLocationPage(IRepositoryLocation[] repositories, boolean importProject) {
        super(SelectRepositoryLocationPage.class.getName(), SVNUIMessages.getString("SelectRepositoryLocationPage_Title" + SelectRepositoryLocationPage.getNationalizationSuffix(importProject)), SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNUIMessages.SelectRepositoryLocationPage_Description);
        this.repositories = repositories;
        this.useExistingLocation = true;
        this.location = this.repositories[0];
        this.importProject = importProject;
    }

    @Override
    protected Composite createControlImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label description = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 200;
        data.heightHint = this.convertHeightInCharsToPixels(2);
        description.setLayoutData((Object)data);
        description.setText(SVNUIMessages.getString("SelectRepositoryLocationPage_Hint" + SelectRepositoryLocationPage.getNationalizationSuffix(this.importProject)));
        Button addLocationButton = new Button(composite, 16);
        data = new GridData(768);
        addLocationButton.setText(SVNUIMessages.SelectRepositoryLocationPage_AddLocation);
        addLocationButton.setSelection(false);
        Button useExistingLocationButton = new Button(composite, 16);
        data = new GridData(768);
        useExistingLocationButton.setLayoutData((Object)data);
        useExistingLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                SelectRepositoryLocationPage.this.useExistingLocation = button.getSelection();
                SelectRepositoryLocationPage.this.repositoriesView.getTable().setEnabled(SelectRepositoryLocationPage.this.useExistingLocation);
                SelectRepositoryLocationPage.this.setPageComplete(true);
            }
        });
        useExistingLocationButton.setText(SVNUIMessages.SelectRepositoryLocationPage_UseLocation);
        useExistingLocationButton.setSelection(true);
        this.repositoriesView = SelectRepositoryLocationPage.createRepositoriesListTable(composite, this.repositories);
        this.repositoriesView.addDoubleClickListener(event -> {
            IWizard wizard = this.getWizard();
            IWizardPage nextPage = wizard.getNextPage((IWizardPage)this);
            if (nextPage != null) {
                wizard.getContainer().showPage(nextPage);
            }
        });
        this.repositoriesView.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)this.repositoriesView.getSelection();
            this.location = (IRepositoryLocation)selection.getFirstElement();
            this.setPageComplete(true);
        });
        IStructuredSelection selection = (IStructuredSelection)this.repositoriesView.getSelection();
        this.location = (IRepositoryLocation)selection.getFirstElement();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.reposLocationContext");
        return composite;
    }

    public boolean useExistingLocation() {
        return this.useExistingLocation;
    }

    public IRepositoryLocation getRepositoryLocation() {
        return this.useExistingLocation() ? this.location : null;
    }

    protected static String getNationalizationSuffix(boolean importProject) {
        return "_" + (importProject ? "Import" : "Share");
    }

    public static TableViewer createRepositoriesListTable(Composite parent, IRepositoryLocation[] repositories) {
        Table table = new Table(parent, 68356);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tLayout = new TableLayout();
        tLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        table.setLayout((Layout)tLayout);
        TableViewer repositoriesView = new TableViewer(table);
        ColumnedViewerComparator comparator = new ColumnedViewerComparator((Viewer)repositoriesView){

            @Override
            public int compareImpl(Viewer viewer, Object row1, Object row2) {
                IRepositoryLocation location1 = (IRepositoryLocation)row1;
                IRepositoryLocation location2 = (IRepositoryLocation)row2;
                if (this.column == 0) {
                    return ColumnedViewerComparator.compare(location1.getLabel(), location2.getLabel());
                }
                return ColumnedViewerComparator.compare(location1.getUrl(), location2.getUrl());
            }
        };
        TableColumn col = new TableColumn(table, 16384);
        col.setResizable(true);
        col.setText("Label");
        col.addSelectionListener((SelectionListener)comparator);
        col = new TableColumn(table, 16384);
        col.setResizable(true);
        col.setText("URL");
        col.addSelectionListener((SelectionListener)comparator);
        repositoriesView.setComparator((ViewerComparator)comparator);
        repositoriesView.getTable().setSortDirection(128);
        repositoriesView.getTable().setSortColumn(repositoriesView.getTable().getColumn(0));
        repositoriesView.setContentProvider((IContentProvider)new ArrayStructuredContentProvider());
        repositoriesView.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                IRepositoryLocation location = (IRepositoryLocation)element;
                if (columnIndex == 0) {
                    return location.getLabel();
                }
                return location.getUrlAsIs();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        repositoriesView.setInput((Object)repositories);
        repositoriesView.getTable().select(0);
        return repositoriesView;
    }
}

