/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.BatchingChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;
import org.eclipse.team.internal.ui.mapping.ResourceModelContentProvider;
import org.eclipse.team.internal.ui.mapping.ResourceModelLabelProvider;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.svn.core.mapping.SVNActiveChangeSet;
import org.eclipse.team.svn.core.mapping.SVNChangeSetModelProvider;
import org.eclipse.team.svn.core.mapping.SVNIncomingChangeSet;
import org.eclipse.team.svn.core.mapping.SVNUnassignedChangeSet;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.mapping.SVNChangeSetSorter;
import org.eclipse.team.svn.ui.mapping.SVNIncomingChangeSetCollector;
import org.eclipse.team.svn.ui.mapping.SVNModelParticipantChangeSetCapability;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorSorterService;

public class SVNChangeSetContentProvider
extends ResourceModelContentProvider
implements ITreePathContentProvider {
    private DiffChangeSet unassignedDiffs;
    private SVNIncomingChangeSetCollector incomingCollector;
    private boolean collectorInitialized;
    private IChangeSetChangeListener collectorListener = new CollectorListener();

    protected String getModelProviderId() {
        return "org.eclipse.team.svn.core.svnChangeSetModel";
    }

    protected boolean isVisibleInMode(ChangeSet set) {
        if (this.getViewer().getInput() instanceof SVNChangeSetModelProvider) {
            if (set instanceof ActiveChangeSet || set instanceof SVNUnassignedChangeSet) {
                return this.getConfiguration().getMode() != 1;
            }
            if (set instanceof DiffChangeSet) {
                return this.getConfiguration().getMode() != 2;
            }
        }
        return false;
    }

    protected boolean isEnabled() {
        Object input = this.getViewer().getInput();
        return input instanceof SVNChangeSetModelProvider;
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof ISynchronizationContext) {
            return new Object[0];
        }
        if (parent == this.getModelProvider()) {
            return this.getRootElements();
        }
        return super.getElements(parent);
    }

    private Object[] getRootElements() {
        DiffChangeSet[] sets;
        if (!this.collectorInitialized) {
            this.initializeCheckedInChangeSetCollector(this.getChangeSetCapability());
            this.collectorInitialized = true;
        }
        ArrayList<DiffChangeSet> result = new ArrayList<DiffChangeSet>();
        DiffChangeSet[] diffChangeSetArray = sets = this.getAllSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            DiffChangeSet set = diffChangeSetArray[n2];
            if (this.hasChildren(TreePath.EMPTY.createChildPath((Object)set)) || set instanceof ActiveChangeSet && ((ActiveChangeSet)set).isUserCreated()) {
                result.add(set);
            }
            ++n2;
        }
        if (!this.getUnassignedSet().isEmpty() && this.hasChildren(TreePath.EMPTY.createChildPath((Object)this.getUnassignedSet()))) {
            result.add(this.getUnassignedSet());
        }
        return result.toArray();
    }

    private synchronized DiffChangeSet getUnassignedSet() {
        if (this.unassignedDiffs == null) {
            this.unassignedDiffs = new SVNUnassignedChangeSet(SVNUIMessages.ChangeSetModel_UnassignedChangeSetTitle);
            this.addAllUnassignedToUnassignedSet();
        }
        return this.unassignedDiffs;
    }

    private void addAllUnassignedToUnassignedSet() {
        IResourceDiffTree allChanges = this.getContext().getDiffTree();
        ArrayList diffs = new ArrayList();
        allChanges.accept(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), diff -> {
            if (this.canAddToUnnassignedChangeSet(diff)) {
                diffs.add(diff);
            }
            return true;
        }, 2);
        this.unassignedDiffs.add(diffs.toArray(new IDiff[diffs.size()]));
    }

    private ResourceDiffTree getTheRest() {
        return (ResourceDiffTree)this.getUnassignedSet().getDiffTree();
    }

    protected boolean isContainedInSet(IDiff diff, ChangeSet[] sets) {
        ChangeSet[] changeSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set = changeSetArray[n2];
            if (set.contains(ResourceDiffTree.getResourceFor((IDiff)diff))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        if (object instanceof ChangeSet) {
            ChangeSet set = (ChangeSet)object;
            IResource[] resources = set.getResources();
            return new ResourceTraversal[]{new ResourceTraversal(resources, 0, 0)};
        }
        return super.getTraversals(context, object);
    }

    public Object[] getChildren(TreePath parentPath) {
        IResourceDiffTree diffTree;
        if (!this.isEnabled()) {
            return new Object[0];
        }
        if (parentPath.getSegmentCount() == 0) {
            return this.getRootElements();
        }
        Object first = parentPath.getFirstSegment();
        if (!this.isVisibleInMode(first)) {
            return new Object[0];
        }
        Object parent = parentPath.getLastSegment();
        if (first instanceof DiffChangeSet) {
            DiffChangeSet set = (DiffChangeSet)first;
            diffTree = set.getDiffTree();
            if (parent instanceof DiffChangeSet) {
                parent = this.getModelRoot();
            }
        } else {
            return new Object[0];
        }
        Object[] children = this.getChildren(parent);
        HashSet<Object> result = new HashSet<Object>();
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (this.isVisible(child, diffTree)) {
                result.add(child);
            }
            ++n2;
        }
        return result.toArray();
    }

    private boolean isVisibleInMode(Object first) {
        if (first instanceof ChangeSet) {
            ChangeSet changeSet = (ChangeSet)first;
            int mode = this.getConfiguration().getMode();
            switch (mode) {
                case 4: {
                    return true;
                }
                case 8: {
                    return this.containsConflicts(changeSet);
                }
                case 1: {
                    return changeSet instanceof SVNIncomingChangeSet || this.isUnassignedSet(changeSet) && this.hasIncomingChanges(changeSet);
                }
                case 2: {
                    return changeSet instanceof ActiveChangeSet || this.hasConflicts(changeSet) || this.isUnassignedSet(changeSet) && this.hasOutgoingChanges(changeSet);
                }
            }
        }
        return true;
    }

    private boolean hasIncomingChanges(ChangeSet changeSet) {
        if (changeSet instanceof DiffChangeSet) {
            return ((DiffChangeSet)changeSet).getDiffTree().countFor(512, 768) > 0L;
        }
        return false;
    }

    private boolean hasOutgoingChanges(ChangeSet ChangeSet2) {
        if (ChangeSet2 instanceof DiffChangeSet) {
            return ((DiffChangeSet)ChangeSet2).getDiffTree().countFor(256, 768) > 0L;
        }
        return false;
    }

    private boolean isUnassignedSet(ChangeSet changeSet) {
        return changeSet == this.unassignedDiffs;
    }

    private boolean hasConflicts(ChangeSet changeSet) {
        if (changeSet instanceof DiffChangeSet) {
            return ((DiffChangeSet)changeSet).getDiffTree().countFor(768, 768) > 0L;
        }
        return false;
    }

    private boolean containsConflicts(ChangeSet changeSet) {
        if (changeSet instanceof DiffChangeSet) {
            return ((DiffChangeSet)changeSet).getDiffTree().hasMatchingDiffs(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), ResourceModelLabelProvider.CONFLICT_FILTER);
        }
        return false;
    }

    private boolean isVisible(Object object, IResourceDiffTree tree) {
        if (object instanceof IResource) {
            IDiff[] diffs;
            IResource resource = (IResource)object;
            IDiff diff = tree.getDiff(resource);
            if (diff != null && this.isVisible(diff)) {
                return true;
            }
            IDiff[] iDiffArray = diffs = tree.getDiffs(resource, this.getTraversalCalculator().getLayoutDepth(resource, null));
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff diff2 = iDiffArray[n2];
                if (this.isVisible(diff2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean hasChildrenInContext(ChangeSet set) {
        IResource[] resources;
        IResource[] iResourceArray = resources = set.getResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            if (this.getContext().getDiffTree().getDiff(element) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasChildren(TreePath path) {
        Object first;
        if (path.getSegmentCount() == 1 && (first = path.getFirstSegment()) instanceof ChangeSet) {
            return this.isVisibleInMode(first) && this.hasChildrenInContext((ChangeSet)first);
        }
        return this.getChildren(path).length > 0;
    }

    public TreePath[] getParents(Object element) {
        if (element instanceof ChangeSet) {
            return new TreePath[]{TreePath.EMPTY};
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            DiffChangeSet[] sets = this.getSetsContaining(resource);
            if (sets.length > 0) {
                ArrayList<TreePath> result = new ArrayList<TreePath>();
                DiffChangeSet[] diffChangeSetArray = sets;
                int n = sets.length;
                int n2 = 0;
                while (n2 < n) {
                    DiffChangeSet set = diffChangeSetArray[n2];
                    TreePath path = this.getPathForElement(set, (IResource)resource.getParent());
                    if (path != null) {
                        result.add(path);
                    }
                    ++n2;
                }
                return result.toArray(new TreePath[result.size()]);
            }
            TreePath path = this.getPathForElement(this.getUnassignedSet(), (IResource)resource.getParent());
            if (path != null) {
                return new TreePath[]{path};
            }
        }
        return new TreePath[0];
    }

    private DiffChangeSet[] getOutgoingSets() {
        ArrayList<DiffChangeSet> result = new ArrayList<DiffChangeSet>();
        ChangeSetCapability changeSetCapability = this.getChangeSetCapability();
        if (changeSetCapability != null && changeSetCapability.supportsActiveChangeSets()) {
            ChangeSet[] sets;
            ActiveChangeSetManager collector = changeSetCapability.getActiveChangeSetManager();
            ChangeSet[] changeSetArray = sets = collector.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeSet set = changeSetArray[n2];
                result.add((DiffChangeSet)set);
                ++n2;
            }
        }
        return result.toArray(new DiffChangeSet[result.size()]);
    }

    private DiffChangeSet[] getAllSets() {
        int n;
        ArrayList<DiffChangeSet> result = new ArrayList<DiffChangeSet>();
        ChangeSetCapability changeSetCapability = this.getChangeSetCapability();
        if (changeSetCapability != null && changeSetCapability.supportsActiveChangeSets()) {
            ChangeSet[] sets;
            ActiveChangeSetManager collector = changeSetCapability.getActiveChangeSetManager();
            ChangeSet[] changeSetArray = sets = collector.getSets();
            int n2 = sets.length;
            n = 0;
            while (n < n2) {
                ChangeSet set = changeSetArray[n];
                result.add((DiffChangeSet)set);
                ++n;
            }
        }
        if (this.incomingCollector != null) {
            ChangeSet[] sets;
            ChangeSet[] changeSetArray = sets = this.incomingCollector.getSets();
            n = sets.length;
            int n3 = 0;
            while (n3 < n) {
                ChangeSet set = changeSetArray[n3];
                result.add((DiffChangeSet)set);
                ++n3;
            }
        }
        return result.toArray(new DiffChangeSet[result.size()]);
    }

    private DiffChangeSet[] getSetsContaining(IResource resource) {
        DiffChangeSet[] allSets;
        ArrayList<DiffChangeSet> result = new ArrayList<DiffChangeSet>();
        DiffChangeSet[] diffChangeSetArray = allSets = this.getAllSets();
        int n = allSets.length;
        int n2 = 0;
        while (n2 < n) {
            DiffChangeSet set = diffChangeSetArray[n2];
            if (this.isVisible(resource, set.getDiffTree())) {
                result.add(set);
            }
            ++n2;
        }
        return result.toArray(new DiffChangeSet[result.size()]);
    }

    private TreePath getPathForElement(DiffChangeSet set, IResource resource) {
        List<Object> pathList = this.getPath(set.getDiffTree(), resource);
        if (pathList != null) {
            pathList.add(0, set);
            TreePath path = new TreePath(pathList.toArray());
            return path;
        }
        return null;
    }

    private List<Object> getPath(IResourceDiffTree tree, IResource resource) {
        boolean hasDiff;
        if (resource == null) {
            return null;
        }
        boolean bl = hasDiff = tree.getDiff(resource) == null;
        if (hasDiff && tree.members(resource).length == 0 || resource.getType() == 8) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(resource.getProject());
        if (resource.getType() != 4) {
            String layout = this.getTraversalCalculator().getLayout();
            if (layout.equals("org.eclipse.team.ui.flay_layout") || layout.equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 2) {
                result.add(resource);
            } else if (layout.equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 1) {
                IContainer parent = resource.getParent();
                if (parent.getType() != 4) {
                    result.add(parent);
                }
                result.add(resource);
            } else {
                ArrayList<IResource> resourcePath = new ArrayList<IResource>();
                IResource next = resource;
                while (next.getType() != 4) {
                    resourcePath.add(next);
                    next = next.getParent();
                }
                int i = resourcePath.size() - 1;
                while (i >= 0) {
                    result.add(resourcePath.get(i));
                    --i;
                }
            }
        }
        return result;
    }

    public void init(ICommonContentExtensionSite site) {
        SVNChangeSetSorter sorter;
        super.init(site);
        ChangeSetCapability capability = this.getChangeSetCapability();
        if (capability.supportsActiveChangeSets()) {
            ActiveChangeSetManager collector = capability.getActiveChangeSetManager();
            collector.addListener(this.collectorListener);
        }
        if ((sorter = this.getSorter()) != null) {
            sorter.setConfiguration(this.getConfiguration());
        }
    }

    private SVNChangeSetSorter getSorter() {
        INavigatorContentService content = this.getExtensionSite().getService();
        INavigatorSorterService sorting = content.getSorterService();
        INavigatorContentExtension extension = this.getExtensionSite().getExtension();
        if (extension != null) {
            sorting.findSorter(extension.getDescriptor(), (Object)this.getModelProvider(), (Object)new DiffChangeSet(), (Object)new DiffChangeSet());
        }
        return null;
    }

    private void initializeCheckedInChangeSetCollector(ChangeSetCapability capability) {
        if (capability.supportsCheckedInChangeSets()) {
            this.incomingCollector = ((SVNModelParticipantChangeSetCapability)capability).createIncomingChangeSetCollector(this.getConfiguration());
            this.incomingCollector.addListener(this.collectorListener);
            this.incomingCollector.add(((ResourceDiffTree)this.getContext().getDiffTree()).getDiffs());
        }
    }

    public void dispose() {
        ChangeSetCapability capability = this.getChangeSetCapability();
        if (capability.supportsActiveChangeSets()) {
            capability.getActiveChangeSetManager().removeListener(this.collectorListener);
        }
        if (this.incomingCollector != null) {
            this.incomingCollector.removeListener(this.collectorListener);
            this.incomingCollector.dispose();
        }
        super.dispose();
    }

    public IResourceDiffTree getDiffTree(TreePath path) {
        Object first;
        if (path.getSegmentCount() > 0 && (first = path.getFirstSegment()) instanceof DiffChangeSet) {
            DiffChangeSet set = (DiffChangeSet)first;
            return set.getDiffTree();
        }
        return this.getTheRest();
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        IPath[] removed = event.getRemovals();
        IDiff[] added = event.getAdditions();
        IDiff[] changed = event.getChanges();
        try {
            this.getTheRest().beginInput();
            IPath[] iPathArray = removed;
            int n = removed.length;
            int n2 = 0;
            while (n2 < n) {
                IPath element = iPathArray[n2];
                this.getTheRest().remove(element);
                ++n2;
            }
            this.doDiffsChanged(added);
            this.doDiffsChanged(changed);
        }
        finally {
            this.getTheRest().endInput(monitor);
        }
        if (this.incomingCollector != null) {
            this.incomingCollector.handleChange(event);
        }
        UIMonitorUtility.getDisplay().asyncExec(() -> {
            AbstractTreeViewer viewer = (AbstractTreeViewer)this.getViewer();
            viewer.refresh();
        });
    }

    protected void doDiffsChanged(IDiff[] diff) {
        IDiff[] iDiffArray = diff;
        int n = diff.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff element = iDiffArray[n2];
            if (!this.isContainedInSet(element, (ChangeSet[])this.getOutgoingSets())) {
                if (this.hasLocalChanges(element)) {
                    this.getTheRest().add(element);
                } else {
                    this.getTheRest().remove(element.getPath());
                }
            }
            ++n2;
        }
    }

    protected boolean canAddToUnnassignedChangeSet(IDiff diff) {
        if (!this.isContainedInSet(diff, (ChangeSet[])this.getOutgoingSets())) {
            return this.hasLocalChanges(diff);
        }
        return false;
    }

    protected boolean hasLocalChanges(IDiff diff) {
        try {
            UpdateSubscriber subscriber = UpdateSubscriber.instance();
            AbstractSVNSyncInfo syncInfo = (AbstractSVNSyncInfo)subscriber.getSyncInfo(ResourceDiffTree.getResourceFor((IDiff)diff));
            if (syncInfo != null && (SyncInfo.getDirection((int)syncInfo.getKind()) & 4) != 0) {
                return true;
            }
        }
        catch (Exception e) {
            LoggedOperation.reportError((String)SVNChangeSetContentProvider.class.getName(), (Throwable)e);
        }
        return false;
    }

    protected void updateLabels(ISynchronizationContext context, IPath[] paths) {
        super.updateLabels(context, paths);
        Object[] sets = this.getSetsShowingPropogatedStateFrom(paths);
        if (sets.length > 0) {
            ((AbstractTreeViewer)this.getViewer()).update(sets, null);
        }
    }

    private ChangeSet[] getSetsShowingPropogatedStateFrom(IPath[] paths) {
        HashSet result = new HashSet();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            DiffChangeSet[] sets = this.getSetsShowingPropogatedStateFrom(path);
            Collections.addAll(result, sets);
            ++n2;
        }
        return result.toArray(new ChangeSet[result.size()]);
    }

    protected DiffChangeSet[] getSetsShowingPropogatedStateFrom(IPath path) {
        DiffChangeSet[] allSets;
        ArrayList<DiffChangeSet> result = new ArrayList<DiffChangeSet>();
        DiffChangeSet[] diffChangeSetArray = allSets = this.getAllSets();
        int n = allSets.length;
        int n2 = 0;
        while (n2 < n) {
            DiffChangeSet set = diffChangeSetArray[n2];
            if (set.getDiffTree().getDiff(path) != null || set.getDiffTree().getChildren(path).length > 0) {
                result.add(set);
            }
            ++n2;
        }
        return result.toArray(new DiffChangeSet[result.size()]);
    }

    public ChangeSetCapability getChangeSetCapability() {
        ISynchronizeParticipant participant = this.getConfiguration().getParticipant();
        if (participant instanceof IChangeSetProvider) {
            IChangeSetProvider provider = (IChangeSetProvider)participant;
            return provider.getChangeSetCapability();
        }
        return null;
    }

    private HashSet<ChangeSet> getVisibleSetsInViewer() {
        TreeViewer viewer = (TreeViewer)this.getViewer();
        Tree tree = viewer.getTree();
        TreeItem[] children = tree.getItems();
        HashSet<ChangeSet> result = new HashSet<ChangeSet>();
        TreeItem[] treeItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem control = treeItemArray[n2];
            Object data = control.getData();
            if (data instanceof ChangeSet) {
                ChangeSet set = (ChangeSet)data;
                result.add(set);
            }
            ++n2;
        }
        return result;
    }

    private final class CollectorListener
    implements IChangeSetChangeListener,
    BatchingChangeSetManager.IChangeSetCollectorChangeListener {
        private CollectorListener() {
        }

        public void setAdded(ChangeSet set) {
            if (set instanceof ActiveChangeSet) {
                DiffChangeSet unassigned = SVNChangeSetContentProvider.this.getUnassignedSet();
                unassigned.remove(set.getResources());
                if (SVNChangeSetContentProvider.this.isVisibleInMode(set)) {
                    UIMonitorUtility.getDisplay().syncExec(() -> {
                        AbstractTreeViewer viewer = (AbstractTreeViewer)SVNChangeSetContentProvider.this.getViewer();
                        viewer.getControl().setRedraw(false);
                        try {
                            viewer.add(viewer.getInput(), (Object)set);
                            if (unassigned.isEmpty()) {
                                viewer.remove((Object)unassigned);
                            }
                        }
                        finally {
                            viewer.getControl().setRedraw(true);
                        }
                    });
                }
            }
        }

        public void defaultSetChanged(ChangeSet previousDefault, ChangeSet set) {
            if (SVNChangeSetContentProvider.this.isVisibleInMode(set) || SVNChangeSetContentProvider.this.isVisibleInMode(previousDefault)) {
                UIMonitorUtility.getDisplay().syncExec(() -> {
                    AbstractTreeViewer viewer = (AbstractTreeViewer)SVNChangeSetContentProvider.this.getViewer();
                    viewer.getControl().setRedraw(false);
                    try {
                        if (previousDefault != null) {
                            viewer.refresh((Object)previousDefault, true);
                        }
                        if (set != null) {
                            viewer.refresh((Object)set, true);
                        }
                    }
                    finally {
                        viewer.getControl().setRedraw(true);
                    }
                });
            }
        }

        public void setRemoved(ChangeSet set) {
            if (set instanceof ActiveChangeSet) {
                this.handleSetRemoval(set);
                if (SVNChangeSetContentProvider.this.isVisibleInMode(set)) {
                    UIMonitorUtility.getDisplay().syncExec(() -> {
                        AbstractTreeViewer viewer = (AbstractTreeViewer)SVNChangeSetContentProvider.this.getViewer();
                        viewer.getControl().setRedraw(false);
                        try {
                            viewer.remove((Object)set);
                            DiffChangeSet unassigned = SVNChangeSetContentProvider.this.getUnassignedSet();
                            if (!unassigned.isEmpty()) {
                                viewer.add(viewer.getInput(), (Object)unassigned);
                            }
                        }
                        finally {
                            viewer.getControl().setRedraw(true);
                        }
                    });
                }
            }
        }

        private void handleSetRemoval(ChangeSet set) {
            IResource[] resources = set.getResources();
            ArrayList<IDiff> toAdd = new ArrayList<IDiff>();
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource element = iResourceArray[n2];
                IDiff diff = SVNChangeSetContentProvider.this.getContext().getDiffTree().getDiff(element);
                if (diff != null) {
                    toAdd.add(diff);
                }
                ++n2;
            }
            SVNChangeSetContentProvider.this.getUnassignedSet().add(toAdd.toArray(new IDiff[toAdd.size()]));
        }

        public void nameChanged(ChangeSet set) {
            if (SVNChangeSetContentProvider.this.isVisibleInMode(set)) {
                UIMonitorUtility.getDisplay().syncExec(() -> {
                    AbstractTreeViewer viewer = (AbstractTreeViewer)SVNChangeSetContentProvider.this.getViewer();
                    viewer.update((Object)set, null);
                });
            }
        }

        public void resourcesChanged(ChangeSet set, IPath[] paths) {
            if (set instanceof ActiveChangeSet) {
                this.handleSetChange(set, paths);
                if (SVNChangeSetContentProvider.this.isVisibleInMode(set)) {
                    UIMonitorUtility.getDisplay().syncExec(() -> {
                        AbstractTreeViewer viewer = (AbstractTreeViewer)SVNChangeSetContentProvider.this.getViewer();
                        viewer.getControl().setRedraw(false);
                        try {
                            if (SVNChangeSetContentProvider.this.hasChildrenInContext(set)) {
                                if (SVNChangeSetContentProvider.this.getVisibleSetsInViewer().contains(set)) {
                                    viewer.refresh((Object)set, true);
                                } else {
                                    viewer.add(viewer.getInput(), (Object)set);
                                }
                            } else if (!(set instanceof SVNActiveChangeSet) || !((SVNActiveChangeSet)set).isManagedExternally()) {
                                viewer.remove((Object)set);
                            }
                            DiffChangeSet unassigned = SVNChangeSetContentProvider.this.getUnassignedSet();
                            if (!unassigned.isEmpty()) {
                                viewer.add(viewer.getInput(), (Object)unassigned);
                            } else {
                                viewer.remove((Object)unassigned);
                            }
                        }
                        finally {
                            viewer.getControl().setRedraw(true);
                        }
                    });
                }
            }
        }

        private void handleSetChange(ChangeSet set, IPath[] paths) {
            try {
                SVNChangeSetContentProvider.this.getTheRest().beginInput();
                IPath[] iPathArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path = iPathArray[n2];
                    if (((DiffChangeSet)set).contains(path)) {
                        diff = ((DiffChangeSet)set).getDiffTree().getDiff(path);
                        if (diff != null) {
                            SVNChangeSetContentProvider.this.getTheRest().remove(ResourceDiffTree.getResourceFor((IDiff)diff));
                        }
                    } else {
                        diff = SVNChangeSetContentProvider.this.getContext().getDiffTree().getDiff(path);
                        if (diff != null && SVNChangeSetContentProvider.this.canAddToUnnassignedChangeSet(diff)) {
                            SVNChangeSetContentProvider.this.getTheRest().add(diff);
                        }
                    }
                    ++n2;
                }
            }
            finally {
                SVNChangeSetContentProvider.this.getTheRest().endInput(null);
            }
        }

        public void changeSetChanges(BatchingChangeSetManager.CollectorChangeEvent event, IProgressMonitor monitor) {
            ChangeSet[] addedSets = event.getAddedSets();
            ChangeSet[] visibleAddedSets = this.getVisibleSets(addedSets);
            ChangeSet[] removedSets = event.getRemovedSets();
            ChangeSet[] visibleRemovedSets = this.getVisibleSets(removedSets);
            ChangeSet[] changedSets = event.getChangedSets();
            ChangeSet[] visibleChangedSets = this.getVisibleSets(changedSets);
            DiffChangeSet unassigned = SVNChangeSetContentProvider.this.getUnassignedSet();
            try {
                SVNChangeSetContentProvider.this.getTheRest().beginInput();
                ChangeSet[] changeSetArray = addedSets;
                int n = addedSets.length;
                int n2 = 0;
                while (n2 < n) {
                    ChangeSet addedSet = changeSetArray[n2];
                    unassigned.remove(addedSet.getResources());
                    ++n2;
                }
                if (removedSets.length > 0) {
                    SVNChangeSetContentProvider.this.addAllUnassignedToUnassignedSet();
                }
                changeSetArray = changedSets;
                n = changedSets.length;
                n2 = 0;
                while (n2 < n) {
                    ChangeSet set = changeSetArray[n2];
                    IPath[] paths = event.getChangesFor(set);
                    if (event.getSource().contains(set)) {
                        this.handleSetChange(set, paths);
                    } else {
                        try {
                            SVNChangeSetContentProvider.this.getTheRest().beginInput();
                            IPath[] iPathArray = paths;
                            int n3 = paths.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IPath path = iPathArray[n4];
                                IDiff diff = SVNChangeSetContentProvider.this.getContext().getDiffTree().getDiff(path);
                                if (diff != null && SVNChangeSetContentProvider.this.canAddToUnnassignedChangeSet(diff)) {
                                    SVNChangeSetContentProvider.this.getTheRest().add(diff);
                                }
                                ++n4;
                            }
                        }
                        finally {
                            SVNChangeSetContentProvider.this.getTheRest().endInput(null);
                        }
                    }
                    ++n2;
                }
            }
            finally {
                SVNChangeSetContentProvider.this.getTheRest().endInput(monitor);
            }
            if (visibleAddedSets.length > 0 || visibleRemovedSets.length > 0 || visibleChangedSets.length > 0) {
                UIMonitorUtility.getDisplay().syncExec(() -> {
                    AbstractTreeViewer viewer = (AbstractTreeViewer)SVNChangeSetContentProvider.this.getViewer();
                    try {
                        int n;
                        int n2;
                        ChangeSet[] changeSetArray4;
                        viewer.getControl().setRedraw(false);
                        if (visibleAddedSets.length > 0) {
                            viewer.add(viewer.getInput(), (Object[])visibleAddedSets);
                        }
                        if (visibleRemovedSets.length > 0) {
                            changeSetArray4 = visibleRemovedSets;
                            n2 = visibleRemovedSets.length;
                            n = 0;
                            while (n < n2) {
                                ChangeSet visibleRemovedSet = changeSetArray4[n];
                                if (!(visibleRemovedSet instanceof SVNActiveChangeSet) || !((SVNActiveChangeSet)visibleRemovedSet).isManagedExternally()) {
                                    viewer.remove((Object)visibleRemovedSet);
                                }
                                ++n;
                            }
                        }
                        changeSetArray4 = visibleChangedSets;
                        n2 = visibleChangedSets.length;
                        n = 0;
                        while (n < n2) {
                            ChangeSet visibleChangedSet = changeSetArray4[n];
                            viewer.refresh((Object)visibleChangedSet, true);
                            ++n;
                        }
                        if (!unassigned.isEmpty()) {
                            viewer.add(viewer.getInput(), (Object)unassigned);
                        } else {
                            viewer.remove((Object)unassigned);
                        }
                    }
                    finally {
                        viewer.getControl().setRedraw(true);
                    }
                });
            }
        }

        private ChangeSet[] getVisibleSets(ChangeSet[] sets) {
            ArrayList<ChangeSet> result = new ArrayList<ChangeSet>();
            ChangeSet[] changeSetArray = sets;
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeSet set = changeSetArray[n2];
                if (SVNChangeSetContentProvider.this.isVisibleInMode(set)) {
                    result.add(set);
                }
                ++n2;
            }
            return result.toArray(new ChangeSet[result.size()]);
        }
    }
}

