/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.crashrecovery;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.crashrecovery.ErrorDescription;
import org.eclipse.team.svn.core.extension.crashrecovery.IResolutionHelper;
import org.eclipse.team.svn.core.extension.factory.ISVNConnectorFactory;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.crashrecovery.invalidmeta.ValidConnectorsSelectionPanel;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class InvalidMetaHelper
implements IResolutionHelper {
    public boolean acquireResolution(ErrorDescription description) {
        if (description.code == ErrorDescription.CANNOT_READ_PROJECT_METAINFORMATION) {
            String path;
            IProject project = (IProject)description.context;
            IPath location = project.getLocation();
            if (location == null || !location.append(SVNUtility.getSVNFolderName()).toFile().exists()) {
                return false;
            }
            ISVNConnectorFactory current = CoreExtensionsManager.instance().getSVNConnectorFactory();
            if (this.isValid(current, path = location.toString())) {
                return true;
            }
            ArrayList<ISVNConnectorFactory> valid = new ArrayList<ISVNConnectorFactory>();
            for (ISVNConnectorFactory factory : CoreExtensionsManager.instance().getAccessibleClients()) {
                if (!this.isValid(factory, path)) continue;
                valid.add(factory);
            }
            if (valid.size() == 0) {
                return false;
            }
            boolean[] solved = new boolean[1];
            UIMonitorUtility.parallelSyncExec(() -> {
                DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), new ValidConnectorsSelectionPanel(project, valid));
                blArray[0] = dialog.open() == 0;
            });
            return solved[0];
        }
        return false;
    }

    protected boolean isValid(ISVNConnectorFactory factory, String path) {
        boolean bl;
        ISVNConnector proxy = factory.createConnector();
        try {
            SVNChangeStatus[] st = SVNUtility.status((ISVNConnector)proxy, (String)path, (SVNDepth)SVNDepth.IMMEDIATES, (long)128L, (ISVNProgressMonitor)new SVNNullProgressMonitor());
            bl = st != null && st.length > 0;
        }
        catch (Throwable throwable) {
            try {
                proxy.dispose();
                throw throwable;
            }
            catch (Throwable throwable2) {
                return false;
            }
        }
        proxy.dispose();
        return bl;
    }
}

